package es.caib.ibkey.oppenoffice.helper;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Vector;

import org.apache.log4j.Logger;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XPropertyReplace;
import com.sun.star.util.XRefreshable;
import com.sun.star.util.XReplaceDescriptor;
import com.sun.star.util.XReplaceable;
import com.sun.star.util.XSearchDescriptor;
import com.sun.star.util.XSearchable;

import es.caib.ibkey.bpm.conversion.exception.ConversionException;

public class OOReplaceFieldsHelper {

	/**Logger definit per a la classe **/
	public Logger log = Logger.getLogger(OOReplaceFieldsHelper.class);
	
	/**Connector amb l'openOffice **/
	protected BootstrapConnector connector=null;

	/**host al que es troba la instància d'openoffice que es vol fer servir **/
	protected  String host=System.getProperty("openoffice.host");
	/**port al que està escoltant la instància de l'openoffice **/
	protected  String port=System.getProperty("openoffice.port");
	/** pipe amb la que es pot comunicar amb l'openoffice **/
	protected  String pipe=System.getProperty("openoffice.pipe");

	/**Directori d'instal.lació local de l'openoffice. Necessari en cas que la instància destí de l'openoffice sigui localhost **/
	protected  String openofficeInstallDir=System.getProperty("openoffice.folder");

	public String overwrite="false";	
	
	
	/**
	 * Abre un documento admitido por openoffice en local.
	 * Desprotege todas las secciones protegidas del documento.
	 * Sustituye todas las ocurrencias en el documento de las entradas en table.
	 * Exporta el documento en el formato especificado.
	 * 
	 * @param ficheroOrigen
	 * @param ficheroSalida
	 * @param table
	 * @param stringConvertType
	 * @param filterOptions
	 * @return
	 * @throws Exception
	 */
	public String replaceFieldsAndConvert(File ficheroOrigen,String ficheroSalida,Map table,String stringConvertType, Map filterOptions) throws Exception{
    	log.info("Inici de substitució de camps del document.");
        XComponentLoader xcomponentloader = null;
        XComponentContext xContext = null;
        
        String stringConvertedFile = "";
        
        try{   

            // get the remote office component context
        	connector=new BootstrapConnector(openofficeInstallDir);
        	if(host!=null){
        		xContext = connector.connect("-accept=socket,host="+host+",port="+port+";urp;", "socket,host="+host+",port="+port+"");
        	}else{
        		if(pipe==null) pipe="OOPipe_"+new Random().nextInt();
        		xContext = connector.connect("-accept=pipe,name="+pipe+";urp;", "pipe,name="+pipe+";urp;StarOffice.ComponentContext");
        	}
            // get the remote office service manager
            com.sun.star.lang.XMultiComponentFactory xMCF = xContext.getServiceManager();
            
            Object oDesktop = xMCF.createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
        
            xcomponentloader = (com.sun.star.frame.XComponentLoader)
                UnoRuntime.queryInterface(com.sun.star.frame.XComponentLoader.class, oDesktop);
            
            // Preparing properties for loading the document
            PropertyValue componentLoaderPropertyvalue[] = new PropertyValue[ 1 ];
            // Setting the flag for hidding the open document
            componentLoaderPropertyvalue[ 0 ] = new PropertyValue();
            componentLoaderPropertyvalue[ 0 ].Name = "Hidden";
            componentLoaderPropertyvalue[ 0 ].Value = new Boolean(true);
            
            // Loading the wanted document
            Object objectDocumentToStore=null;
            
            
        	ficheroSalida=(!ficheroSalida.startsWith("file:///"))? "file:///" +ficheroSalida:ficheroSalida;

        	String ficheroEntrada="file:///" +ficheroOrigen.getAbsolutePath();
        	
        	objectDocumentToStore = xcomponentloader.loadComponentFromURL(
        			ficheroEntrada.replaceAll("\\\\","/"), "_blank", 0, componentLoaderPropertyvalue ); 
            	

            
            // Getting an object that will offer a simple way to store a document to a URL.
            XStorable xstorable =
                ( XStorable ) UnoRuntime.queryInterface( XStorable.class,
                                                         objectDocumentToStore );
            
            if(xstorable==null)
            	throw new ConversionException("El format del document d'entrada no és vàlid per a realitzar el canvi de format.");
          
            unprotectDocument(xstorable);
            replace(table, xstorable);
            
            
            Vector filterProperties=new Vector();
            // Preparing properties for converting the document
            // Setting the flag for overwriting
            PropertyValue fprop= new PropertyValue();
            fprop.Name = "Overwrite";
            fprop.Value = new Boolean(true);
            filterProperties.add(fprop);
            // Setting the filter name
            fprop= new PropertyValue();
            fprop.Name = "FilterName";
            fprop.Value = stringConvertType;
            filterProperties.add(fprop);

           
            //Setting Filter configuration           
            Vector filterData=new Vector();
    		//defaults PDF/A for pdf conversions
            if(filterOptions==null || (stringConvertType.toLowerCase().contains("pdf") && filterOptions.get("SelectPdfVersion")==null)){
            	PropertyValue fdata=new PropertyValue();	
            	fdata.Name = "SelectPdfVersion";
            	fdata.Value = new Integer(1);
            	filterData.add(fdata);
	            
            }
            
            //sets filter options received via argument
            if(filterOptions!=null){
	            Iterator it=filterOptions.keySet().iterator();
	            while(it.hasNext()){
	            	String propertyName=(String)it.next();
	            	
	            	PropertyValue fdata=new PropertyValue();	
	            	fdata.Name = propertyName; 
	            	fdata.Value = filterOptions.get(propertyName);
	            	filterData.add(fdata);
	            	
	            }
            }
            
            if(filterData.size()!=0){
	            fprop= new PropertyValue();
	            fprop.Name = "FilterData";
	            fprop.Value = (PropertyValue[])filterData.toArray(new PropertyValue[filterData.size()]);
	            filterProperties.add(fprop);
            }

            // Storing and converting the document
            ficheroSalida=ficheroSalida.replaceAll("\\\\","/");
            xstorable.storeToURL( ficheroSalida, (PropertyValue[])filterProperties.toArray(new PropertyValue[filterProperties.size()]) );
            
            XCloseable xcloseable = (XCloseable)UnoRuntime.queryInterface( XCloseable.class,xstorable );
            
            // Closing the converted document
            if ( xcloseable != null )
                xcloseable.close(false);
            else {
                // If Xcloseable is not supported (older versions,
                // use dispose() for closing the document
                XComponent xComponent = ( XComponent ) UnoRuntime.queryInterface(
                    XComponent.class, xstorable );
                xComponent.dispose();
            }
            
    
	        if ( stringConvertedFile.startsWith( "file:///" ) ) {
	            // Truncating the beginning of the file name
	            stringConvertedFile = stringConvertedFile.substring( 8 );
	        }
	        log.info("Conversió de format de document realitzada amb èxit.");
        // Returning the name of the converted file
    	}catch(Throwable th){
    		Logger.getLogger(OpenOfficeDocumentConversionHelper.class).error(th.getMessage(),th);
			String message=th.getMessage();
			if(th instanceof ErrorCodeIOException)
				message+=": "+((ErrorCodeIOException)th).ErrCode;
    		Exception e1=new Exception(message);
			e1.setStackTrace(th.getStackTrace());
			log.error(e1.getMessage(),e1);
			throw e1;
    	}finally{
    	 	try{
    	 		if(connector!=null) connector.disconnect();
    	 	}catch(Throwable t){}
    	}
        return stringConvertedFile;
       
	}
	
	/**
	 * Desprotege todas las secciones protegidas del documento openoffice
	 * @param xDocument
	 * @throws NoSuchElementException
	 * @throws WrappedTargetException
	 * @throws UnknownPropertyException
	 * @throws PropertyVetoException
	 * @throws IllegalArgumentException
	 */
	private void unprotectDocument(XStorable xDocument) throws NoSuchElementException, WrappedTargetException, UnknownPropertyException,  PropertyVetoException, IllegalArgumentException {
		//contrassenya de les seccions protegides: seguretat12345678
		XTextDocument xTextDocument = (XTextDocument) UnoRuntime.queryInterface(XTextDocument.class, xDocument);
		XTextSectionsSupplier xSectionsSupplier=(XTextSectionsSupplier)UnoRuntime.queryInterface(XTextSectionsSupplier.class,xTextDocument);
		XNameAccess sectionNameAccess=xSectionsSupplier.getTextSections();
		String sectionNames[]=sectionNameAccess.getElementNames();
		
		for(int i=0;i<sectionNameAccess.getElementNames().length;i++){
			Object xSection=sectionNameAccess.getByName(sectionNames[i]);
			XPropertySet xTextProps = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class,xSection);
			xTextProps.setPropertyValue("IsProtected", new Boolean(false));

		}
		
	}

	/**
	 * Sustituye todas las ocurrencias en el documento de todas las entradas en table por sus respectivos valroes
	 * 
	 * @param table
	 * @param xDocument
	 * @throws UnknownPropertyException
	 * @throws PropertyVetoException
	 * @throws IllegalArgumentException
	 * @throws WrappedTargetException
	 */
	public void replace(Map table, XStorable xDocument) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException{

		XTextDocument xTextDocument = (XTextDocument) UnoRuntime.queryInterface(XTextDocument.class, xDocument); 
		XReplaceable xReplaceable =  (XReplaceable) UnoRuntime.queryInterface(XReplaceable.class, xTextDocument);

		
		//por cada elemento a reemplazar de la tabla
		//guardamos formato y reemplazamos
		Iterator it=table.keySet().iterator();
		while(it.hasNext()){
			String key=(String)it.next();
			String reemplazo=(table.get(key)!=null)?(String)(table.get(key).toString()):null;
			
			XReplaceDescriptor xRepDesc = xReplaceable.createReplaceDescriptor(); 
			xRepDesc.setSearchString(key);
			// set the string to be inserted


			//procedemos a guardar el formato antes de que éste sea sustituido
			XSearchable _oSearcheable = (XSearchable) UnoRuntime.queryInterface(XReplaceable.class, xTextDocument);
			XSearchDescriptor xSearchDescr = _oSearcheable.createSearchDescriptor(); 
			xSearchDescr.setSearchString(key);
			xSearchDescr.setPropertyValue("SearchCaseSensitive", new Boolean(false));
			xSearchDescr.setPropertyValue("SearchWords", new Boolean(true));
			XInterface xTextRange  = (XInterface) _oSearcheable.findFirst(xSearchDescr);
			if (xTextRange!= null){ 
				PropertyValue[] aReplaceArgs  = new PropertyValue[5];
				XPropertySet xTextProps = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class,xTextRange);
				    
				        
				aReplaceArgs[0] = new PropertyValue();
				aReplaceArgs[0].Name = "CharWeight";
				aReplaceArgs[0].Value = xTextProps.getPropertyValue("CharWeight"); //Negrita
				 
				aReplaceArgs[1] = new PropertyValue();
				aReplaceArgs[1].Name = "CharPosture";
				aReplaceArgs[1].Value = xTextProps.getPropertyValue("CharPosture"); //cursiva
				 
				aReplaceArgs[2] = new PropertyValue();
				aReplaceArgs[2].Name = "CharUnderline";
				aReplaceArgs[2].Value = xTextProps.getPropertyValue("CharUnderline") ; //subrayado
				 
				 
				aReplaceArgs[3] = new PropertyValue();
				aReplaceArgs[3].Name = "CharHeight";
				aReplaceArgs[3].Value = xTextProps.getPropertyValue("CharHeight"); //tamaño de la fuente
				 
				 
				aReplaceArgs[4] = new PropertyValue();
				aReplaceArgs[4].Name = "CharFontName";
				aReplaceArgs[4].Value = xTextProps.getPropertyValue("CharFontName"); //tipo de fuente     
				 
				XPropertyReplace xPropRepl = (XPropertyReplace) UnoRuntime.queryInterface(XPropertyReplace.class, xRepDesc);
				xPropRepl.setReplaceAttributes(aReplaceArgs);

			}
			 
			 
			//procedemos a realizar el search & replace
			xRepDesc.setReplaceString(reemplazo);
			xReplaceable.replaceAll(xRepDesc);
		}			 
		 
		//refrescamos el documento (este paso no es estrictamente necesario).
		XRefreshable xRefreshable = (XRefreshable) UnoRuntime.queryInterface(XRefreshable.class, xReplaceable);
		xRefreshable.refresh();
	}

	/**
	 * Método para hacer las pruebas stand-alone
	 * @param args rutas de ficheros in, y out
	 */
	public static void main(String[] args) {
    	OOReplaceFieldsHelper handler=new OOReplaceFieldsHelper();
    	Map table=new Hashtable();
    	table.put("#CONSELLERIA#", "pepito grillo");
    	
    	if(args.length==2){
    		try {
				handler.replaceFieldsAndConvert(new File(args[0]), new File(args[1]).getAbsolutePath(), table, "writer_pdf_Export", null);
			} catch (Exception e) {
				
				Logger.getLogger(OpenOfficeDocumentConversionHelper.class).error(e.getMessage(),e);
			}finally{
				if(handler.connector!=null) handler.connector.disconnect();
			}
    	}else{
    		
            // get the remote office component context
            XComponentContext xContext=null;
			try {
	        	handler.connector=new BootstrapConnector(handler.openofficeInstallDir);
				xContext = handler.connector.connect("-accept=socket,host="+handler.host+",port="+handler.port+";urp;", "socket,host="+handler.host+",port="+handler.port+"");

			} catch (BootstrapException e) {
				Logger.getLogger(OpenOfficeDocumentConversionHelper.class).error(e.getMessage(),e);
				System.exit(1);
			}
			handler.log.info("Connected to a running office ...");

            // get the remote office service manager
            com.sun.star.lang.XMultiComponentFactory xMCF = xContext.getServiceManager();
            
            XMultiServiceFactory mServiceFactory   = (XMultiServiceFactory)UnoRuntime.queryInterface( 
            XMultiServiceFactory.class, xMCF); 
                        
            Object object=null;
			try {
				object = mServiceFactory.createInstance("com.sun.star.document.FilterFactory");
			} catch (Exception e) {
				handler.log.error(e.getMessage(),e);
				System.exit(1);
			} 
			
			XNameContainer ff = (XNameContainer)UnoRuntime.queryInterface(com.sun.star.container.XNameContainer.class,object);
			String types[]=ff.getElementNames();
            
    		String help="Usage: ConversionHandler inputFile outputFormat outputFileExtension \n"+
    		"\n" +
    		"Configuration of each filter is defined in Common.xcs\n\n" +
    		"Possible output format filter values are : \n";
    		StringBuffer buf=new StringBuffer(help);
    		for (int i=0;i<types.length;i++){
    			buf.append(types[i]);
    			buf.append("\n");
    		}
    		
    		System.out.println(buf.toString());
    		
    		if(handler.connector!=null) handler.connector.disconnect();
    	}
    	
	}

}
