package es.caib.ibkey.oppenoffice.helper;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

import org.apache.log4j.Logger;

/**
 * Pipe and unpipe Streams.
 * @author u91940
 *
 */
public class Pipe {
   	Boolean lock=new Boolean(true);

	public void pipe(final InputStream in, final PrintStream out, final String prefix ) {
        new Thread( "Pipe: " + prefix) {
     	   	
             public void run() {
                 BufferedReader r = new BufferedReader(new InputStreamReader(in));
                 try {
                     for ( ; ; ) {
                     	String s=null;
                     	if(r.ready()){
                     		s = r.readLine();
                             if (s == null) {
                                 break;
                             }
                             out.println(prefix + s);
                     	}else{
                     		
                     		synchronized(lock){
                     			if(lock.booleanValue()){
 	                    			try {
 										lock.wait(500);
 									} catch (InterruptedException e) {
 										Logger.getLogger(Pipe.class).error(e.getMessage(),e);
 										break;
 									}
                     			}else{
                     				lock=new Boolean(false);
                     				break;
                     			}
                     		}
                     	}
                     		
                         
                     }
                 } catch (java.io.IOException e) {
                	 Logger.getLogger(Pipe.class).error(e.getMessage(),e);
                 }
             }
         }.start();
     }

	public void unpipe(){
		synchronized(lock){
			lock=new Boolean(false);
		}
	}
}
