package es.caib.ibkey.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

import org.apache.log4j.Logger;

/**
 * 	Adaptador per a poder redirigir d'un ouputstream a un logger.
 * @author u91940
 *
 */
public class Log4jOutputStreamAdapter extends OutputStream {

	static final public char DEBUG='d';
	static final public char WARN='w';
	static final public char ERROR='e';
	static final public char FATAL='f';
	static final public char NONE='n';
	
	protected char severity=NONE;
	protected Logger log=null;
	
	public Log4jOutputStreamAdapter(Logger log, char severity) {
		this.log=log;
		this.severity=severity;
	}

	public void close() throws IOException {
		this.log=null;
	}

	public void flush() throws IOException {
	}

	public void write(byte[] b, int off, int len) throws IOException {
		byte [] buf=new byte[len];
		Arrays.copyOfRange(b, off, off+len);
		switch(severity){
			case DEBUG: log.debug(new String(buf,"UTF-8"));
				break;
			case WARN: log.warn(new String(buf,"UTF-8"));
				break;
			case ERROR: log.error(new String(buf,"UTF-8"));
				break;
			case FATAL: log.fatal(new String(buf,"UTF-8"));
				break;
			case NONE: 
				break;
			default:
				break;
		}
	}

	public void write(byte[] b) throws IOException {
		switch(severity){
		case DEBUG: log.debug(new String(b,"UTF-8"));
			break;
		case WARN: log.warn(new String(b,"UTF-8"));
			break;
		case ERROR: log.error(new String(b,"UTF-8"));
			break;
		case FATAL: log.fatal(new String(b,"UTF-8"));
			break;
		case NONE: 
			break;
		default:
			break;
	}
	}

	public void write(int b) throws IOException {
		switch(severity){
			case DEBUG: log.debug(new String(new byte[]{(byte)b},"UTF-8"));
				break;
			case WARN: log.warn(new String(new byte[]{(byte)b},"UTF-8"));
				break;
			case ERROR: log.error(new String(new byte[]{(byte)b},"UTF-8"));
				break;
			case FATAL: log.fatal(new String(new byte[]{(byte)b},"UTF-8"));
				break;
			case NONE: 
				break;
			default:
				break;
		}
	}

}
