package es.caib.ibkey.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

import org.apache.log4j.Logger;

/**
 * 	Adaptador per a poder redirigir d'un printStream a un logger.
 * @author u91940
 *
 */
public class Log4jPrintStreamAdapter extends PrintStream {

	static final public char DEBUG='d';
	static final public char WARN='w';
	static final public char ERROR='e';
	static final public char FATAL='f';
	static final public char NONE='n';
	
	protected char 		severity=NONE;
	protected Logger 	log=null;

	/**
	 * @deprecated
	 * @param fileName
	 * @param csn
	 * @throws FileNotFoundException
	 * @throws UnsupportedEncodingException
	 */
	public Log4jPrintStreamAdapter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
		super(fileName, csn);
		// TODO Auto-generated constructor stub
	}

	/**
	 * @deprecated
	 * @param fileName
	 * @throws FileNotFoundException
	 */
	public Log4jPrintStreamAdapter(String fileName) throws FileNotFoundException {
		super(fileName);
		// TODO Auto-generated constructor stub
	}	
	/**
	 * @deprecated
	 * @param file
	 * @param csn
	 * @throws FileNotFoundException
	 * @throws UnsupportedEncodingException
	 */
	public Log4jPrintStreamAdapter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
		super(file,csn);
		throw new UnsupportedOperationException();
	}

	/**
	 * @deprecated
	 * @param file
	 * @throws FileNotFoundException
	 */
	public Log4jPrintStreamAdapter(File file) throws FileNotFoundException {
		super(file);
		throw new UnsupportedOperationException();
	}

	/**
	 * @deprecated
	 * @param out
	 * @param autoFlush
	 * @param encoding
	 * @throws UnsupportedEncodingException
	 * @deprecated
	 */
	public Log4jPrintStreamAdapter(OutputStream out, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
		super(out, autoFlush, encoding);
		throw new UnsupportedOperationException();
	}

	/**
	 * @deprecated
	 * @param out
	 * @param autoFlush
	 */
	public Log4jPrintStreamAdapter(OutputStream out, boolean autoFlush) {
		super(out, autoFlush);
		throw new UnsupportedOperationException();
	}

	/**
	 * @deprecated
	 * @param out
	 */
	public Log4jPrintStreamAdapter(OutputStream out) {
		super(out);
		throw new UnsupportedOperationException();
	}




	public Log4jPrintStreamAdapter(Logger log, char severity) {
		super(new ByteArrayOutputStream());
		this.log=log;
		this.severity=severity;
	}



	
	public void println(String b){
		switch(severity){
			case DEBUG: log.debug(b);
				break;
			case WARN: log.warn(b);
				break;
			case ERROR: log.error(b);
				break;
			case FATAL: log.fatal(b);
				break;
			case NONE: 
				break;
			default:
				break;
		}
	}

}
