package es.caib.ibkey.utils;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.ByteBuffer;

import javax.imageio.ImageIO;

import org.apache.log4j.Logger;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;

import es.caib.ibkey.bpm.pdf.helper.PDFToImageHelper;

public class PDFImageProxy extends ImageProxy {
	private PDFImageProxy(){
		
	}
	
	public static ImageProxy getInstance(byte []pdf ,String name,int previewPage,int previewMaxHeight, int previewMaxWidth) throws Exception {
		ImageProxy out=new ImageProxy();
		
		try{
			debug("PDFToImage begin");
			//fichero temporal donde se almacena la imagen
			File cache=new File(System.getProperty("java.io.tmpdir")+"/"+name+"_preview_"+previewPage+".jpg");
			debug("Created file "+cache.getAbsolutePath());
			//si la imatge no existeix encara, la creem. Així millorem el rendiment en els casos en que la tasca no ha finalitzat.
			//És necessari crear un handler que s'encarreqgui d'esborrar la imatge una vegada el procediment ha finalitzat
			BufferedImage im_buf=null;
			
			ByteBuffer buf=ByteBuffer.wrap(pdf);
			
			PDFFile pdffile = null;
			pdffile = new PDFFile(buf);
			
	        //cogemos la página
			PDFPage page =null;
			if(previewPage>=0)
				 page=pdffile.getPage(previewPage);
			else{
				page=pdffile.getPage(pdffile.getNumPages()+previewPage);
			}
			
			
			float oldWidth=page.getWidth();
			float oldHeight=page.getHeight();
			
			debug("Creating preview: dimensions "+previewMaxHeight+","+previewMaxWidth);
			if(!cache.exists()){
				im_buf=PDFToImageHelper.convertPDFToImage(page,previewMaxHeight,previewMaxWidth);
				PDFToImageHelper.saveImage(im_buf, cache.getAbsolutePath());
			}else{
				im_buf=ImageIO.read(cache);
			}
			
			//generem bean preview
			out.setSrc(cache.getAbsolutePath());
			out.setHeight(new Integer(im_buf.getHeight()));
			out.setWidth(new Integer(im_buf.getWidth()));
			out.setOriginalHeight(new Float(oldHeight));
			out.setOriginalWidth(new Float(oldWidth));
			
			debug("Created preview: original dimensions "+oldHeight+","+oldWidth);
			debug("Created preview: destiny dimensions "+im_buf.getHeight()+","+im_buf.getWidth());
		}catch(Exception e){
			error(e.getMessage(), e);
			throw e;
		}
		return out;
		
	}
	
	protected static void error(String message, Exception e) {
		Logger.getLogger(PDFImageProxy.class).error(message,e);
		
	}
	protected static void debug(String string) {
		Logger.getLogger(PDFImageProxy.class).debug(string);
		
	}
}
