package es.caib.ibkey.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLUtils {
	 /** returns XML in byte[] form
	  * Modification of code written by Martin Glogar at http://labe.felk.cvut.cz/~xfaigl/mep/xml/java-xml.htm
      * @param doc XML document to save
      * @return xml in byte [] form
      * @throws TransformerException 
	 * @throws IOException 
      */    
     public static byte [] XMLNodeToByteArray(Node doc) throws TransformerException, IOException {
       
         // open output stream where XML Document will be saved
         ByteArrayOutputStream fos;
         Transformer transformer;
         fos = new ByteArrayOutputStream();
         // Use a Transformer for output
         TransformerFactory transformerFactory = TransformerFactory.newInstance();
         try {
             transformer = transformerFactory.newTransformer();
         }
         catch (TransformerConfigurationException e) {
             throw e;
         }
         DOMSource source = new DOMSource(doc);
         StreamResult result = new StreamResult(fos);
         // transform source into result will do save
         try {
             transformer.transform(source, result);
         }
         catch (TransformerException e) {
             throw e;
         }
         
         byte [] resultBytes=fos.toByteArray();
         try{
        	 if(fos!=null)
        		 fos.close();
         }catch(IOException e){
        	throw e;
         }
         return resultBytes;
     }

 /** Saves XML Document into XML file.
       * @param fileName XML file name
       * @param doc XML document to save
       * @return <B>true</B> if method success <B>false</B> otherwise
 * @throws TransformerException 
 * @throws IOException 
       */    
      public static boolean saveXMLDocument(String fileName, Document doc) throws TransformerException, IOException {
          System.out.println("Saving XML file... " + fileName);
          // open output stream where XML Document will be saved
          File xmlOutputFile = new File(fileName);
          FileOutputStream fos;
          Transformer transformer;
          try {
              fos = new FileOutputStream(xmlOutputFile);
          }
          catch (FileNotFoundException e) {
        	  throw e;
          }
          // Use a Transformer for output
          TransformerFactory transformerFactory = TransformerFactory.newInstance();
          try {
              transformer = transformerFactory.newTransformer();
          }
          catch (TransformerConfigurationException e) {
              throw e;
          }
          DOMSource source = new DOMSource(doc);
          StreamResult result = new StreamResult(fos);
          // transform source into result will do save
          try {
              transformer.transform(source, result);
          }
          catch (TransformerException e) {
              throw e;
          }
          try{
         	 if(fos!=null)
         		 fos.close();
          }catch(IOException e){
         	throw e;
          }
          return true;
      }
          
      /** Parses XML file and returns XML document.
       * @param fileName XML file to parse
       * @return XML document or <B>null</B> if error occured
     * @throws IOException 
     * @throws ParserConfigurationException 
     * @throws SAXException 
     * @throws IOException 
       */
      public static Document parse(InputStream inStr) throws  ParserConfigurationException, SAXException, IOException {
          DocumentBuilder docBuilder;
          Document doc = null;
          DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
          docBuilderFactory.setIgnoringElementContentWhitespace(true);
          try {
              docBuilder = docBuilderFactory.newDocumentBuilder();
          }
          catch (ParserConfigurationException e) {
        	  throw e;
          }

          try {
              doc = docBuilder.parse(inStr);
          }
          catch (SAXException e) {
              throw e;
          }
          catch (IOException e) {
        	  throw e;
          }
          
          return doc;
      }

      
      
      
}
