/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.alfresco.client;

import es.caib.ibkey.alfresco.ws.AuthenticationUtils;
import es.caib.ibkey.alfresco.ws.ISO9075;
import es.caib.ibkey.alfresco.ws.InternalErrorException;
import es.caib.ibkey.alfresco.ws.WebServiceFactory;
import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.utils.NamedContent;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import org.alfresco.model.ContentModel;
import org.alfresco.www.ws.cml._1_0.CML;
import org.alfresco.www.ws.cml._1_0.CMLCreate;
import org.alfresco.www.ws.model.content._1_0.ContentFormat;
import org.alfresco.www.ws.model.content._1_0.NamedValue;
import org.alfresco.www.ws.model.content._1_0.Node;
import org.alfresco.www.ws.model.content._1_0.ParentReference;
import org.alfresco.www.ws.model.content._1_0.Predicate;
import org.alfresco.www.ws.model.content._1_0.Reference;
import org.alfresco.www.ws.model.content._1_0.Store;
import org.alfresco.www.ws.service.authentication._1_0.AuthenticationFault;
import org.alfresco.www.ws.service.content._1_0.Content;
import org.alfresco.www.ws.service.content._1_0.ContentFault;
import org.alfresco.www.ws.service.content._1_0.ContentServiceSoapBindingStub;
import org.alfresco.www.ws.service.content._1_0.Read;
import org.alfresco.www.ws.service.content._1_0.Write;
import org.alfresco.www.ws.service.repository._1_0.Get;
import org.alfresco.www.ws.service.repository._1_0.GetStores;
import org.alfresco.www.ws.service.repository._1_0.RepositoryFault;
import org.alfresco.www.ws.service.repository._1_0.RepositoryServiceSoapBindingStub;
import org.alfresco.www.ws.service.repository._1_0.Update;
import org.alfresco.www.ws.service.repository._1_0.UpdateResult;
import org.apache.axis.utils.ByteArrayOutputStream;
import org.apache.log4j.Logger;

public class AlfrescoRepositoryClient {
    private WebServiceFactory.WebServiceFactoryConfig config = null;
    private static Logger log = Logger.getLogger((String)AlfrescoRepositoryClient.class.getCanonicalName());

    public AlfrescoRepositoryClient() {
    }

    public AlfrescoRepositoryClient(WebServiceFactory.WebServiceFactoryConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String documentName;
        String documentTitle = documentName = "prueba-ibkey" + Math.round(Math.random() * 1000.0);
        String documentDescription = "descripci\u00c3\u00b3n de " + documentName;
        String documentAuthor = "u91940";
        String nodeParentPath = "";
        String nodeName = "test_" + Math.round(Math.random() * 1000.0);
        String alfrescoServicesURL = "http://192.168.200.109:18080/alfresco/api";
        String alfrescoUser = "u91940";
        String alfrescoUserPassword = "abc123";
        String documentStoreScheme = "workspace";
        String documentStoreAddress = "SpacesStore";
        WebServiceFactory.WebServiceFactoryConfig config = new WebServiceFactory.WebServiceFactoryConfig(alfrescoServicesURL, 60000);
        AlfrescoRepositoryClient alf = new AlfrescoRepositoryClient(config);
        try {
            AuthenticationUtils.startSession(config, alfrescoUser, alfrescoUserPassword, 3600000L);
        }
        catch (AuthenticationFault e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
        }
        catch (InternalErrorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            alf.doTestBusiness(documentName, documentTitle, documentDescription, documentAuthor, documentStoreScheme, documentStoreAddress, nodeParentPath, nodeName);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                AuthenticationUtils.endSession(config);
            }
            catch (InternalErrorException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void doTestBusiness(String documentName, String documentTitle, String documentDescription, String documentAuthor, String documentStoreScheme, String documentStoreAddress, String nodeParentPath, String nodeName) throws RemoteException, InternalErrorException, UnsupportedEncodingException {
        Store[] stores;
        RepositoryServiceSoapBindingStub repo = null;
        try {
            repo = WebServiceFactory.getRepositoryService(this.config);
        }
        catch (InternalErrorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            stores = repo.getStores(new GetStores());
        }
        catch (RepositoryFault e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        Store store = AlfrescoRepositoryClient.selectStore(stores, documentStoreScheme, documentStoreAddress);
        Reference reference = this.createContentNode(store, nodeParentPath, nodeName, documentName, documentTitle, documentDescription, documentAuthor);
        try {
            byte[] content = "esto es una prueba".getBytes("UTF-8");
            this.uploadContent(store, reference, "text/plain", "UTF-8", content);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean alreadyExistsContent(Store store, String path) throws InternalErrorException, RemoteException {
        Content[] c = null;
        try {
            Reference ref = new Reference(store, null, path);
            ContentServiceSoapBindingStub content = WebServiceFactory.getContentService(this.config);
            c = content.read(new Read(new Predicate(new Reference[]{ref}, null, null), ContentModel.TYPE_CONTENT.toString()));
        }
        catch (InternalErrorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ContentFault e) {
            if (e.getMessage1().contains("found 0 nodes")) {
                return false;
            }
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return true;
    }

    public boolean alreadyExistsFolder(Store store, String path) throws InternalErrorException, RemoteException {
        try {
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 2);
            }
            Reference ref = new Reference(store, null, path);
            ContentServiceSoapBindingStub content = WebServiceFactory.getContentService(this.config);
            content.read(new Read(new Predicate(new Reference[]{ref}, null, null), ContentModel.TYPE_FOLDER.toString()));
        }
        catch (InternalErrorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ContentFault e) {
            if (e.getMessage1().contains("found 0 nodes")) {
                return false;
            }
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return true;
    }

    public Reference createContentNode(Store store, String parentPath, String nodeName, String name, String title, String description, String author) throws RemoteException, InternalErrorException {
        UpdateResult[] result;
        this.createNodePath(store, parentPath, "", author);
        int i = 1;
        String uniqueNodeName = nodeName;
        while (this.alreadyExistsContent(store, parentPath + "/cm:" + ISO9075.encode(uniqueNodeName))) {
            uniqueNodeName = nodeName + " (" + i + ")";
            if (++i < 10) continue;
        }
        if (i == 10) {
            throw new InternalErrorException("Too many files with same name: " + parentPath + "/cm:" + nodeName);
        }
        ParentReference parentReference = new ParentReference(store, null, parentPath, ContentModel.ASSOC_CONTAINS.toString(), null);
        parentReference.setChildName("cm:" + ISO9075.encode(uniqueNodeName));
        CMLCreate createNodeStmt = new CMLCreate("1", parentReference, null, null, null, ContentModel.TYPE_CONTENT.toString(), AlfrescoRepositoryClient.buildCustomProperties(uniqueNodeName, title, description, author));
        CML cml = new CML();
        cml.setCreate(new CMLCreate[]{createNodeStmt});
        try {
            result = WebServiceFactory.getRepositoryService(this.config).update(new Update(cml));
        }
        catch (RepositoryFault e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InternalErrorException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (result != null && result.length > 0 && result[result.length - 1] != null) {
            return result[result.length - 1].getDestination();
        }
        return null;
    }

    public void createNodePath(Store store, String parentPath, String description, String author) throws RemoteException, InternalErrorException {
        if (!this.alreadyExistsFolder(store, parentPath)) {
            String[] paths = parentPath.split("\\/");
            StringBuffer tempPath = null;
            Object tempParentPath = null;
            int j = 0;
            for (j = paths.length; j > 0; --j) {
                tempPath = new StringBuffer();
                for (int l = 0; l < j; ++l) {
                    if ("".equals(paths[l])) continue;
                    tempPath.append("/");
                    tempPath.append(paths[l]);
                }
                if (this.alreadyExistsFolder(store, tempPath.toString())) break;
            }
            for (int i = j; i < paths.length; ++i) {
                tempPath = new StringBuffer();
                for (int l = 0; l < i; ++l) {
                    if ("".equals(paths[l])) continue;
                    tempPath.append("/");
                    tempPath.append(paths[l]);
                }
                ParentReference parentReference = new ParentReference(store, null, tempPath.toString(), ContentModel.ASSOC_CONTAINS.toString(), null);
                String tempName = paths[i].replaceAll("cm:", "");
                tempName = ISO9075.decode(tempName);
                parentReference.setChildName("{http://www.alfresco.org/model/content/1.0}" + tempName);
                CMLCreate createNodeStmt = new CMLCreate("1", parentReference, null, null, null, ContentModel.TYPE_FOLDER.toString(), AlfrescoRepositoryClient.buildCustomProperties(tempName, tempName, description, author));
                CML cml = new CML();
                cml.setCreate(new CMLCreate[]{createNodeStmt});
                try {
                    UpdateResult[] result = WebServiceFactory.getRepositoryService(this.config).update(new Update(cml));
                    continue;
                }
                catch (RepositoryFault e) {
                    log.error((Object)e.getMessage(), (Throwable)((Object)e));
                    throw e;
                }
                catch (RemoteException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (InternalErrorException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        }
    }

    public static NamedValue[] buildCustomProperties(String name, String title, String description, String author) {
        NamedValue[] properties = new NamedValue[]{new NamedValue("{" + ContentModel.TYPE_CONTENT.getNamespaceURI() + "}name", new Boolean(false), name, null), new NamedValue("{" + ContentModel.TYPE_CONTENT.getNamespaceURI() + "}title", new Boolean(false), title, null), new NamedValue("{" + ContentModel.TYPE_CONTENT.getNamespaceURI() + "}description", new Boolean(false), description, null), new NamedValue("{" + ContentModel.TYPE_CONTENT.getNamespaceURI() + "}userName", new Boolean(false), author, null)};
        return properties;
    }

    public void uploadContent(Store store, Reference reference, String mimeType, String encoding, byte[] content) throws InternalErrorException, RemoteException {
        ContentServiceSoapBindingStub contentService = null;
        try {
            contentService = WebServiceFactory.getContentService(this.config);
        }
        catch (InternalErrorException e1) {
            e1.printStackTrace();
            throw e1;
        }
        ContentFormat format = new ContentFormat(mimeType, encoding);
        try {
            contentService.write(new Write(reference, ContentModel.PROP_CONTENT.toString(), content, format));
        }
        catch (ContentFault e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public NamedContent getContentByHashlink(String hashlink) throws Exception {
        log.debug((Object)("Inicio de descarga del documento: " + hashlink));
        ContentServiceSoapBindingStub contentService = null;
        try {
            contentService = WebServiceFactory.getContentService(this.config);
        }
        catch (InternalErrorException e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
            throw e1;
        }
        try {
            Reference[] references = new Reference[1];
            Store store = new Store(IBkeyConfig.getAlfrescoStoreScheme(), IBkeyConfig.getAlfrescoStoreAddress());
            references[0] = new Reference(store, hashlink, null);
            Content[] content = contentService.read(new Read(new Predicate(references, null, null), ContentModel.PROP_CONTENT.toString()));
            es.caib.ibkey.utils.Content simpleContent = AlfrescoRepositoryClient.getContentByURL(content[0].getUrl());
            Node[] nodes = this.getNode(new String[]{hashlink});
            String name = null;
            NamedValue[] nodeProps = nodes[0].getProperties();
            for (int m = 0; m < nodeProps.length; ++m) {
                if (!ContentModel.PROP_TITLE.toString().equals(nodeProps[m].getName())) continue;
                name = nodeProps[m].getValue();
            }
            NamedContent outContent = new NamedContent(simpleContent, name);
            log.debug((Object)("Fin de descarga del documento: " + hashlink));
            return outContent;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static Store selectStore(Store[] stores, String scheme, String address) {
        Store selected = null;
        for (int i = 0; i < stores.length; ++i) {
            if (stores[i].getScheme() == null || !stores[i].getScheme().equals(scheme) || stores[i].getAddress() == null || !stores[i].getAddress().equals(address)) continue;
            selected = stores[i];
            break;
        }
        return selected;
    }

    public Node[] getNode(String[] hashlinks) throws InternalErrorException, RemoteException {
        RepositoryServiceSoapBindingStub repoService = null;
        try {
            repoService = WebServiceFactory.getRepositoryService();
        }
        catch (InternalErrorException e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
            throw e1;
        }
        try {
            Reference[] references = new Reference[hashlinks.length];
            Store store = new Store(IBkeyConfig.getAlfrescoStoreScheme(), IBkeyConfig.getAlfrescoStoreAddress());
            for (int i = 0; i < hashlinks.length; ++i) {
                references[i] = new Reference(store, hashlinks[i], null);
            }
            Node[] nodes = repoService.get(new Get(new Predicate(references, null, null)));
            return nodes;
        }
        catch (ContentFault e) {
            log.error((Object)e.getMessage(), (Throwable)((Object)e));
            throw e;
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static es.caib.ibkey.utils.Content getContentByURL(String url) throws Exception {
        es.caib.ibkey.utils.Content outContent = new es.caib.ibkey.utils.Content();
        ByteArrayOutputStream readContent = new ByteArrayOutputStream();
        String ticket = AuthenticationUtils.getTicket();
        String strUrl = url + "?ticket=" + ticket;
        InputStream is = null;
        try {
            URL urlAuth = new URL(strUrl);
            URLConnection conn = urlAuth.openConnection();
            conn.setRequestProperty("Cookie", "JSESSIONID=" + AuthenticationUtils.getAuthenticationDetails().getSessionId() + ";");
            is = conn.getInputStream();
            byte[] buf = new byte[4096];
            int readed = 0;
            while (readed != -1) {
                readed = is.read(buf);
                if (readed == -1) continue;
                readContent.write(buf, 0, readed);
            }
            outContent.setContent(readContent.toByteArray());
            outContent.setContentEncoding(conn.getContentType().split(";")[1]);
            outContent.setMimeType(conn.getContentType().split(";")[0]);
        }
        catch (Exception exception) {
            throw new Exception("Unable to get content as string.", exception);
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return outContent;
    }
}

