/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.alfresco.ws;

import es.caib.ibkey.alfresco.ws.AuthenticationDetails;
import es.caib.ibkey.alfresco.ws.InternalErrorException;
import es.caib.ibkey.alfresco.ws.WebServiceFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.alfresco.www.ws.service.authentication._1_0.AuthenticationFault;
import org.alfresco.www.ws.service.authentication._1_0.AuthenticationResult;
import org.alfresco.www.ws.service.authentication._1_0.EndSession;
import org.alfresco.www.ws.service.authentication._1_0.StartSession;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.FileProvider;
import org.apache.ws.security.WSPasswordCallback;

public class AuthenticationUtils
implements CallbackHandler {
    private static final String WS_SECURITY_INFO = "<deployment xmlns='http://xml.apache.org/axis/wsdd/' xmlns:java='http://xml.apache.org/axis/wsdd/providers/java'>   <transport name='http' pivot='java:org.apache.axis.transport.http.HTTPSender'/>   <globalConfiguration >     <requestFlow >       <handler type='java:org.apache.ws.axis.security.WSDoAllSender' >               <parameter name='action' value='UsernameToken Timestamp'/>               <parameter name='user' value='ticket'/>               <parameter name='passwordCallbackClass' value='es.caib.ibkey.alfresco.ws.AuthenticationUtils'/>               <parameter name='passwordType' value='PasswordText'/>           </handler>       <handler name='cookieHandler' type='java:es.caib.ibkey.alfresco.ws.CookieHandler' />     </requestFlow >   </globalConfiguration></deployment>";
    private static ThreadLocal authenticationDetails = new ThreadLocal();

    public static void startSession(WebServiceFactory.WebServiceFactoryConfig config, String username, String password) throws AuthenticationFault, InternalErrorException {
        try {
            if (authenticationDetails.get() != null) {
                throw new InternalErrorException("Current Alfresco session already exists");
            }
            AuthenticationResult result = WebServiceFactory.getAuthenticationService(config).startSession(new StartSession(username, password)).getStartSessionReturn();
            authenticationDetails.set(new AuthenticationDetails(result.getUsername(), result.getTicket(), result.getSessionid()));
        }
        catch (RemoteException exception) {
            if (exception instanceof AuthenticationFault) {
                throw (AuthenticationFault)((Object)exception);
            }
            throw new InternalErrorException("Error starting session.", exception);
        }
    }

    public static void startSession(WebServiceFactory.WebServiceFactoryConfig config, String username, String password, long timeoutInterval) throws AuthenticationFault, InternalErrorException {
        AuthenticationUtils.startSession(config, username, password);
        AuthenticationDetails ad = AuthenticationUtils.getAuthenticationDetails();
        ad.setTimeoutInterval(timeoutInterval);
    }

    public static void setAuthenticationDetails(AuthenticationDetails authenticationDetails) {
        AuthenticationUtils.authenticationDetails.set(authenticationDetails);
    }

    public static boolean isCurrentTicketTimedOut(WebServiceFactory.WebServiceFactoryConfig config) throws InternalErrorException {
        boolean to = AuthenticationUtils.getAuthenticationDetails().isTimedOut();
        if (to) {
            AuthenticationUtils.endSession(config);
        }
        return to;
    }

    public static void endSession(WebServiceFactory.WebServiceFactoryConfig config) throws InternalErrorException {
        AuthenticationDetails authenticationDetails = (AuthenticationDetails)AuthenticationUtils.authenticationDetails.get();
        if (authenticationDetails != null) {
            try {
                WebServiceFactory.getAuthenticationService(config).endSession(new EndSession(authenticationDetails.getTicket()));
                AuthenticationUtils.authenticationDetails.remove();
            }
            catch (RemoteException exception) {
                exception.printStackTrace();
                throw new InternalErrorException("Error ending session.", exception);
            }
        }
    }

    public static String getTicket() {
        String result = null;
        AuthenticationDetails authDetails = (AuthenticationDetails)authenticationDetails.get();
        if (authDetails != null) {
            result = authDetails.getTicket();
        }
        return result;
    }

    public static AuthenticationDetails getAuthenticationDetails() {
        return (AuthenticationDetails)authenticationDetails.get();
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            String ticket;
            WSPasswordCallback pc;
            if (callbacks[i] instanceof WSPasswordCallback) {
                pc = (WSPasswordCallback)callbacks[i];
                ticket = AuthenticationUtils.getTicket();
                if (ticket == null) {
                    throw new IOException("Ticket could not be found when calling callback handler.");
                }
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            pc.setPassword(ticket);
        }
    }

    public static EngineConfiguration getEngineConfiguration() {
        return new FileProvider((InputStream)new ByteArrayInputStream(WS_SECURITY_INFO.getBytes()));
    }
}

