/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.alfresco.ws;

import es.caib.ibkey.alfresco.ws.AuthenticationUtils;
import es.caib.ibkey.alfresco.ws.InternalErrorException;
import es.caib.ibkey.bpm.common.IBkeyConfig;
import javax.xml.rpc.ServiceException;
import org.alfresco.www.ws.service.action._1_0.ActionServiceLocator;
import org.alfresco.www.ws.service.action._1_0.ActionServiceSoapBindingStub;
import org.alfresco.www.ws.service.authentication._1_0.AuthenticationServiceLocator;
import org.alfresco.www.ws.service.authentication._1_0.AuthenticationServiceSoapBindingStub;
import org.alfresco.www.ws.service.content._1_0.ContentServiceLocator;
import org.alfresco.www.ws.service.content._1_0.ContentServiceSoapBindingStub;
import org.alfresco.www.ws.service.repository._1_0.RepositoryServiceLocator;
import org.alfresco.www.ws.service.repository._1_0.RepositoryServiceSoapBindingStub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class WebServiceFactory {
    private static Log logger = LogFactory.getLog(WebServiceFactory.class);
    private static final String AUTHENTICATION_SERVICE_ADDRESS = "/AuthenticationService";
    private static final String REPOSITORY_SERVICE_ADDRESS = "/RepositoryService";
    private static final String CONTENT_SERVICE_ADDRESS = "/ContentService";
    private static final String AUTHORING_SERVICE_ADDRESS = "/AuthoringService";
    private static final String CLASSIFICATION_SERVICE_ADDRESS = "/ClassificationService";
    private static final String ACTION_SERVICE_ADDRESS = "/ActionService";
    private static final String ACCESS_CONTROL_ADDRESS = "/AccessControlService";
    private static final String ADMINISTRATION_ADDRESS = "/AdministrationService";
    private static final String DICTIONARY_SERVICE_ADDRESS = "/DictionaryService";

    public static AuthenticationServiceSoapBindingStub getAuthenticationService() throws InternalErrorException {
        return WebServiceFactory.getAuthenticationService(null);
    }

    public static AuthenticationServiceSoapBindingStub getAuthenticationService(WebServiceFactoryConfig config) throws InternalErrorException {
        AuthenticationServiceSoapBindingStub authenticationService = null;
        try {
            AuthenticationServiceLocator locator = new AuthenticationServiceLocator();
            if (config != null) {
                locator.setAuthenticationServiceEndpointAddress(config.endpointAddress + AUTHENTICATION_SERVICE_ADDRESS);
            } else {
                locator.setAuthenticationServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + AUTHENTICATION_SERVICE_ADDRESS);
            }
            authenticationService = (AuthenticationServiceSoapBindingStub)locator.getAuthenticationService();
        }
        catch (ServiceException jre) {
            if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new InternalErrorException("Error creating authentication service: " + jre.getMessage(), jre);
        }
        if (config != null) {
            authenticationService.setTimeout(config.timeoutMilliseconds);
        } else {
            authenticationService.setTimeout(WebServiceFactory.getTimeoutMilliseconds());
        }
        return authenticationService;
    }

    public static RepositoryServiceSoapBindingStub getRepositoryService() throws InternalErrorException {
        return WebServiceFactory.getRepositoryService(null);
    }

    public static RepositoryServiceSoapBindingStub getRepositoryService(WebServiceFactoryConfig config) throws InternalErrorException {
        RepositoryServiceSoapBindingStub repositoryService = null;
        try {
            RepositoryServiceLocator locator = new RepositoryServiceLocator(AuthenticationUtils.getEngineConfiguration());
            if (config != null) {
                locator.setRepositoryServiceEndpointAddress(config.endpointAddress + REPOSITORY_SERVICE_ADDRESS);
            } else {
                locator.setRepositoryServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + REPOSITORY_SERVICE_ADDRESS);
            }
            repositoryService = (RepositoryServiceSoapBindingStub)locator.getRepositoryService();
        }
        catch (ServiceException jre) {
            if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new InternalErrorException("Error creating authentication service: " + jre.getMessage(), jre);
        }
        if (config != null) {
            repositoryService.setTimeout(config.timeoutMilliseconds);
        } else {
            repositoryService.setTimeout(WebServiceFactory.getTimeoutMilliseconds());
        }
        return repositoryService;
    }

    public static ContentServiceSoapBindingStub getContentService() throws InternalErrorException {
        return WebServiceFactory.getContentService(null);
    }

    public static ContentServiceSoapBindingStub getContentService(WebServiceFactoryConfig config) throws InternalErrorException {
        ContentServiceSoapBindingStub contentService = null;
        try {
            ContentServiceLocator locator = new ContentServiceLocator(AuthenticationUtils.getEngineConfiguration());
            if (config != null) {
                locator.setContentServiceEndpointAddress(config.endpointAddress + CONTENT_SERVICE_ADDRESS);
            } else {
                locator.setContentServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + CONTENT_SERVICE_ADDRESS);
            }
            contentService = (ContentServiceSoapBindingStub)locator.getContentService();
        }
        catch (ServiceException jre) {
            if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new InternalErrorException("Error creating authentication service: " + jre.getMessage(), jre);
        }
        if (config != null) {
            contentService.setTimeout(config.timeoutMilliseconds);
        } else {
            contentService.setTimeout(WebServiceFactory.getTimeoutMilliseconds());
        }
        return contentService;
    }

    public static ActionServiceSoapBindingStub getActionService() throws InternalErrorException {
        return WebServiceFactory.getActionService(null);
    }

    public static ActionServiceSoapBindingStub getActionService(WebServiceFactoryConfig config) throws InternalErrorException {
        ActionServiceSoapBindingStub actionService = null;
        try {
            ActionServiceLocator locator = new ActionServiceLocator(AuthenticationUtils.getEngineConfiguration());
            if (config != null) {
                locator.setActionServiceEndpointAddress(config.endpointAddress + ACTION_SERVICE_ADDRESS);
            } else {
                locator.setActionServiceEndpointAddress(WebServiceFactory.getEndpointAddress() + ACTION_SERVICE_ADDRESS);
            }
            actionService = (ActionServiceSoapBindingStub)locator.getActionService();
        }
        catch (ServiceException jre) {
            if (logger.isDebugEnabled() && jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new InternalErrorException("Error creating action service: " + jre.getMessage(), jre);
        }
        if (config != null) {
            actionService.setTimeout(config.timeoutMilliseconds);
        } else {
            actionService.setTimeout(WebServiceFactory.getTimeoutMilliseconds());
        }
        return actionService;
    }

    public static String getEndpointAddress() {
        return IBkeyConfig.getAlfrescoWSEndpointAddress();
    }

    private static int getTimeoutMilliseconds() {
        return Integer.parseInt(IBkeyConfig.getAlfrescoWSTimeoutMilis());
    }

    public static class WebServiceFactoryConfig {
        private String endpointAddress = null;
        private int timeoutMilliseconds = -1;

        public WebServiceFactoryConfig(String endpointAddress, int timeoutMilliseconds) {
            this.endpointAddress = endpointAddress;
            this.timeoutMilliseconds = timeoutMilliseconds;
        }
    }
}

