/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.bpm.common;

import es.caib.ibkey.bpm.common.PropertyNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesFileUtil {
    private String FICHERO_CONFIGURACION = "config.properties";
    private Properties properties;

    public PropertiesFileUtil() throws IOException {
        this.loadFile();
    }

    public PropertiesFileUtil(String nameFile) throws IOException {
        this.FICHERO_CONFIGURACION = nameFile;
        this.loadFile();
    }

    public PropertiesFileUtil(InputStream input) throws IOException {
        this.loadFile(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile() throws IOException {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(this.FICHERO_CONFIGURACION);
            this.loadFile(is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Logger.getLogger(PropertiesFileUtil.class).error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void loadFile(InputStream input) throws IOException {
        this.properties = new Properties();
        this.properties.load(input);
    }

    public String getProperty(String key) throws PropertyNotFoundException {
        String prop = this.properties.getProperty(key);
        if (prop == null) {
            throw new PropertyNotFoundException(key);
        }
        return prop;
    }
}

