/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.bpm.pdf.helper;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import es.caib.ibkey.bpm.conversion.exception.ConversionException;
import es.caib.ibkey.bpm.pdf.helper.PDFAGeneratorHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;

public class PDFAFromImageGeneratorHelper
extends PDFAGeneratorHelper {
    protected byte[] imageBytes = null;
    protected boolean scaleImageToFitPage = false;
    protected Rectangle pageSize = null;
    protected boolean rotateWhenWidthGreaterThanHeight = true;
    protected float topMargin = 0.0f;
    protected float leftMargin = 0.0f;
    protected float bottomMargin = 0.0f;
    protected float rightMargin = 0.0f;
    private float height;
    private float width;
    private Image image;

    public float getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(float topMargin) {
        this.topMargin = topMargin;
    }

    public float getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(float leftMargin) {
        this.leftMargin = leftMargin;
    }

    public float getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(float bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public float getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(float rightMargin) {
        this.rightMargin = rightMargin;
    }

    public void setScaleImageToFitPage(boolean scaleImageToFitPage) {
        this.scaleImageToFitPage = scaleImageToFitPage;
    }

    public void setPageSize(Rectangle pageSize) {
        this.pageSize = pageSize;
    }

    public void setRotateWhenWidthGreaterThanHeight(boolean rotateWhenWidthGreaterThanHeight) {
        this.rotateWhenWidthGreaterThanHeight = rotateWhenWidthGreaterThanHeight;
    }

    public PDFAFromImageGeneratorHelper(byte[] imageBytes) throws ConversionException {
        try {
            this.imageBytes = imageBytes;
            this.image = Image.getInstance((byte[])imageBytes);
            this.height = this.image.getHeight();
            this.width = this.image.getWidth();
        }
        catch (BadElementException e) {
            e.printStackTrace();
            throw new ConversionException((Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new ConversionException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ConversionException(e);
        }
    }

    protected void customizeContent(Document doc, PdfWriter writer) throws ConversionException {
        try {
            boolean vertical;
            boolean bl = vertical = this.height > this.width;
            if (this.pageSize == null) {
                this.pageSize = this.getDocumentPageSize();
                if (!vertical && this.rotateWhenWidthGreaterThanHeight) {
                    this.pageSize.rotate();
                }
            }
            if (this.scaleImageToFitPage || this.imageGreaterThanPageSize(this.image, this.pageSize)) {
                this.scaleImageToFitPage(this.image, this.pageSize);
            }
            doc.setPageSize(this.pageSize);
            this.image.setAbsolutePosition(this.leftMargin, this.pageSize.getHeight() - this.image.getScaledHeight() - this.topMargin);
            doc.add((Element)this.image);
        }
        catch (BadElementException e) {
            e.printStackTrace();
            throw new ConversionException((Exception)((Object)e));
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new ConversionException((Exception)((Object)e));
        }
    }

    private boolean imageGreaterThanPageSize(Image image2, Rectangle pageSize2) {
        return image2.getWidth() > pageSize2.getWidth() || image2.getHeight() > pageSize2.getHeight();
    }

    protected void scaleImageToFitPage(Image image, Rectangle pageSize2) {
        image.scaleAbsolute(pageSize2.getWidth() - this.leftMargin - this.rightMargin, pageSize2.getHeight() - this.topMargin - this.bottomMargin);
    }

    protected Rectangle pageSizeFromImage(float height, float width, boolean verticalOrientation, boolean rotateWhenWidthGreaterThanHeight) {
        float verticalHeight;
        float verticalWidth = verticalOrientation ? width : height;
        float f = verticalHeight = verticalOrientation ? height : width;
        if (verticalWidth <= 595.0f && verticalHeight <= 842.0f) {
            if (!verticalOrientation && rotateWhenWidthGreaterThanHeight) {
                return PageSize.A4.rotate();
            }
            return PageSize.A4;
        }
        if (verticalWidth <= 842.0f && verticalHeight <= 1191.0f) {
            if (!verticalOrientation && rotateWhenWidthGreaterThanHeight) {
                return PageSize.A4.rotate();
            }
            return PageSize.A4;
        }
        if (verticalWidth <= 1191.0f && verticalHeight <= 1684.0f) {
            if (!verticalOrientation && rotateWhenWidthGreaterThanHeight) {
                return PageSize.A4.rotate();
            }
            return PageSize.A4;
        }
        if (!verticalOrientation && rotateWhenWidthGreaterThanHeight) {
            return PageSize.A4.rotate();
        }
        return PageSize.A4;
    }

    protected static void readBytes(FileInputStream in, ByteArrayOutputStream out) throws IOException {
        byte[] b = new byte[10240];
        int readed = 0;
        do {
            if ((readed = in.read(b)) == 0 || readed == -1) continue;
            out.write(b, 0, readed);
        } while (readed != 0 && readed != -1);
    }

    public Rectangle getDocumentPageSize() {
        if (this.pageSize == null) {
            boolean vertical = this.height > this.width;
            return this.pageSizeFromImage(this.height, this.width, vertical, this.rotateWhenWidthGreaterThanHeight);
        }
        return this.pageSize;
    }

    public static void main(String[] args) {
        try {
            ByteArrayOutputStream imageBytes = new ByteArrayOutputStream();
            PDFAFromImageGeneratorHelper.readBytes(new FileInputStream(new File(args[0])), imageBytes);
            PDFAFromImageGeneratorHelper helper = new PDFAFromImageGeneratorHelper(imageBytes.toByteArray());
            FileOutputStream out1 = new FileOutputStream(new File(args[1], "test_1.pdf"));
            FileOutputStream out2 = new FileOutputStream(new File(args[1], "test_2.pdf"));
            FileOutputStream out3 = new FileOutputStream(new File(args[1], "test_3.pdf"));
            FileOutputStream out4 = new FileOutputStream(new File(args[1], "test_4.pdf"));
            ByteArrayOutputStream colorProfileBytes = new ByteArrayOutputStream();
            PDFAFromImageGeneratorHelper.readBytes(new FileInputStream(new File("c:/app/caib/ibkey/srgb.profile")), colorProfileBytes);
            helper.generatePDFA(out1, colorProfileBytes.toByteArray());
            helper.setPageSize(null);
            helper.setScaleImageToFitPage(false);
            helper.setRotateWhenWidthGreaterThanHeight(false);
            helper.generatePDFA(out2, colorProfileBytes.toByteArray());
            helper.setPageSize(null);
            helper.setScaleImageToFitPage(true);
            helper.setRotateWhenWidthGreaterThanHeight(false);
            helper.generatePDFA(out3, colorProfileBytes.toByteArray());
            helper.setPageSize(null);
            helper.setScaleImageToFitPage(true);
            helper.setRotateWhenWidthGreaterThanHeight(true);
            helper.setBottomMargin(20.0f);
            helper.setTopMargin(40.0f);
            helper.setLeftMargin(100.0f);
            helper.setRightMargin(50.0f);
            helper.generatePDFA(out4, colorProfileBytes.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

