/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.bpm.pdf.helper;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfICCBased;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import es.caib.ibkey.bpm.conversion.exception.ConversionException;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public abstract class PDFAGeneratorHelper {
    public void generatePDFA(OutputStream outputStream, byte[] profileInputStream) throws ConversionException {
        try {
            Document doc = new Document(this.getDocumentPageSize());
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)outputStream);
            writer.setPDFXConformance(4);
            doc.open();
            PdfDictionary outi = new PdfDictionary(PdfName.OUTPUTINTENT);
            outi.put(PdfName.OUTPUTCONDITIONIDENTIFIER, (PdfObject)new PdfString("sRGB IEC61966-2.1"));
            outi.put(PdfName.INFO, (PdfObject)new PdfString("sRGB IEC61966-2.1"));
            outi.put(PdfName.S, (PdfObject)PdfName.GTS_PDFA1);
            ICC_Profile icc = ICC_Profile.getInstance(profileInputStream);
            PdfICCBased ib = new PdfICCBased(icc);
            ib.remove(PdfName.ALTERNATE);
            outi.put(PdfName.DESTOUTPUTPROFILE, (PdfObject)writer.addToBody((PdfObject)ib).getIndirectReference());
            writer.getExtraCatalog().put(PdfName.OUTPUTINTENTS, (PdfObject)new PdfArray((PdfObject)outi));
            this.customizeContent(doc, writer);
            writer.createXmpMetadata();
            doc.close();
        }
        catch (DocumentException e) {
            Logger.getLogger(this.getClass()).error((Object)e);
            throw new ConversionException((Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass()).error((Object)e);
            throw new ConversionException(e);
        }
    }

    public abstract Rectangle getDocumentPageSize();

    protected abstract void customizeContent(Document var1, PdfWriter var2) throws ConversionException;
}

