/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.bpm.pdf.helper;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.imageio.ImageIO;

public class PDFToImageHelper {
    public static BufferedImage convertPDFToImage(PDFPage page, float maxHeight, float maxWidth) throws IOException {
        float height = page.getHeight();
        float width = page.getWidth();
        float aspectRatio = height / width;
        float resizeRatioH = maxHeight / height;
        float resizeRatioW = maxWidth / width;
        float newHeight = aspectRatio > 1.0f ? maxHeight : height * resizeRatioW;
        float newWidth = aspectRatio > 1.0f ? width * resizeRatioH : maxWidth;
        Rectangle rect = new Rectangle(0, 0, (int)width, (int)height);
        Image img = page.getImage(rect.width, rect.height, (Rectangle2D)rect, null, true, true);
        Image resized = img.getScaledInstance((int)newWidth, (int)newHeight, 2);
        img = null;
        return PDFToImageHelper.toBufferedImage(resized);
    }

    public static void saveImage(BufferedImage im, String destPath) throws IOException {
        ImageIO.write((RenderedImage)im, "jpg", new File(destPath));
    }

    public static BufferedImage toBufferedImage(Image src) {
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        int type = 1;
        BufferedImage dest = new BufferedImage(w, h, type);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage(src, 0, 0, null);
        g2.dispose();
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RandomAccessFile raf = null;
        AbstractInterruptibleChannel channel = null;
        try {
            File file = new File(args[0]);
            raf = new RandomAccessFile(file, "r");
            channel = raf.getChannel();
            MappedByteBuffer buf = null;
            buf = ((FileChannel)channel).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)channel).size());
            PDFFile pdffile = null;
            pdffile = new PDFFile((ByteBuffer)buf);
            PDFPage page = pdffile.getPage(0);
            BufferedImage im_buf = PDFToImageHelper.convertPDFToImage(page, 800.0f, 800.0f);
            PDFToImageHelper.saveImage(im_buf, args[1]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (Exception e) {}
            }
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

