/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.bpm.sap.util;

import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.ibkey.bpm.sap.util.SAPManager;
import org.apache.log4j.Logger;

public class SAPConnector {
    Logger log = Logger.getLogger(SAPManager.class);
    private static final long serialVersionUID = 1L;
    private static JCO.Client conexion;
    private String usuario;
    private String password;
    private String host;
    private String client;
    private String sysNumber;
    private String lng;
    private String desbloqueo;

    public SAPConnector(String[] params) {
        this.usuario = params[0];
        this.password = params[1];
        this.host = params[2];
        this.client = params[3];
        this.sysNumber = params[4];
        this.lng = params[5];
        this.desbloqueo = params[6];
        if (this.desbloqueo == null) {
            this.desbloqueo = "N";
        }
    }

    public SAPConnector(String user, String pass, String host, String client, String sys, String lang) {
        this.usuario = user;
        this.password = pass;
        this.host = host;
        this.client = client;
        this.sysNumber = sys;
        this.lng = lang;
        if (this.desbloqueo == null) {
            this.desbloqueo = "N";
        }
    }

    private void stablishConnection() throws UserWorkflowException {
        try {
            if (JCO.getClientPoolManager().getPool("x10") == null) {
                JCO.addClientPool((String)"x10", (int)5, (String)this.client, (String)this.usuario, (String)this.password, (String)this.lng, (String)this.host, (String)this.sysNumber);
            }
            conexion = JCO.getClient((String)"x10");
        }
        catch (Throwable ex) {
            throw new UserWorkflowException("Error en la conexi\u00ef\u00bf\u0153n con SAP:", ex);
        }
    }

    protected IRepository createRepository(JCO.Client conexion) throws UserWorkflowException {
        try {
            JCO.Repository repository = new JCO.Repository("Repo", conexion);
            return repository;
        }
        catch (Throwable ex) {
            throw new UserWorkflowException("Error en la creaci\u00c3\u00b3n del repositorio:", ex);
        }
    }

    protected void cerrarConexion() throws UserWorkflowException {
        try {
            if (conexion != null) {
                JCO.releaseClient((JCO.Client)conexion);
                conexion = null;
            }
        }
        catch (Throwable ex) {
            throw new UserWorkflowException("No se ha podido cerrar la conexi\u00c3\u00b3n con SAP:", ex);
        }
    }

    protected JCO.Client getConnection() throws UserWorkflowException {
        if (conexion == null) {
            this.stablishConnection();
        }
        return conexion;
    }
}

