/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.bpm.sap.util;

import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.ibkey.alfresco.client.AlfrescoRepositoryClient;
import es.caib.ibkey.alfresco.ws.AuthenticationUtils;
import es.caib.ibkey.alfresco.ws.InternalErrorException;
import es.caib.ibkey.bpm.common.ContentTypeRegistry;
import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.sap.util.SAPConnector;
import es.caib.ibkey.utils.NamedContent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.alfresco.www.ws.service.authentication._1_0.AuthenticationFault;
import org.alfresco.www.ws.service.content._1_0.Content;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;

public class SAPManager
extends SAPConnector {
    Logger log = Logger.getLogger(SAPManager.class);

    public SAPManager(String user, String pass, String host, String client, String sys, String lang) {
        super(user, pass, host, client, sys, lang);
    }

    public NamedContent getAnexo(String code) throws UserWorkflowException {
        JCO.Client client = this.getConnection();
        try {
            if (code == null || code.length() != 33) {
                throw new Exception("Identificador de anexo incorrecto");
            }
            IRepository repository = this.createRepository(client);
            IFunctionTemplate ftemplate = repository.getFunctionTemplate("ZSICFD_IBKEY_ANEXO");
            JCO.Function function = ftemplate.getFunction();
            String expcla = code.substring(0, 5);
            String expeje = code.substring(5, 9);
            String expnum = code.substring(9, 19);
            String docnum = code.substring(19, 29);
            String doceje = code.substring(29, 33);
            JCO.Structure idibkey = function.getImportParameterList().getStructure("ID_IN");
            idibkey.setValue(expcla, "CLASE");
            idibkey.setValue(docnum, "NUMDOC");
            idibkey.setValue(expnum, "NUMEXP");
            idibkey.setValue(expeje, "EJEEXP");
            idibkey.setValue(doceje, "EJEDOC");
            client.execute(function);
            String name = function.getExportParameterList().getString("NAME");
            String content = function.getExportParameterList().getString("FILE_OUT");
            String coderr = function.getExportParameterList().getString("CODERR");
            NamedContent anexeDoc = null;
            if ("0".equals(coderr)) {
                anexeDoc = this.getAnnexeDocFromSap(name, content);
            } else if ("6".equals(coderr)) {
                anexeDoc = this.getAnnexeDocFromAlfresco(name, content);
            } else {
                String descerr = function.getExportParameterList().getString("DESCERR");
                throw new UserWorkflowException("Codigo: " + coderr + " Error al recuperar el anexo en SAP" + code + " : " + descerr);
            }
            NamedContent namedContent = anexeDoc;
            return namedContent;
        }
        catch (Throwable e) {
            this.log.error((Object)"Error al recuperar el documento anexo al expediente:", e);
            throw new UserWorkflowException("Error al recuperar el documento anexo al expediente:" + e);
        }
        finally {
            this.cerrarConexion();
        }
    }

    public String getAnexosList(String expcla, String expeje, String expnum, String docnum, String doceje) throws UserWorkflowException {
        JCO.Client client = this.getConnection();
        try {
            String ret;
            IRepository repository = this.createRepository(client);
            IFunctionTemplate ftemplate = repository.getFunctionTemplate("ZSICFD_IBKEY_ANEXO_LISTA");
            JCO.Function function = ftemplate.getFunction();
            JCO.Structure idibkey = function.getImportParameterList().getStructure("ID_IN");
            idibkey.setValue(expcla, "CLASE");
            idibkey.setValue(docnum, "NUMDOC");
            idibkey.setValue(expnum, "NUMEXP");
            idibkey.setValue(expeje, "EJEEXP");
            idibkey.setValue(doceje, "EJEDOC");
            client.execute(function);
            String string = ret = function.getExportParameterList().getString("LISTA_ANEXOS");
            return string;
        }
        catch (Throwable e) {
            this.log.error((Object)"Error al recuperar la lista de anexos:", e);
            throw new UserWorkflowException("Error al recuperar la lista de anexos:" + e);
        }
        finally {
            this.cerrarConexion();
        }
    }

    public void changeState(String expcla, String expeje, String expnum, String docnum, String doceje, String state, String desc) throws UserWorkflowException {
        try {
            JCO.Client client = this.getConnection();
            IRepository repository = this.createRepository(client);
            IFunctionTemplate ftemplate = repository.getFunctionTemplate("ZSICFD_IBKEY_SET_STATE");
            JCO.Function function = ftemplate.getFunction();
            JCO.Structure idibkey = function.getImportParameterList().getStructure("ID_IN");
            idibkey.setValue(expcla, "CLASE");
            idibkey.setValue(docnum, "NUMDOC");
            idibkey.setValue(expnum, "NUMEXP");
            idibkey.setValue(expeje, "EJEEXP");
            idibkey.setValue(doceje, "EJEDOC");
            function.getImportParameterList().setValue(state, "STATE");
            function.getImportParameterList().setValue(desc, "TEXT");
            client.execute(function);
            String coderr = function.getExportParameterList().getString("CODERR");
            if (!"0".equals(coderr)) {
                String descerr = function.getExportParameterList().getString("DESCERR");
                throw new UserWorkflowException("Codigo: " + coderr + " Error al cambiar el estado del expediente en SAP: " + descerr);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error al cambiar el estado del expediente:", (Throwable)e);
            throw new UserWorkflowException("Error al cambiar el estado del expediente:", (Throwable)e);
        }
        finally {
            this.cerrarConexion();
        }
    }

    public NamedContent[] getAnexos(String expcla, String expeje, String expnum, String docnum, String doceje) throws Exception {
        JCO.Client client = this.getConnection();
        NamedContent[] anexeDocList = null;
        try {
            IRepository repository = this.createRepository(client);
            IFunctionTemplate ftemplate = repository.getFunctionTemplate("ZSICFD_IBKEY_ANEXO_LISTA");
            JCO.Function function = ftemplate.getFunction();
            JCO.Structure idibkey = function.getImportParameterList().getStructure("ID_IN");
            idibkey.setValue(expcla, "CLASE");
            idibkey.setValue(docnum, "NUMDOC");
            idibkey.setValue(expnum, "NUMEXP");
            idibkey.setValue(expeje, "EJEEXP");
            idibkey.setValue(doceje, "EJEDOC");
            client.execute(function);
            String idAnnexosList = function.getExportParameterList().getString("LISTA_ANEXOS");
            this.log.debug((Object)("Recuperada lista de anexos del documento: " + expcla + " " + expeje + " " + expnum + " " + docnum));
            if (idAnnexosList != null && !"".equals(idAnnexosList)) {
                String[] idAnnexos = idAnnexosList.split(";");
                anexeDocList = new NamedContent[idAnnexos.length];
                for (int i = 0; i < idAnnexos.length; ++i) {
                    ftemplate = repository.getFunctionTemplate("ZSICFD_IBKEY_ANEXO");
                    function = ftemplate.getFunction();
                    expcla = idAnnexos[i].substring(0, 5);
                    expeje = idAnnexos[i].substring(5, 9);
                    expnum = idAnnexos[i].substring(9, 19);
                    docnum = idAnnexos[i].substring(19, 29);
                    doceje = idAnnexos[i].substring(29, 33);
                    idibkey = function.getImportParameterList().getStructure("ID_IN");
                    idibkey.setValue(expcla, "CLASE");
                    idibkey.setValue(docnum, "NUMDOC");
                    idibkey.setValue(expnum, "NUMEXP");
                    idibkey.setValue(expeje, "EJEEXP");
                    idibkey.setValue(doceje, "EJEDOC");
                    client.execute(function);
                    String name = function.getExportParameterList().getString("NAME");
                    String content = function.getExportParameterList().getString("FILE_OUT");
                    String coderr = function.getExportParameterList().getString("CODERR");
                    if ("0".equals(coderr)) {
                        anexeDocList[i] = this.getAnnexeDocFromSap(name, content);
                        this.log.debug((Object)("Anexo recuperado de SAP: " + idAnnexos[i]));
                        continue;
                    }
                    if ("6".equals(coderr)) {
                        anexeDocList[i] = this.getAnnexeDocFromAlfresco(name, content);
                        this.log.debug((Object)("Anexo recuperado de ARCHIVELINK: " + idAnnexos[i]));
                        continue;
                    }
                    String descerr = function.getExportParameterList().getString("DESCERR");
                    throw new UserWorkflowException("Codigo: " + coderr + " Error al recuperar el anexo en SAP" + idAnnexos[i] + " : " + descerr);
                }
            } else {
                this.log.debug((Object)("Documento sin anexos: " + expcla + " " + expeje + " " + expnum + " " + docnum));
            }
            NamedContent[] namedContentArray = anexeDocList;
            return namedContentArray;
        }
        catch (Throwable e) {
            this.log.error((Object)"Error al recuperar la lista de anexos:", e);
            throw new UserWorkflowException("Error al recuperar la lista de anexos:" + e);
        }
        finally {
            this.cerrarConexion();
        }
    }

    private NamedContent getAnnexeDocFromAlfresco(String archiveId, String hashlink) throws Throwable {
        this.log.debug((Object)("Inicio de recuperaci\u00c3\u00b3n del anexo de sap desde alfresco: " + hashlink));
        if (IBkeyConfig.getAlfrescoIBkeySAPArchiveId().equals(archiveId)) {
            AlfrescoRepositoryClient alfresco_client = new AlfrescoRepositoryClient();
            try {
                AuthenticationUtils.startSession(null, IBkeyConfig.getSapUser(), IBkeyConfig.getSapPassword(), Long.parseLong(IBkeyConfig.getAlfrescoWSTimeoutMilis()));
            }
            catch (AuthenticationFault e) {
                this.log.error((Object)e.getMessage(), (Throwable)((Object)e));
                throw e;
            }
            catch (InternalErrorException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            this.log.debug((Object)("Sesi\u00c3\u00b3n de alfresco autenticada: " + AuthenticationUtils.getTicket()));
            try {
                NamedContent out = alfresco_client.getContentByHashlink(hashlink);
                String extension = new ContentTypeRegistry().getExtensionByContentType(out.getMimeType());
                out.setName(out.getName() + extension);
                this.log.debug((Object)("Fin de descarga del anexo de sap desde alfresco: " + hashlink));
                NamedContent namedContent = out;
                return namedContent;
            }
            catch (Throwable e) {
                this.log.error((Object)e.getMessage(), e);
                throw e;
            }
            finally {
                String __ticket = AuthenticationUtils.getTicket();
                try {
                    AuthenticationUtils.endSession(null);
                }
                catch (InternalErrorException e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
                this.log.debug((Object)("Sesi\u00c3\u00b3n de alfresco finalizada: " + __ticket));
            }
        }
        throw new SystemWorkflowException("No es pot recuperar el document d'alfresco perque no esta a l'entorn associat a l'aplicaci\u00c3\u00b3 ibkey: " + IBkeyConfig.getAlfrescoIBkeySAPArchiveId());
    }

    private NamedContent getAnnexeDocFromSap(String name, String content) throws IOException {
        byte[] outContent = new BASE64Decoder().decodeBuffer(content);
        String mimeType = this.extractMimeTypeFromFileName(name);
        return new NamedContent(name, outContent, mimeType, "UTF-8");
    }

    private String extractMimeTypeFromFileName(String fileName) throws IOException {
        String fileExtension = fileName.substring(fileName.lastIndexOf("."));
        String mime = new ContentTypeRegistry().getContentTypeByExtension(fileExtension);
        if (mime == null) {
            mime = "plain/text";
        }
        return mime;
    }

    private byte[][] decodeContent(Content[] encodedContent) throws UnsupportedEncodingException {
        byte[][] results = new byte[encodedContent.length][];
        for (int i = 0; i < encodedContent.length; ++i) {
            try {
                results[i] = encodedContent[i].getProperty().getBytes(encodedContent[i].getFormat().getEncoding());
                continue;
            }
            catch (UnsupportedEncodingException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return results;
    }

    public void setTicket(String expcla, String expeje, String expnum, String docnum, String doceje, String file) throws UserWorkflowException {
        JCO.Client client = this.getConnection();
        try {
            IRepository repository = this.createRepository(client);
            IFunctionTemplate ftemplate = repository.getFunctionTemplate("ZSICFD_IBKEY_GET_CUSTODIA");
            JCO.Function function = ftemplate.getFunction();
            JCO.Structure idibkey = function.getImportParameterList().getStructure("ID_IN");
            idibkey.setValue(expcla, "CLASE");
            idibkey.setValue(docnum, "NUMDOC");
            idibkey.setValue(expnum, "NUMEXP");
            idibkey.setValue(expeje, "EJEEXP");
            idibkey.setValue(doceje, "EJEDOC");
            function.getImportParameterList().setValue(file, "FILE_IN");
            client.execute(function);
            String coderr = function.getExportParameterList().getString("CODERR");
            if (!"0".equals(coderr)) {
                String descerr = function.getExportParameterList().getString("DESCERR");
                throw new UserWorkflowException("Codigo: " + coderr + " Error al subir el ticket en SAP: " + descerr);
            }
        }
        catch (Throwable e) {
            this.log.error((Object)"Error al asociar el ticket al expediente:", e);
            throw new UserWorkflowException("Error al asociar el ticket al expediente:" + e.getMessage());
        }
        finally {
            this.cerrarConexion();
        }
    }

    protected void creaArchiveLinkSAP(String archivId, String arcDocId, String arObject, String mandant, String objectId, String sapObject, String docType) throws UserWorkflowException {
        JCO.Client client = this.getConnection();
        try {
            IRepository repository = this.createRepository(client);
            IFunctionTemplate ftemplate = repository.getFunctionTemplate("ARCHIV_CONNECTION_INSERT");
            JCO.Function function = ftemplate.getFunction();
            function.getImportParameterList().setValue(archivId, "ARCHIV_ID");
            function.getImportParameterList().setValue(arcDocId, "ARC_DOC_ID");
            function.getImportParameterList().setValue(arObject, "AR_OBJECT");
            function.getImportParameterList().setValue(mandant, "MANDANT");
            function.getImportParameterList().setValue(objectId, "OBJECT_ID");
            function.getImportParameterList().setValue(sapObject, "SAP_OBJECT");
            function.getImportParameterList().setValue(docType, "DOC_TYPE");
            client.execute(function);
        }
        catch (Throwable e) {
            this.log.error((Object)"Error al crear el archivelink:", e);
            throw new UserWorkflowException("Error al crear el archivelink:" + e.getMessage());
        }
        finally {
            this.cerrarConexion();
        }
    }

    public String[][] readTable(String tableName, String[] query, String[] fieldSpecs) throws UserWorkflowException, SystemWorkflowException {
        JCO.Client client = this.getConnection();
        try {
            IRepository repository = this.createRepository(client);
            IFunctionTemplate ftemplate = repository.getFunctionTemplate("RFC_READ_TABLE");
            JCO.Function function = ftemplate.getFunction();
            if (function == null) {
                throw new SystemWorkflowException("'" + "RFC_READ_TABLE" + "' not found in SAP.");
            }
            function.getImportParameterList().setValue(tableName, "QUERY_TABLE");
            function.getImportParameterList().setValue(";", "DELIMITER");
            JCO.Table optionsTable = function.getTableParameterList().getTable("OPTIONS");
            for (int i = 0; i < query.length; ++i) {
                optionsTable.appendRow();
                optionsTable.setRow(i);
                optionsTable.setValue(query[i], 0);
            }
            if (fieldSpecs.length != 0) {
                JCO.Table fields = function.getTableParameterList().getTable("FIELDS");
                int row = 0;
                for (int i = 0; i < fieldSpecs.length; ++i) {
                    fields.appendRow();
                    fields.setRow(row);
                    fields.setValue(fieldSpecs[i], 0);
                    ++row;
                }
            }
            client.execute(function);
            JCO.Table codes = function.getTableParameterList().getTable("DATA");
            this.log.debug((Object)("Numero de entradas en SAP que coiciden con los criterios de b\u00c3\u00basqueda: '" + codes.getNumRows() + "'"));
            StringBuffer sbuff = new StringBuffer();
            String[][] results = null;
            for (int i = 0; i < codes.getNumRows(); ++i) {
                codes.setRow(i);
                for (int j = 0; j < codes.getFieldCount(); ++j) {
                    if (results == null) {
                        results = new String[codes.getNumRows()][codes.getFieldCount()];
                    }
                    results[i][j] = codes.getString(j);
                }
            }
            String[][] stringArray = results;
            return stringArray;
        }
        catch (Throwable e) {
            this.log.error((Object)"Error al recuperar datos de la tabla SAP:", e);
            throw new UserWorkflowException("Error al recuperar datos de la tabla SAP:" + e.getMessage());
        }
        finally {
            this.cerrarConexion();
        }
    }

    public void appendArchiveLinkToExpedient(String archivId, String arcDocId, String arObject, String objectId, String docType, String clase, String ejexp, String numexp, String filename) throws UserWorkflowException {
        JCO.Client client = this.getConnection();
        try {
            IRepository repository = this.createRepository(client);
            IFunctionTemplate ftemplate = repository.getFunctionTemplate("ZSICODE_GEX04_ARC");
            JCO.Function function = ftemplate.getFunction();
            function.getImportParameterList().setValue(docType, "DOC_TYPE");
            function.getImportParameterList().setValue(clase, "CLASE");
            function.getImportParameterList().setValue(ejexp, "EJEEXP");
            function.getImportParameterList().setValue(numexp, "NUMEXP");
            function.getImportParameterList().setValue(filename, "FILENAME");
            function.getImportParameterList().setValue(archivId, "ARCHIV_ID");
            function.getImportParameterList().setValue(arcDocId, "ARC_DOC_ID");
            function.getImportParameterList().setValue(objectId, "OBJECT_ID");
            function.getImportParameterList().setValue(arObject, "AR_OBJECT");
            client.execute(function);
            String coderr = function.getExportParameterList().getStructure("RETURN").getString("TYPE");
            String msgerr = function.getExportParameterList().getStructure("RETURN").getString("MESSAGE");
            if ("E".equals(coderr)) {
                throw new UserWorkflowException("Error en la llamada ZSICODE_GEX04_ARC [" + coderr + "] " + msgerr);
            }
            if ("W".equals(coderr)) {
                this.log.warn((Object)("Alerta en la llamada a SAP ZSICODE_GEX04_ARC: " + msgerr));
            }
        }
        catch (Throwable e) {
            this.log.error((Object)"Error al substituir un documento por un archivelink:", e);
            throw new UserWorkflowException("Error al substituir un documento por un archivelink:" + e.getMessage());
        }
        finally {
            this.cerrarConexion();
        }
    }

    public boolean checkExpedientExists(String clase, String exercici, String expedient) throws UserWorkflowException, SystemWorkflowException {
        String[][] entradas = this.readTable("/GEX/01", new String[]{" CLASE = '" + clase + "' AND ", " EJEEXP = '" + exercici + "' AND ", " NUMEXP = '" + expedient + "' "}, new String[]{"TITULO"});
        return entradas != null && entradas.length != 0;
    }
}

