/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.ghostscript.helper;

import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.conversion.exception.ConversionException;
import es.caib.ibkey.oppenoffice.helper.Pipe;
import es.caib.ibkey.utils.Log4jPrintStreamAdapter;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class GhostScriptConversionHelper {
    private Pipe errStreamHandler;
    private Pipe outStreamHandler;

    public String convertDocument(String stringInputDocument, String stringConvertType, String stringOutputDocument, Map filterOptions) throws IOException, ConversionException, InterruptedException {
        Logger log = Logger.getLogger(this.getClass());
        Runtime r = Runtime.getRuntime();
        Process gsProcess = null;
        try {
            gsProcess = r.exec(this.getGSCommand(stringInputDocument, stringOutputDocument, filterOptions));
            this.outStreamHandler = new Pipe();
            this.outStreamHandler.pipe(gsProcess.getInputStream(), new Log4jPrintStreamAdapter(log, 'd'), "CO> ");
            this.errStreamHandler = new Pipe();
            this.errStreamHandler.pipe(gsProcess.getErrorStream(), new Log4jPrintStreamAdapter(log, 'e'), "CE> ");
            gsProcess.waitFor();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (gsProcess != null && gsProcess.exitValue() != 0) {
                throw new ConversionException("Ghostscript process exitted with error value " + gsProcess.exitValue());
            }
            if (this.outStreamHandler != null) {
                this.outStreamHandler.unpipe();
            }
            if (this.errStreamHandler != null) {
                this.errStreamHandler.unpipe();
            }
        }
        return stringOutputDocument;
    }

    private String[] getGSCommand(String stringInputDocument, String stringOutputDocument, Map filterOptions) {
        Vector<String> buf = new Vector<String>();
        buf.add(IBkeyConfig.getGhostScriptExecutablePath());
        buf.add("-dUseCIEColor=true");
        buf.add("-dPDFA");
        if (IBkeyConfig.getGhostScriptDeviceColorModel() != null) {
            buf.add("-sProcessColorModel=" + IBkeyConfig.getGhostScriptDeviceColorModel());
        } else {
            buf.add("-sProcessColorModel=DeviceRGB");
        }
        if (filterOptions != null && filterOptions.get("GS.documentUUID") != null) {
            buf.add("-sDocumentUUID=" + filterOptions.get("GS.documentUUID"));
        }
        buf.add("-sDEVICE=pdfwrite");
        buf.add("-dNOPAUSE");
        buf.add("-dBATCH");
        buf.add("-sSAFE");
        buf.add("-sFONTPATH=" + IBkeyConfig.getGhostScriptFontPath());
        buf.add("-sOutputFile=" + stringOutputDocument);
        buf.add(IBkeyConfig.getGhostScriptPDFATemplatePath());
        buf.add(stringInputDocument);
        return buf.toArray(new String[buf.size()]);
    }
}

