/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.oppenoffice.helper;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.frame.TerminationVetoException;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import es.caib.ibkey.oppenoffice.helper.OOoServer;
import org.apache.log4j.Logger;

public class BootstrapConnector
implements XTerminateListener {
    private OOoServer oooServer;
    private Object desktop;
    private XDesktop xDesktop;
    private String oooConnectionString;
    private Boolean canConnect = new Boolean(true);
    XComponentContext xLocalContext;
    XConnector xConnector = null;
    XConnection xConnection = null;
    XBridge xBridge = null;
    private Logger logger = Logger.getLogger(BootstrapConnector.class);

    public BootstrapConnector(String oooExecFolder) {
        this.oooServer = new OOoServer(oooExecFolder);
        this.oooConnectionString = null;
    }

    public BootstrapConnector(OOoServer oooServer) {
        this.oooServer = oooServer;
        this.oooConnectionString = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XComponentContext connect(String oooAcceptOption, String oooConnectionString) throws BootstrapException {
        XComponentContext xContext = null;
        boolean canConnect_ = true;
        do {
            String tempString;
            Boolean bl = this.canConnect;
            synchronized (bl) {
                canConnect_ = this.canConnect;
                if (canConnect_) {
                    this.oooConnectionString = oooConnectionString;
                    try {
                        this.xLocalContext = this.getLocalContext();
                        this.oooServer.start(oooAcceptOption);
                        int i = 0;
                        while (true) {
                            this.logger.info((Object)"Intento de conexi\u00c3\u00b3n al openoffice");
                            try {
                                this.xConnector = this.getConnector(this.xLocalContext, oooConnectionString);
                                this.logger.debug((Object)"tenemos el xConnector");
                                this.xConnection = this.getConnection(this.xConnector, oooConnectionString);
                                this.logger.debug((Object)"tenemos la xConnection");
                                this.xBridge = this.getBridge(this.xLocalContext, this.xConnection);
                                this.logger.debug((Object)"tenemos el xBridge");
                                xContext = this.getRemoteContext(this.xBridge);
                                this.logger.debug((Object)"tenemos el xContext");
                                this.desktop = xContext.getServiceManager().createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
                                this.xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)this.desktop);
                                this.logger.debug((Object)"tenemos el xDesktop");
                                this.xDesktop.addTerminateListener((XTerminateListener)this);
                                this.logger.debug((Object)"Callback terminateListener registrado");
                            }
                            catch (com.sun.star.uno.Exception ex) {
                                block31: {
                                    try {
                                        XComponent xcomponent;
                                        this.logger.warn((Object)("Intento de conexi\u00c3\u00b3n " + i + " al openoffice fallido: " + ex.getMessage()));
                                        this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                                        if (this.xDesktop != null) {
                                            this.xDesktop.terminate();
                                        }
                                        if (this.xBridge != null && (xcomponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xBridge)) != null) {
                                            xcomponent.dispose();
                                        }
                                        if (this.xConnection != null) {
                                            this.xConnection.close();
                                        }
                                        if (this.xConnector != null && (xcomponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xConnector)) != null) {
                                            xcomponent.dispose();
                                        }
                                    }
                                    catch (com.sun.star.uno.Exception ex1) {
                                        this.logger.warn((Object)("Intento de liberaci\u00c3\u00b3n de conexi\u00c3\u00b3n al openoffice fallido: " + ex.getMessage()));
                                    }
                                    finally {
                                        try {
                                            Thread.sleep(500L);
                                        }
                                        catch (InterruptedException ie) {}
                                        if (i != 60) break block31;
                                        throw new BootstrapException("Realizados 60 reintentos de conexi\u00c3\u00b3n al openoffice: " + ex.toString());
                                    }
                                }
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BootstrapException(e);
                    }
                }
            }
            if (canConnect_) continue;
            String string = tempString = new String();
            synchronized (string) {
                try {
                    tempString.wait(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        } while (!canConnect_);
        return xContext;
    }

    private XBridge getBridge(XComponentContext mxComponentContext, XConnection connection) throws com.sun.star.uno.Exception {
        Object x = mxComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.bridge.BridgeFactory", mxComponentContext);
        XBridgeFactory xBridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, (Object)x);
        if (xBridgeFactory == null) {
            this.logger.fatal((Object)"Bridge factoriy is null");
        }
        XBridge bridge = xBridgeFactory.createBridge("", "urp", connection, null);
        return bridge;
    }

    private XConnection getConnection(XConnector xConnector, String ooConnectionString) throws NoConnectException, ConnectionSetupException {
        XConnection connection = xConnector.connect(ooConnectionString);
        if (connection == null) {
            this.logger.fatal((Object)"Connection is null");
        }
        return connection;
    }

    private XConnector getConnector(XComponentContext mxComponentContext, String ooConnectionString) throws com.sun.star.uno.Exception {
        Object x = mxComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.connection.Connector", mxComponentContext);
        XConnector xConnector = (XConnector)UnoRuntime.queryInterface(XConnector.class, (Object)x);
        return xConnector;
    }

    public void disconnect() {
        if (this.oooConnectionString == null) {
            return;
        }
        this.oooConnectionString = null;
        XComponent xcomponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.xBridge);
        xcomponent.dispose();
        this.oooServer.disconnect();
    }

    public void kill() {
        this.oooServer.kill();
    }

    private XComponentContext getLocalContext() throws Exception {
        XComponentContext xLocalContext = Bootstrap.createInitialComponentContext(null);
        if (xLocalContext == null) {
            throw new BootstrapException("no local component context!");
        }
        return xLocalContext;
    }

    private XComponentContext getRemoteContext(XBridge bridge) throws UnknownPropertyException, WrappedTargetException {
        Object x = bridge.getInstance("StarOffice.ServiceManager");
        XMultiComponentFactory mxMCF = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)x);
        XPropertySet xProperySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)mxMCF);
        Object oDefaultContext = xProperySet.getPropertyValue("DefaultContext");
        XComponentContext mxComponentContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)oDefaultContext);
        return mxComponentContext;
    }

    public static final XComponentContext bootstrap(String oooExecFolder, String oooAcceptOption, String oooConnectionString) throws BootstrapException {
        BootstrapConnector bootstrapConnector = new BootstrapConnector(oooExecFolder);
        return bootstrapConnector.connect(oooAcceptOption, oooConnectionString);
    }

    public void notifyTermination(EventObject arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryTermination(EventObject arg0) throws TerminationVetoException {
        Boolean bl = this.canConnect;
        synchronized (bl) {
            if (this.oooConnectionString != null) {
                throw new TerminationVetoException();
            }
            this.canConnect = new Boolean(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposing(EventObject arg0) {
        Boolean bl = this.canConnect;
        synchronized (bl) {
            this.canConnect = new Boolean(true);
        }
    }
}

