/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.oppenoffice.helper;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XPropertyReplace;
import com.sun.star.util.XRefreshable;
import com.sun.star.util.XReplaceDescriptor;
import com.sun.star.util.XReplaceable;
import com.sun.star.util.XSearchDescriptor;
import com.sun.star.util.XSearchable;
import es.caib.ibkey.bpm.conversion.exception.ConversionException;
import es.caib.ibkey.oppenoffice.helper.BootstrapConnector;
import es.caib.ibkey.oppenoffice.helper.OpenOfficeDocumentConversionHelper;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Logger;

public class OOReplaceFieldsHelper {
    public Logger log = Logger.getLogger(OOReplaceFieldsHelper.class);
    protected BootstrapConnector connector = null;
    protected String host = System.getProperty("openoffice.host");
    protected String port = System.getProperty("openoffice.port");
    protected String pipe = System.getProperty("openoffice.pipe");
    protected String openofficeInstallDir = System.getProperty("openoffice.folder");
    public String overwrite = "false";

    public String replaceFieldsAndConvert(File ficheroOrigen, String ficheroSalida, Map table, String stringConvertType, Map filterOptions) throws Exception {
        this.log.info((Object)"Inici de substituci\u00c3\u00b3 de camps del document.");
        XComponentLoader xcomponentloader = null;
        XComponentContext xContext = null;
        String stringConvertedFile = "";
        try {
            this.connector = new BootstrapConnector(this.openofficeInstallDir);
            if (this.host != null) {
                xContext = this.connector.connect("-accept=socket,host=" + this.host + ",port=" + this.port + ";urp;", "socket,host=" + this.host + ",port=" + this.port + "");
            } else {
                if (this.pipe == null) {
                    this.pipe = "OOPipe_" + new Random().nextInt();
                }
                xContext = this.connector.connect("-accept=pipe,name=" + this.pipe + ";urp;", "pipe,name=" + this.pipe + ";urp;StarOffice.ComponentContext");
            }
            XMultiComponentFactory xMCF = xContext.getServiceManager();
            Object oDesktop = xMCF.createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
            xcomponentloader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)oDesktop);
            PropertyValue[] componentLoaderPropertyvalue = new PropertyValue[]{new PropertyValue()};
            componentLoaderPropertyvalue[0].Name = "Hidden";
            componentLoaderPropertyvalue[0].Value = new Boolean(true);
            XComponent objectDocumentToStore = null;
            ficheroSalida = !ficheroSalida.startsWith("file:///") ? "file:///" + ficheroSalida : ficheroSalida;
            String ficheroEntrada = "file:///" + ficheroOrigen.getAbsolutePath();
            objectDocumentToStore = xcomponentloader.loadComponentFromURL(ficheroEntrada.replaceAll("\\\\", "/"), "_blank", 0, componentLoaderPropertyvalue);
            XStorable xstorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)objectDocumentToStore);
            if (xstorable == null) {
                throw new ConversionException("El format del document d'entrada no \u00c3\u00a9s v\u00c3\u00a0lid per a realitzar el canvi de format.");
            }
            this.unprotectDocument(xstorable);
            this.replace(table, xstorable);
            Vector<PropertyValue> filterProperties = new Vector<PropertyValue>();
            PropertyValue fprop = new PropertyValue();
            fprop.Name = "Overwrite";
            fprop.Value = new Boolean(true);
            filterProperties.add(fprop);
            fprop = new PropertyValue();
            fprop.Name = "FilterName";
            fprop.Value = stringConvertType;
            filterProperties.add(fprop);
            Vector<PropertyValue> filterData = new Vector<PropertyValue>();
            if (filterOptions == null || stringConvertType.toLowerCase().contains("pdf") && filterOptions.get("SelectPdfVersion") == null) {
                PropertyValue fdata = new PropertyValue();
                fdata.Name = "SelectPdfVersion";
                fdata.Value = new Integer(1);
                filterData.add(fdata);
            }
            if (filterOptions != null) {
                for (String propertyName : filterOptions.keySet()) {
                    PropertyValue fdata = new PropertyValue();
                    fdata.Name = propertyName;
                    fdata.Value = filterOptions.get(propertyName);
                    filterData.add(fdata);
                }
            }
            if (filterData.size() != 0) {
                fprop = new PropertyValue();
                fprop.Name = "FilterData";
                fprop.Value = filterData.toArray(new PropertyValue[filterData.size()]);
                filterProperties.add(fprop);
            }
            ficheroSalida = ficheroSalida.replaceAll("\\\\", "/");
            xstorable.storeToURL(ficheroSalida, filterProperties.toArray(new PropertyValue[filterProperties.size()]));
            XCloseable xcloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xstorable);
            if (xcloseable != null) {
                xcloseable.close(false);
            } else {
                XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xstorable);
                xComponent.dispose();
            }
            if (stringConvertedFile.startsWith("file:///")) {
                stringConvertedFile = stringConvertedFile.substring(8);
            }
            this.log.info((Object)"Conversi\u00c3\u00b3 de format de document realitzada amb \u00c3\u0161xit.");
        }
        catch (Throwable th) {
            Logger.getLogger(OpenOfficeDocumentConversionHelper.class).error((Object)th.getMessage(), th);
            String message = th.getMessage();
            if (th instanceof ErrorCodeIOException) {
                message = message + ": " + ((ErrorCodeIOException)th).ErrCode;
            }
            Exception e1 = new Exception(message);
            e1.setStackTrace(th.getStackTrace());
            this.log.error((Object)e1.getMessage(), (Throwable)e1);
            throw e1;
        }
        finally {
            try {
                if (this.connector != null) {
                    this.connector.disconnect();
                }
            }
            catch (Throwable t) {}
        }
        return stringConvertedFile;
    }

    private void unprotectDocument(XStorable xDocument) throws NoSuchElementException, WrappedTargetException, UnknownPropertyException, PropertyVetoException, IllegalArgumentException {
        XTextDocument xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xDocument);
        XTextSectionsSupplier xSectionsSupplier = (XTextSectionsSupplier)UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)xTextDocument);
        XNameAccess sectionNameAccess = xSectionsSupplier.getTextSections();
        String[] sectionNames = sectionNameAccess.getElementNames();
        for (int i = 0; i < sectionNameAccess.getElementNames().length; ++i) {
            Object xSection = sectionNameAccess.getByName(sectionNames[i]);
            XPropertySet xTextProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xSection);
            xTextProps.setPropertyValue("IsProtected", (Object)new Boolean(false));
        }
    }

    public void replace(Map table, XStorable xDocument) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        XTextDocument xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xDocument);
        XReplaceable xReplaceable = (XReplaceable)UnoRuntime.queryInterface(XReplaceable.class, (Object)xTextDocument);
        for (String key : table.keySet()) {
            String reemplazo = table.get(key) != null ? table.get(key).toString() : null;
            XReplaceDescriptor xRepDesc = xReplaceable.createReplaceDescriptor();
            xRepDesc.setSearchString(key);
            XSearchable _oSearcheable = (XSearchable)UnoRuntime.queryInterface(XReplaceable.class, (Object)xTextDocument);
            XSearchDescriptor xSearchDescr = _oSearcheable.createSearchDescriptor();
            xSearchDescr.setSearchString(key);
            xSearchDescr.setPropertyValue("SearchCaseSensitive", (Object)new Boolean(false));
            xSearchDescr.setPropertyValue("SearchWords", (Object)new Boolean(true));
            XInterface xTextRange = (XInterface)_oSearcheable.findFirst(xSearchDescr);
            if (xTextRange != null) {
                PropertyValue[] aReplaceArgs = new PropertyValue[5];
                XPropertySet xTextProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextRange);
                aReplaceArgs[0] = new PropertyValue();
                aReplaceArgs[0].Name = "CharWeight";
                aReplaceArgs[0].Value = xTextProps.getPropertyValue("CharWeight");
                aReplaceArgs[1] = new PropertyValue();
                aReplaceArgs[1].Name = "CharPosture";
                aReplaceArgs[1].Value = xTextProps.getPropertyValue("CharPosture");
                aReplaceArgs[2] = new PropertyValue();
                aReplaceArgs[2].Name = "CharUnderline";
                aReplaceArgs[2].Value = xTextProps.getPropertyValue("CharUnderline");
                aReplaceArgs[3] = new PropertyValue();
                aReplaceArgs[3].Name = "CharHeight";
                aReplaceArgs[3].Value = xTextProps.getPropertyValue("CharHeight");
                aReplaceArgs[4] = new PropertyValue();
                aReplaceArgs[4].Name = "CharFontName";
                aReplaceArgs[4].Value = xTextProps.getPropertyValue("CharFontName");
                XPropertyReplace xPropRepl = (XPropertyReplace)UnoRuntime.queryInterface(XPropertyReplace.class, (Object)xRepDesc);
                xPropRepl.setReplaceAttributes(aReplaceArgs);
            }
            xRepDesc.setReplaceString(reemplazo);
            xReplaceable.replaceAll((XSearchDescriptor)xRepDesc);
        }
        XRefreshable xRefreshable = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)xReplaceable);
        xRefreshable.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        OOReplaceFieldsHelper handler = new OOReplaceFieldsHelper();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("#CONSELLERIA#", "pepito grillo");
        if (args.length == 2) {
            try {
                handler.replaceFieldsAndConvert(new File(args[0]), new File(args[1]).getAbsolutePath(), table, "writer_pdf_Export", null);
            }
            catch (Exception e) {
                Logger.getLogger(OpenOfficeDocumentConversionHelper.class).error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (handler.connector != null) {
                    handler.connector.disconnect();
                }
            }
        } else {
            XComponentContext xContext = null;
            try {
                handler.connector = new BootstrapConnector(handler.openofficeInstallDir);
                xContext = handler.connector.connect("-accept=socket,host=" + handler.host + ",port=" + handler.port + ";urp;", "socket,host=" + handler.host + ",port=" + handler.port + "");
            }
            catch (BootstrapException e) {
                Logger.getLogger(OpenOfficeDocumentConversionHelper.class).error((Object)e.getMessage(), (Throwable)e);
                System.exit(1);
            }
            handler.log.info((Object)"Connected to a running office ...");
            XMultiComponentFactory xMCF = xContext.getServiceManager();
            XMultiServiceFactory mServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xMCF);
            Object object = null;
            try {
                object = mServiceFactory.createInstance("com.sun.star.document.FilterFactory");
            }
            catch (Exception e) {
                handler.log.error((Object)e.getMessage(), (Throwable)e);
                System.exit(1);
            }
            XNameContainer ff = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)object);
            String[] types = ff.getElementNames();
            String help = "Usage: ConversionHandler inputFile outputFormat outputFileExtension \n\nConfiguration of each filter is defined in Common.xcs\n\nPossible output format filter values are : \n";
            StringBuffer buf = new StringBuffer(help);
            for (int i = 0; i < types.length; ++i) {
                buf.append(types[i]);
                buf.append("\n");
            }
            System.out.println(buf.toString());
            if (handler.connector != null) {
                handler.connector.disconnect();
            }
        }
    }
}

