/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.oppenoffice.helper;

import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.lib.util.NativeLibraryLoader;
import es.caib.ibkey.oppenoffice.helper.Pipe;
import es.caib.ibkey.utils.Log4jPrintStreamAdapter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class OOoServer {
    public Logger log = Logger.getLogger(OOoServer.class);
    private Process oooProcess = null;
    private String oooInstallFolder;
    private List oooOptions;
    private Pipe errStreamHandler;
    private Pipe outStreamHandler;

    public OOoServer(String oooInstallFolder) {
        this.oooInstallFolder = oooInstallFolder;
        this.oooOptions = OOoServer.getDefaultOOoOptions();
    }

    public OOoServer(String oooInstallFolder, List oooOptions) {
        this.oooInstallFolder = oooInstallFolder;
        this.oooOptions = oooOptions;
    }

    public void start(String oooAcceptOption) throws Exception {
        try {
            int arguments;
            if (oooAcceptOption.indexOf("socket") != -1 && oooAcceptOption.indexOf("localhost") == -1) {
                return;
            }
            String sOffice = System.getProperty("os.name").startsWith("Windows") ? "soffice.exe" : "soffice";
            URL[] oooInstallFolderURL = new URL[]{new URL("file://" + this.oooInstallFolder + "/program")};
            URLClassLoader loader = new URLClassLoader(oooInstallFolderURL);
            File fOffice = NativeLibraryLoader.getResource((ClassLoader)loader, (String)sOffice);
            if (fOffice == null) {
                throw new BootstrapException("No office executable found at " + oooInstallFolderURL[0].toExternalForm());
            }
            int n = arguments = this.oooOptions != null ? this.oooOptions.size() + 1 : 1;
            if (oooAcceptOption != null) {
                ++arguments;
            }
            String[] oooCommand = new String[arguments];
            oooCommand[0] = fOffice.getPath();
            for (int i = 0; i < this.oooOptions.size(); ++i) {
                oooCommand[i + 1] = (String)this.oooOptions.get(i);
            }
            if (oooAcceptOption != null) {
                oooCommand[arguments - 1] = oooAcceptOption;
            }
            this.oooProcess = Runtime.getRuntime().exec(oooCommand);
            this.outStreamHandler = new Pipe();
            this.outStreamHandler.pipe(this.oooProcess.getInputStream(), new Log4jPrintStreamAdapter(this.log, 'd'), "CO> ");
            this.errStreamHandler = new Pipe();
            this.errStreamHandler.pipe(this.oooProcess.getErrorStream(), new Log4jPrintStreamAdapter(this.log, 'e'), "CE> ");
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void checkConfig() throws Exception {
        File pdfFilterResourceFile;
        File file = pdfFilterResourceFile = System.getProperty("os.name").startsWith("Windows") ? new File(this.oooInstallFolder + "/Basis/program/resource/pdffilteres.res") : new File(this.oooInstallFolder + "/basis-link/program/resource/pdffilteres.res");
        if (pdfFilterResourceFile.exists() && !pdfFilterResourceFile.delete()) {
            throw new IOException("No se puede eliminar el fichero de configuraci\u00c3\u00b3n " + this.oooInstallFolder + "/Basis/program/resource/pdffilteres.res\nEsto puede provocar que se bloquee el hilo en caso que aparezca una notificaci\u00c3\u00b3n visual de alerta en el proceso de exportaci\u00c3\u00b3n a pdf/A.");
        }
    }

    public void kill() {
        if (this.oooProcess != null) {
            this.oooProcess.destroy();
            this.oooProcess = null;
        }
    }

    public static List getDefaultOOoOptions() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-nologo");
        options.add("-nodefault");
        options.add("-norestore");
        options.add("-nocrashreport");
        options.add("-nolockcheck");
        options.add("-headless");
        options.add("-nofirststartwizard");
        return options;
    }

    public void disconnect() {
        this.outStreamHandler.unpipe();
        this.errStreamHandler.unpipe();
    }
}

