/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.oppenoffice.helper;

import com.sun.star.beans.PropertyValue;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XCloseable;
import es.caib.ibkey.bpm.conversion.exception.ConversionException;
import es.caib.ibkey.oppenoffice.helper.BootstrapConnector;
import java.net.URL;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Logger;

public class OpenOfficeDocumentConversionHelper {
    public Logger log = Logger.getLogger(OpenOfficeDocumentConversionHelper.class);
    public BootstrapConnector connector = null;
    public String host = System.getProperty("openoffice.host");
    public String port = System.getProperty("openoffice.port");
    public String pipe = System.getProperty("openoffice.pipe");
    public String openofficeInstallDir = System.getProperty("openoffice.folder");

    public String convertDocument(String stringInputDocument, String stringConvertType, String stringOutputDocument, Map filterOptions) throws Exception {
        this.log.info((Object)"Inici de conversi\u00c3\u00b3 de format de document.");
        XComponentLoader xcomponentloader = null;
        XComponentContext xContext = null;
        String stringConvertedFile = "";
        try {
            this.connector = new BootstrapConnector(this.openofficeInstallDir);
            if (this.host != null) {
                xContext = this.connector.connect("-accept=socket,host=" + this.host + ",port=" + this.port + ";urp;", "socket,host=" + this.host + ",port=" + this.port + "");
            } else {
                if (this.pipe == null) {
                    this.pipe = "OOPipe_" + new Random().nextInt();
                }
                xContext = this.connector.connect("-accept=pipe,name=" + this.pipe + ";urp;", "pipe,name=" + this.pipe + ";urp;StarOffice.ComponentContext");
            }
            XMultiComponentFactory xMCF = xContext.getServiceManager();
            Object oDesktop = xMCF.createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
            xcomponentloader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)oDesktop);
            PropertyValue[] componentLoaderPropertyvalue = new PropertyValue[]{new PropertyValue()};
            componentLoaderPropertyvalue[0].Name = "Hidden";
            componentLoaderPropertyvalue[0].Value = new Boolean(true);
            XComponent objectDocumentToStore = null;
            String stringUrl = null;
            stringUrl = !stringInputDocument.startsWith("file:///") ? "file:///" + stringInputDocument : stringInputDocument;
            stringOutputDocument = !stringOutputDocument.startsWith("file:///") ? "file:///" + stringOutputDocument : stringOutputDocument;
            new URL(stringUrl).toString();
            objectDocumentToStore = xcomponentloader.loadComponentFromURL(stringUrl.replaceAll("\\\\", "/"), "_blank", 0, componentLoaderPropertyvalue);
            XStorable xstorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)objectDocumentToStore);
            if (xstorable == null) {
                throw new ConversionException("El format del document d'entrada no \u00c3\u00a9s v\u00c3\u00a0lid per a realitzar el canvi de format.");
            }
            Vector<PropertyValue> filterProperties = new Vector<PropertyValue>();
            PropertyValue fprop = new PropertyValue();
            fprop.Name = "Overwrite";
            fprop.Value = new Boolean(true);
            filterProperties.add(fprop);
            fprop = new PropertyValue();
            fprop.Name = "FilterName";
            fprop.Value = stringConvertType;
            filterProperties.add(fprop);
            Vector<PropertyValue> filterData = new Vector<PropertyValue>();
            if (filterOptions == null || stringConvertType.toLowerCase().contains("pdf") && filterOptions.get("SelectPdfVersion") == null) {
                PropertyValue fdata = new PropertyValue();
                fdata.Name = "SelectPdfVersion";
                fdata.Value = new Integer(1);
                filterData.add(fdata);
            }
            if (filterOptions != null) {
                for (String propertyName : filterOptions.keySet()) {
                    if (!propertyName.contains("OO.")) continue;
                    PropertyValue fdata = new PropertyValue();
                    fdata.Name = propertyName.replace("OO.", "");
                    fdata.Value = filterOptions.get(propertyName);
                    filterData.add(fdata);
                }
            }
            if (filterData.size() != 0) {
                fprop = new PropertyValue();
                fprop.Name = "FilterData";
                fprop.Value = filterData.toArray(new PropertyValue[filterData.size()]);
                filterProperties.add(fprop);
            }
            stringOutputDocument = stringOutputDocument.replaceAll("\\\\", "/");
            xstorable.storeToURL(stringOutputDocument, filterProperties.toArray(new PropertyValue[filterProperties.size()]));
            XCloseable xcloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)xstorable);
            if (xcloseable != null) {
                xcloseable.close(false);
            } else {
                XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xstorable);
                xComponent.dispose();
            }
            this.log.info((Object)"Conversi\u00c3\u00b3 de format de document realitzada amb \u00c3\u0161xit.");
        }
        catch (Throwable th) {
            Logger.getLogger(OpenOfficeDocumentConversionHelper.class).error((Object)th.getMessage(), th);
            String message = th.getMessage();
            if (th instanceof ErrorCodeIOException) {
                message = message + ": " + ((ErrorCodeIOException)th).ErrCode;
            }
            Exception e1 = new Exception(message);
            e1.setStackTrace(th.getStackTrace());
            this.log.error((Object)e1.getMessage(), (Throwable)e1);
            throw e1;
        }
        finally {
            try {
                if (this.connector != null) {
                    this.connector.disconnect();
                }
            }
            catch (Throwable t) {}
        }
        return stringOutputDocument;
    }

    public static void main(String[] args) throws Exception {
        OpenOfficeDocumentConversionHelper handler = new OpenOfficeDocumentConversionHelper();
        if (args.length == 3) {
            try {
                handler.convertDocument(args[0], args[1], args[2], null);
            }
            catch (Exception e) {
                Logger.getLogger(OpenOfficeDocumentConversionHelper.class).error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            XComponentContext xContext = null;
            try {
                handler.connector = new BootstrapConnector(handler.openofficeInstallDir);
                xContext = handler.connector.connect("-accept=socket,host=" + handler.host + ",port=" + handler.port + ";urp;", "socket,host=" + handler.host + ",port=" + handler.port + "");
            }
            catch (BootstrapException e) {
                Logger.getLogger(OpenOfficeDocumentConversionHelper.class).error((Object)e.getMessage(), (Throwable)e);
                System.exit(1);
            }
            handler.log.info((Object)"Connected to a running office ...");
            XMultiComponentFactory xMCF = xContext.getServiceManager();
            XMultiServiceFactory mServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xMCF);
            Object object = null;
            try {
                object = mServiceFactory.createInstance("com.sun.star.document.FilterFactory");
            }
            catch (Exception e) {
                handler.log.error((Object)e.getMessage(), (Throwable)e);
                System.exit(1);
            }
            XNameContainer ff = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)object);
            String[] types = ff.getElementNames();
            String help = "Usage: ConversionHandler inputFile outputFormat outputFileExtension \n\nConfiguration of each filter is defined in Common.xcs\n\nPossible output format filter values are : \n";
            StringBuffer buf = new StringBuffer(help);
            for (int i = 0; i < types.length; ++i) {
                buf.append(types[i]);
                buf.append("\n");
            }
            System.out.println(buf.toString());
            if (handler.connector != null) {
                handler.connector.disconnect();
            }
        }
    }
}

