/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.utils;

public class KPM {
    public static int indexOf(byte[] data, byte[] pattern) {
        int[] failure = KPM.computeFailure(pattern);
        int j = 0;
        for (int i = 0; i < data.length; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    public static int indexOf(byte[] data, byte[] pattern, int startOffset) {
        int[] failure = KPM.computeFailure(pattern);
        int j = 0;
        for (int i = startOffset; i < data.length; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    public static int indexOfBackwards(byte[] data, byte[] pattern, int startOffset) {
        int[] failure = KPM.computeFailure(pattern);
        int j = 0;
        for (int i = startOffset; i >= 0; --i) {
            while (j > 0 && pattern[pattern.length - j - 1] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[pattern.length - j - 1] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }
}

