/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class Log4jOutputStreamAdapter
extends OutputStream {
    public static final char DEBUG = 'd';
    public static final char WARN = 'w';
    public static final char ERROR = 'e';
    public static final char FATAL = 'f';
    public static final char NONE = 'n';
    protected char severity = (char)110;
    protected Logger log = null;

    public Log4jOutputStreamAdapter(Logger log, char severity) {
        this.log = log;
        this.severity = severity;
    }

    public void close() throws IOException {
        this.log = null;
    }

    public void flush() throws IOException {
    }

    public void write(byte[] b, int off, int len) throws IOException {
        byte[] buf = new byte[len];
        Arrays.copyOfRange(b, off, off + len);
        switch (this.severity) {
            case 'd': {
                this.log.debug((Object)new String(buf, "UTF-8"));
                break;
            }
            case 'w': {
                this.log.warn((Object)new String(buf, "UTF-8"));
                break;
            }
            case 'e': {
                this.log.error((Object)new String(buf, "UTF-8"));
                break;
            }
            case 'f': {
                this.log.fatal((Object)new String(buf, "UTF-8"));
                break;
            }
            case 'n': {
                break;
            }
        }
    }

    public void write(byte[] b) throws IOException {
        switch (this.severity) {
            case 'd': {
                this.log.debug((Object)new String(b, "UTF-8"));
                break;
            }
            case 'w': {
                this.log.warn((Object)new String(b, "UTF-8"));
                break;
            }
            case 'e': {
                this.log.error((Object)new String(b, "UTF-8"));
                break;
            }
            case 'f': {
                this.log.fatal((Object)new String(b, "UTF-8"));
                break;
            }
            case 'n': {
                break;
            }
        }
    }

    public void write(int b) throws IOException {
        switch (this.severity) {
            case 'd': {
                this.log.debug((Object)new String(new byte[]{(byte)b}, "UTF-8"));
                break;
            }
            case 'w': {
                this.log.warn((Object)new String(new byte[]{(byte)b}, "UTF-8"));
                break;
            }
            case 'e': {
                this.log.error((Object)new String(new byte[]{(byte)b}, "UTF-8"));
                break;
            }
            case 'f': {
                this.log.fatal((Object)new String(new byte[]{(byte)b}, "UTF-8"));
                break;
            }
            case 'n': {
                break;
            }
        }
    }
}

