/*
 * Decompiled with CFR 0.152.
 */
package es.caib.ibkey.utils;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import es.caib.ibkey.bpm.pdf.helper.PDFToImageHelper;
import es.caib.ibkey.utils.ImageProxy;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class PDFImageProxy
extends ImageProxy {
    private PDFImageProxy() {
    }

    public static ImageProxy getInstance(byte[] pdf, String name, int previewPage, int previewMaxHeight, int previewMaxWidth) throws Exception {
        ImageProxy out = new ImageProxy();
        try {
            PDFImageProxy.debug("PDFToImage begin");
            File cache = new File(System.getProperty("java.io.tmpdir") + "/" + name + "_preview_" + previewPage + ".jpg");
            PDFImageProxy.debug("Created file " + cache.getAbsolutePath());
            BufferedImage im_buf = null;
            ByteBuffer buf = ByteBuffer.wrap(pdf);
            PDFFile pdffile = null;
            pdffile = new PDFFile(buf);
            PDFPage page = null;
            page = previewPage >= 0 ? pdffile.getPage(previewPage) : pdffile.getPage(pdffile.getNumPages() + previewPage);
            float oldWidth = page.getWidth();
            float oldHeight = page.getHeight();
            PDFImageProxy.debug("Creating preview: dimensions " + previewMaxHeight + "," + previewMaxWidth);
            if (!cache.exists()) {
                im_buf = PDFToImageHelper.convertPDFToImage(page, previewMaxHeight, previewMaxWidth);
                PDFToImageHelper.saveImage(im_buf, cache.getAbsolutePath());
            } else {
                im_buf = ImageIO.read(cache);
            }
            out.setSrc(cache.getAbsolutePath());
            out.setHeight(new Integer(im_buf.getHeight()));
            out.setWidth(new Integer(im_buf.getWidth()));
            out.setOriginalHeight(new Float(oldHeight));
            out.setOriginalWidth(new Float(oldWidth));
            PDFImageProxy.debug("Created preview: original dimensions " + oldHeight + "," + oldWidth);
            PDFImageProxy.debug("Created preview: destiny dimensions " + im_buf.getHeight() + "," + im_buf.getWidth());
        }
        catch (Exception e) {
            PDFImageProxy.error(e.getMessage(), e);
            throw e;
        }
        return out;
    }

    protected static void error(String message, Exception e) {
        Logger.getLogger(PDFImageProxy.class).error((Object)message, (Throwable)e);
    }

    protected static void debug(String string) {
        Logger.getLogger(PDFImageProxy.class).debug((Object)string);
    }
}

