/*
 * Decompiled with CFR 0.152.
 */
package es.indra.www.portafirmasws.cws;

import es.indra.www.portafirmasws.cws.Cws;
import es.indra.www.portafirmasws.cws.CwsService;
import es.indra.www.portafirmasws.cws.CwsStub;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class CwsServiceLocator
extends Service
implements CwsService {
    private String CWS_address = "http://localhost/portafirmasws/web/services/CWS";
    private String CWSWSDDServiceName = "CWS";
    private HashSet ports = null;

    public CwsServiceLocator() {
    }

    public CwsServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public CwsServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    public String getCWSAddress() {
        return this.CWS_address;
    }

    public String getCWSWSDDServiceName() {
        return this.CWSWSDDServiceName;
    }

    public void setCWSWSDDServiceName(String name) {
        this.CWSWSDDServiceName = name;
    }

    public Cws getCWS() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.CWS_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getCWS(endpoint);
    }

    public Cws getCWS(URL portAddress) throws ServiceException {
        try {
            CwsStub _stub = new CwsStub(portAddress, this);
            _stub.setPortName(this.getCWSWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setCWSEndpointAddress(String address) {
        this.CWS_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (Cws.class.isAssignableFrom(serviceEndpointInterface)) {
                CwsStub _stub = new CwsStub(new URL(this.CWS_address), this);
                _stub.setPortName(this.getCWSWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("CWS".equals(inputPortName)) {
            return this.getCWS();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("http://www.indra.es/portafirmasws/cws", "CwsService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://www.indra.es/portafirmasws/cws", "CWS"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"CWS".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setCWSEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

