package es.caib.ibkey.cliente.CompulsaInitWorkflow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

import org.apache.log4j.Logger;

import es.caib.ibkey.cliente.common.IbkeyActionController;
import es.caib.ibkey.cliente.common.IbkeyControllerException;
import es.caib.ibkey.cliente.common.IbkeyData;
import es.caib.ibkey.cliente.common.IbkeyView;
import es.caib.ibkey.cliente.wizard.WizardNavigationController;

public class CompulsaWorkflowSetInfoView extends JPanel implements ActionListener, IbkeyView {

	Throwable error = null;

	private static final long serialVersionUID = 1L;
	private JLabel jLabelText = null;
	private JScrollPane jScrollPaneCenter = null;
	private JPanel jPanelCenter = null;

	// Widgets titular
	private JPanel jPanelDadesTitular = null;
	private JPanel jPanelDadesTitularLeft = null;
	private JPanel jPanelDadesTitularRight = null;
	private JPanel jPanelDadesTitularLeftNom = null;
	private JPanel jPanelDadesTitularLeftCognoms = null;
	private JPanel jPanelDadesTitularLeftNif = null;
	private JPanel jPanelDadesTitularLeftEmail = null;
	private JPanel jPanelDadesTitularNom = null;
	private JPanel jPanelDadesTitularCognoms = null;
	private JPanel jPanelDadesTitularNif = null;
	private JPanel jPanelDadesTitularEmail = null;
	private JLabel jLabelDadesTitularNom = null;
	private JLabel jLabelDadesTitularCognoms = null;
	private JLabel jLabelDadesTitularNif = null;
	private JLabel jLabelDadesTitularEmail = null;
	private JTextField jTextFieldDadesTitularNom = null;
	private JTextField jTextFieldDadesTitularCognoms = null;
	private JTextField jTextFieldDadesTitularNif = null;
	private JTextField jTextFieldDadesTitularEmail = null;

	// Widgets document
	private JPanel jPanelDocumentPrincipal = null;
	private JLabel jLabelDocumentPrincipalPath = null;
	private JButton jButtonViewDocumentPrincipalFile = null;

	private JLabel jLabelDocumentPrincipalName = null;
	private JPanel jPanelDocPrincipalLeft = null;
	private JPanel jPanelDocPrincipalRight = null;
	private JPanel jPanelDocPrincipalLeftNom = null;
	private JPanel jPanelDocPrincipalLeftFitxer = null;
	private JLabel jLabelDocPrincipalNom = null;
	private JLabel jLabelDocPrincipalFitxer = null;
	private JPanel jPanelDocPrincipalLeftMotiu = null;
	private JLabel jLabelDocPrincipalMotiu = null;
	private JPanel jPanelDocMotiu = null;
	private JTextArea jTextAreaDocumentPrincipalMotiu = null;

	private JPanel jPanelBottom = null;
	private JButton jButtonEnrere = null;
	private JButton jButtonEndavant = null;
	private JProgressBar jProgressBar = null;
	private JFileChooser chooser;
	private IbkeyActionController controller;
	private CompulsaWorkflowData data;
	private JPanel jPanelBottom1 = null;
	private JPanel jPanelBottom2 = null;
	private JPanel jPanelDocName = null;
	private JPanel jPanelDocPath = null;

	/**
	 * Default constructor
	 */
	public CompulsaWorkflowSetInfoView() {
		super();
		initialize();
	}

	/**
	 * Initializes this
	 */
	protected void initialize() {
		jLabelText = new JLabel();
		jLabelText.setText("Pas 2: Introducci\u00F3 de les dades del titular.");
		jLabelText.setHorizontalTextPosition(SwingConstants.CENTER);
		jLabelText.setHorizontalAlignment(SwingConstants.CENTER);
		this.setLayout(new BorderLayout());
		this.add(jLabelText, BorderLayout.NORTH);
		this.add(getJScrollPaneCenter(), BorderLayout.CENTER);
		this.add(getJPanelBottom(), BorderLayout.SOUTH);
		this.setSize(462, 400);
	}

	protected JScrollPane getJScrollPaneCenter() {
		if (jScrollPaneCenter == null) {
			jScrollPaneCenter = new JScrollPane();
			jScrollPaneCenter.setBorder(null);
			jScrollPaneCenter.setViewportView(getJPanelCenter());
		}
		return jScrollPaneCenter;
	}

	protected JPanel getJPanelCenter() {
		if (jPanelCenter == null) {
			jPanelCenter = new JPanel();
			jPanelCenter.setLayout(new BorderLayout());
			jPanelCenter.add(getJPanelDocumentPrincipal(), BorderLayout.NORTH);
			jPanelCenter.add(getJPanelDadesTitular(), BorderLayout.CENTER);
		}
		return jPanelCenter;
	}

	protected JPanel getJPanelDocumentPrincipal() {
		if (jPanelDocumentPrincipal == null) {
			jPanelDocumentPrincipal = new JPanel(new SpringLayout());
			jPanelDocumentPrincipal.setBorder(BorderFactory.createTitledBorder(null, "Dades del document", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Dialog", Font.BOLD, 12), new Color(51, 51, 51)));
						
			jPanelDocumentPrincipal.add(getJPanelLabelFitxer());
			jPanelDocumentPrincipal.add(getJPanelFieldFitxer());
			
			jPanelDocumentPrincipal.add(getJPanelLabelNom());
			jPanelDocumentPrincipal.add(getJPanelFieldNom());
			
			jPanelDocumentPrincipal.add(getJPanelLabelDescripcio());
			jPanelDocumentPrincipal.add(getJPanelFieldDescripcio());
			
			SpringUtilities.makeCompactGrid(jPanelDocumentPrincipal,
                    3, 2, //rows, cols
                    6, 6,        //initX, initY
                    6, 6);       //xPad, yPad
		}
		return jPanelDocumentPrincipal;
	}
	
	// PATH FITXER
	JPanel jPanelLabelFitxer = null;
	protected JPanel getJPanelLabelFitxer(){
		if (jPanelLabelFitxer == null){
			jPanelLabelFitxer = new JPanel(new FlowLayout(FlowLayout.RIGHT));
			jPanelLabelFitxer.setSize(new Dimension(150, 25));
			jPanelLabelFitxer.add(new JLabel("Fitxer"));
		}
		return jPanelLabelFitxer;
	}
	
	JPanel jPanelFieldFitxer = null;
	protected JPanel getJPanelFieldFitxer(){
		if (jPanelFieldFitxer == null) {
			jPanelFieldFitxer = new JPanel(new FlowLayout(FlowLayout.LEFT));
			jPanelFieldFitxer.add(getJLabelDocumentPrincipalPath(), null);
			jPanelFieldFitxer.add(getJButtonViewDocumentPrincipalFile(), null);
		}
		return jPanelFieldFitxer;
	}
	
	
	
	
	
	
	
	
	
	// NOM DEL DOCUMENT
	JPanel jPanelLabelNom = null;
	protected JPanel getJPanelLabelNom(){
		if (jPanelLabelNom == null){
			jPanelLabelNom = new JPanel(new FlowLayout(FlowLayout.RIGHT));
			jPanelLabelNom.setSize(new Dimension(150, 25));
			jPanelLabelNom.setAlignmentX(RIGHT_ALIGNMENT);
			jPanelLabelNom.add(new JLabel("Nom"));
		}
		return jPanelLabelNom;
	}
	
	JPanel jPanelFieldNom = null;
	protected JPanel getJPanelFieldNom(){
		if (jPanelFieldNom == null) {
			jPanelFieldNom = new JPanel(new FlowLayout(FlowLayout.LEFT));
			jPanelFieldNom.add(getJLabelDocumentPrincipalName(), null);
		}
		return jPanelFieldNom;
	}
	
	
	
	
	
	
	
	
	
	
	
	// DESCRIPCI� DEL DOCUMENT
	JPanel jPanelLabelDescripcio = null;
	protected JPanel getJPanelLabelDescripcio(){
		if (jPanelLabelDescripcio == null){
			jPanelLabelDescripcio = new JPanel(new FlowLayout(FlowLayout.RIGHT));
			jPanelLabelDescripcio.setSize(new Dimension(150, 25));
			jPanelLabelDescripcio.setAlignmentX(RIGHT_ALIGNMENT);
			jPanelLabelDescripcio.add(new JLabel("Descripci\u00F3"));
		}
		return jPanelLabelDescripcio;
	}
	
	JPanel jPanelFieldDescripcio = null;
	protected JPanel getJPanelFieldDescripcio(){
		if (jPanelFieldDescripcio == null) {
			jPanelFieldDescripcio = new JPanel(new FlowLayout(FlowLayout.LEFT));
			jPanelFieldDescripcio.add(getJTextAreaDocumentPrincipalMotiu(), null);
		}
		return jPanelFieldDescripcio;
	}
	
	

	
	
	
	
	
	
	
	
	protected JPanel getJPanelDadesTitular() {
		if (jPanelDadesTitular == null) {
			jPanelDadesTitular = new JPanel(new SpringLayout());
			jPanelDadesTitular.setBorder(BorderFactory.createTitledBorder(null, "Dades del titular (Opcional)", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Dialog", Font.BOLD, 12), new Color(51, 51, 51)));
						
			jPanelDadesTitular.add(getJPanelDadesTitularLeftNom());
			jPanelDadesTitular.add(getJPanelDadesTitularNom());
			
			jPanelDadesTitular.add(getJPanelDadesTitularLeftCognoms());
			jPanelDadesTitular.add(getJPanelDadesTitularCognoms());
			
			jPanelDadesTitular.add(getJPanelDadesTitularLeftNif());
			jPanelDadesTitular.add(getJPanelDadesTitularNif());
			
			jPanelDadesTitular.add(getJPanelDadesTitularLeftEmail());
			jPanelDadesTitular.add(getJPanelDadesTitularEmail());
			
			SpringUtilities.makeCompactGrid(jPanelDadesTitular,
                    4, 2, //rows, cols
                    6, 6,        //initX, initY
                    6, 6);       //xPad, yPad
		}
		return jPanelDadesTitular;
	}

	protected JLabel getJLabelDocumentPrincipalPath() {
		if (jLabelDocumentPrincipalPath == null) {
			jLabelDocumentPrincipalPath = new JLabel();
		}
		return jLabelDocumentPrincipalPath;
	}

	protected JButton getJButtonViewDocumentPrincipalFile() {
		if (jButtonViewDocumentPrincipalFile == null) {
			jButtonViewDocumentPrincipalFile = new JButton();
			jButtonViewDocumentPrincipalFile.setPreferredSize(new Dimension(41, 21));
			jButtonViewDocumentPrincipalFile.setIcon(new ImageIcon(getClass().getResource("/es/caib/ibkey/cliente/wizard/pdf.png")));
			jButtonViewDocumentPrincipalFile.setMnemonic(KeyEvent.VK_UNDEFINED);
			jButtonViewDocumentPrincipalFile.setToolTipText("Veure PDF");
			jButtonViewDocumentPrincipalFile.addMouseListener(new java.awt.event.MouseAdapter() {
				public void mouseClicked(java.awt.event.MouseEvent e) {

					try {
						Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + data.getFilePath());
					} catch (IOException e1) {
						JOptionPane.showMessageDialog(null, "No se pot obrir el PDF", "Error", JOptionPane.ERROR_MESSAGE);
					}

				}
			});
		}
		return jButtonViewDocumentPrincipalFile;
	}

	protected JPanel getJPanelBottom() {
		if (jPanelBottom == null) {
			jPanelBottom = new JPanel();
			jPanelBottom.setLayout(new BorderLayout());
			jPanelBottom.setPreferredSize(new Dimension(467, 60));
			jPanelBottom.add(getJPanelBottom2(), BorderLayout.CENTER);
			jPanelBottom.add(getJPanelBottom1(), BorderLayout.SOUTH);
		}
		return jPanelBottom;
	}

	protected JButton getJButtonEnrere() {
		if (jButtonEnrere == null) {
			jButtonEnrere = new JButton();
			jButtonEnrere.setText("< Tornar");
			jButtonEnrere.setActionCommand("enrere");
			jButtonEnrere.addActionListener(this);
		}
		return jButtonEnrere;
	}

	protected JButton getJButtonEndavant() {
		if (jButtonEndavant == null) {
			jButtonEndavant = new JButton();
			jButtonEndavant.setText("Iniciar Procediment >");
			jButtonEndavant.setActionCommand("endavant");
			jButtonEndavant.addActionListener(this);
		}
		return jButtonEndavant;
	}

	protected JFileChooser getChooser() {
		if (chooser == null) {
			FileFilter ff = new FileFilter() {
				public boolean accept(File f) {
					return f.isDirectory() || f.getName().toLowerCase().endsWith("pdf");
				}

				public String getDescription() {
					return "Fitxers PDF";
				}
			};
			chooser = new JFileChooser();
			chooser.setFileFilter(ff);
		}
		return chooser;
	}

	public void actionPerformed(java.awt.event.ActionEvent e) {
		if ("enrere".equals(e.getActionCommand())) {
			Container parent = this.getParent();
			try {
				parent.remove(this); //s'elimina a sí mateixa o es fa invisible
				IbkeyView x1=new CompulsaWorkflowView();
				x1.setController(getController()); 		//configures el controlador de la nova finestra per a que les accions passin primer per el WizardNavigationController
				x1.setData(getData());			//li passes el data
				((WizardNavigationController)getController()).setPluginPanel((JPanel)x1); 	//dius al controlador que ara controla la nova finestra
				parent.add((JPanel)x1);
				getController().execute(WizardNavigationController.RESIZE,null);
				 
			} catch (Exception e1) {
				parent.add(this);
				JOptionPane.showMessageDialog(null, e1.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
				Logger.getLogger(IbkeyView.class).error(e1.getMessage(), e1);
			}
		}else{
			Thread actionThread = new ActionPerformedThread(e, this);
			actionThread.start();
		}
	}

	/**
	 * Valida les dades
	 */
	protected boolean validateSubmitData() {
		String filePath = data.getFilePath();
		if (filePath == null || filePath.equals("")) {
			JOptionPane.showMessageDialog(null, "\u00C9s necessari sel.leccionar un document principal per a iniciar el procediment", "Error", JOptionPane.ERROR_MESSAGE);
			return false;
		}
		String fileDesc = data.getName();
		if (fileDesc == null || fileDesc.equals("")) {
			JOptionPane.showMessageDialog(null, "\u00C9s necessari introduir una descripci\u00F3 per al document principal per a poder iniciar el procediment", "Error", JOptionPane.ERROR_MESSAGE);
			return false;
		}
		return true;
	}

	/**
	 * Copia les dades del formulari al data
	 */
	public IbkeyData gatherData() {
		CompulsaWorkflowData cwd = (CompulsaWorkflowData) data;
		// Los 3 primeros no se capturan porque vienen de la pantalla anterior.
		// cwd.setFilePath(getJLabelDocumentPrincipalPath().getText());
		// cwd.setName(getJLabelDocumentPrincipalName().getText());
		// cwd.setDescription(getJTextAreaDocumentPrincipalMotiu().getText());
		
		cwd.setTitularNombre(getJTextFieldDadesTitularNom().getText());
		cwd.setTitularApellidos(getJTextFieldDadesTitularCognoms().getText());
		cwd.setTitularNif(getJTextFieldDadesTitularNif().getText());
		cwd.setTitularEmail(getJTextFieldDadesTitularEmail().getText());
		
		return cwd;
	}

	public void execute(String action) throws IbkeyControllerException {
		// se n'encarrega el mètode actionPerformed
	}

	public IbkeyActionController getController() {
		return controller;
	}

	public IbkeyData getData() {
		return data;
	}

	public IbkeyView getParentView() {
		return null;
	}

	private String composarNomFitxerModeLectura(String s) {
		int tamanyDestijat = 40;
		if (s == null)
			return "";
		else if (s.length() > tamanyDestijat) {
			StringBuffer sb1 = new StringBuffer(s);
			sb1.delete(s.length() / 2, s.length());
			StringBuffer sb2 = new StringBuffer(s);
			sb2.delete(0, s.length() / 2);

			int toDelete = tamanyDestijat - s.length() / 2 - 2;
			for (int i = 0; i < toDelete; i++)
				sb1.delete(sb1.length() - 1, sb1.length());
			for (int i = 0; i < toDelete; i++)
				sb2.delete(0, 1);

			return sb1.append("....").append(sb2).toString();
		} else
			return s;
	}

	/**
	 * Copia les dades del data al formulari i les valida
	 */
	public void scatterData() {
		getJLabelDocumentPrincipalPath().setText(composarNomFitxerModeLectura(data.getFilePath()));
		getJLabelDocumentPrincipalName().setText(data.getName());
		getJTextAreaDocumentPrincipalMotiu().setText(data.getDescription());
		getJTextFieldDadesTitularNom().setText(data.getTitularNombre());
		getJTextFieldDadesTitularCognoms().setText(data.getTitularApellidos());
		getJTextFieldDadesTitularNif().setText(data.getTitularNif());
		getJTextFieldDadesTitularEmail().setText(data.getTitularEmail());
		this.validate();
	}

	public void setController(IbkeyActionController controller) {
		this.controller = controller;
	}

	public void setData(IbkeyData data) {
		this.data = (CompulsaWorkflowData)data;
		scatterData();
		getJLabelDocumentPrincipalName().requestFocusInWindow();
	}

	public void setParentView(IbkeyView parent) {
		// res a fer
	}

	protected JProgressBar getJProgressBar() {
		if (jProgressBar == null) {
			jProgressBar = new JProgressBar();
			jProgressBar.setPreferredSize(new Dimension(200, 14));
			jProgressBar.setValue(-1);
			jProgressBar.setVisible(false);
			jProgressBar.setIndeterminate(false);
		}
		return jProgressBar;
	}

	protected JPanel getJPanelBottom1() {
		if (jPanelBottom1 == null) {
			jPanelBottom1 = new JPanel();
			jPanelBottom1.setLayout(new BorderLayout());
			jPanelBottom1.setVisible(true);
			jPanelBottom1.setPreferredSize(new Dimension(0, 20));
			jPanelBottom1.add(getJProgressBar(), BorderLayout.CENTER);
		}
		return jPanelBottom1;
	}

	private JPanel getJPanelBottom2() {
		if (jPanelBottom2 == null) {
			jPanelBottom2 = new JPanel();
			jPanelBottom2.setLayout(new FlowLayout());
			jPanelBottom2.setPreferredSize(new Dimension(252, 40));
			jPanelBottom2.add(getJButtonEnrere(), null);
			jPanelBottom2.add(getJButtonEndavant(), null);
		}
		return jPanelBottom2;
	}

	/**
	 * Executa la lógica principal de l'enviament
	 */
	class UploadAndInitWorkflowBusinessThread extends Thread {

		ActionListener actionListener = null;
		IbkeyActionController actionController = null;
		IbkeyData data = null;
		String action = null;

		UploadAndInitWorkflowBusinessThread(String action, IbkeyActionController actionController, IbkeyData data, ActionListener actionListener) {
			this.actionController = actionController;
			this.data = data;
			this.action = action;
			this.actionListener = actionListener;
		}

		public void run() {
			try {
				actionController.execute(action, data);
			} catch (Throwable e1) {
				setError(e1);
				Logger.getLogger(IbkeyView.class).error(e1.getMessage(), e1);
			}
		}
	}

	/**
	 * Crida al controlador
	 */
	class ControllerExecution extends Thread {

		IbkeyActionController controller = null;
		String command = null;

		ControllerExecution(IbkeyActionController controller, String command) {
			this.controller = controller;
			this.command = command;
		}

		public void run() {
			try {
				controller.execute(command, getData());
			} catch (Throwable e1) {
				JOptionPane.showMessageDialog(null, e1.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
				Logger.getLogger(IbkeyView.class).error(e1.getMessage(), e1);
			}
		}
	}

	/**
	 * Crida a la vista
	 */
	class ViewEndExecution extends Thread {

		ActionListener actionListener = null;

		ViewEndExecution(ActionListener actionListener) {
			this.actionListener = actionListener;
		}

		public void run() {
			actionListener.actionPerformed(new ActionEvent(this, -1, IbkeyActionController.UPLOAD_AND_INIT_TASK_END));
		}
	}

	class ProgressUpdateThread extends Thread {

		IbkeyActionController actionController = null;
		JProgressBar bar = null;

		ProgressUpdateThread(JProgressBar bar, IbkeyActionController actionController) {
			this.actionController = actionController;
			this.bar = bar;
		}

		public void run() {
			do {
				int progress = actionController.getProgress();
				if (progress > 0) {
					bar.setIndeterminate(false);
					bar.setValue(progress);
				} else {
					bar.setIndeterminate(true);
				}
				try {
					Object a = new String();
					synchronized (a) {
						a.wait(100);

					}
				} catch (InterruptedException e) {
				}
			} while ((actionController.getProgress() != -1 || actionController.getProgress() == 0) && actionController.getProgress() != 100);
		}
	}

	protected JPanel getJPanelDocName() {
		if (jPanelDocName == null) {
			jPanelDocName = new JPanel();
			jPanelDocName.setLayout(new FlowLayout());
			jPanelDocName.add(getJLabelDocumentPrincipalName(), null);
		}
		return jPanelDocName;
	}

	protected JPanel getJPanelDocPath() {
		if (jPanelDocPath == null) {
			jPanelDocPath = new JPanel();
			jPanelDocPath.setLayout(new FlowLayout());
			jPanelDocPath.add(getJLabelDocumentPrincipalPath(), null);
			jPanelDocPath.add(getJButtonViewDocumentPrincipalFile(), null);
		}
		return jPanelDocPath;
	}

	protected JPanel getJPanelDadesTitularEmail() {
		if (jPanelDadesTitularEmail == null) {
			jPanelDadesTitularEmail = new JPanel();
			jPanelDadesTitularEmail.setLayout(new FlowLayout(FlowLayout.LEFT));
			jPanelDadesTitularEmail.add(getJTextFieldDadesTitularEmail(), null);
		}
		return jPanelDadesTitularEmail;
	}

	protected JPanel getJPanelDadesTitularNom() {
		if (jPanelDadesTitularNom == null) {
			jPanelDadesTitularNom = new JPanel();
			jPanelDadesTitularNom.setLayout(new FlowLayout(FlowLayout.LEFT));
			jPanelDadesTitularNom.add(getJTextFieldDadesTitularNom(), null);
		}
		return jPanelDadesTitularNom;
	}

	protected JPanel getJPanelDadesTitularCognoms() {
		if (jPanelDadesTitularCognoms == null) {
			jPanelDadesTitularCognoms = new JPanel();
			jPanelDadesTitularCognoms.setLayout(new FlowLayout(FlowLayout.LEFT));
			jPanelDadesTitularCognoms.add(getJTextFieldDadesTitularCognoms(), null);
		}
		return jPanelDadesTitularCognoms;
	}

	protected JPanel getJPanelDadesTitularNif() {
		if (jPanelDadesTitularNif == null) {
			jPanelDadesTitularNif = new JPanel();
			jPanelDadesTitularNif.setLayout(new FlowLayout(FlowLayout.LEFT));
			jPanelDadesTitularNif.add(getJTextFieldDadesTitularNif(), null);
		}
		return jPanelDadesTitularNif;
	}

	protected JLabel getJLabelDocumentPrincipalName() {
		if (jLabelDocumentPrincipalName == null) {
			jLabelDocumentPrincipalName = new JLabel();
			jLabelDocumentPrincipalName.setPreferredSize(new Dimension(340, 25));
		}
		return jLabelDocumentPrincipalName;
	}

	protected JTextField getJTextFieldDadesTitularNom() {
		if (jTextFieldDadesTitularNom == null) {
			jTextFieldDadesTitularNom = new JTextField();
			jTextFieldDadesTitularNom.setPreferredSize(new Dimension(340, 25));
		}
		return jTextFieldDadesTitularNom;
	}

	protected JTextField getJTextFieldDadesTitularCognoms() {
		if (jTextFieldDadesTitularCognoms == null) {
			jTextFieldDadesTitularCognoms = new JTextField();
			jTextFieldDadesTitularCognoms.setPreferredSize(new Dimension(340, 25));
		}
		return jTextFieldDadesTitularCognoms;
	}

	protected JTextField getJTextFieldDadesTitularNif() {
		if (jTextFieldDadesTitularNif == null) {
			jTextFieldDadesTitularNif = new JTextField();
			jTextFieldDadesTitularNif.setPreferredSize(new Dimension(340, 25));
		}
		return jTextFieldDadesTitularNif;
	}

	protected JTextField getJTextFieldDadesTitularEmail() {
		if (jTextFieldDadesTitularEmail == null) {
			jTextFieldDadesTitularEmail = new JTextField();
			jTextFieldDadesTitularEmail.setPreferredSize(new Dimension(340, 25));
		}
		return jTextFieldDadesTitularEmail;
	}

	protected JPanel getJPanelDocPrincipalLeft() {
		if (jPanelDocPrincipalLeft == null) {
			jPanelDocPrincipalLeft = new JPanel();
			jPanelDocPrincipalLeft.setLayout(new BoxLayout(getJPanelDocPrincipalLeft(), BoxLayout.Y_AXIS));
			jPanelDocPrincipalLeft.add(getJPanelDocPrincipalLeftFitxer(), null);
			jPanelDocPrincipalLeft.add(getJPanelDocPrincipalLeftNom(), null);
			jPanelDocPrincipalLeft.add(getJPanelDocPrincipalLeftMotiu(), null);
		}
		return jPanelDocPrincipalLeft;
	}

	protected JPanel getJPanelDocPrincipalRight() {
		if (jPanelDocPrincipalRight == null) {
			jPanelDocPrincipalRight = new JPanel();
			jPanelDocPrincipalRight.setLayout(new BoxLayout(getJPanelDocPrincipalRight(), BoxLayout.Y_AXIS));
			jPanelDocPrincipalRight.add(getJPanelDocPath(), null);
			jPanelDocPrincipalRight.add(getJPanelDocName(), null);
			jPanelDocPrincipalRight.add(getJPanelDocMotiu(), null);
		}
		return jPanelDocPrincipalRight;
	}

	protected JPanel getJPanelDadesTitularLeft() {
		if (jPanelDadesTitularLeft == null) {
			jPanelDadesTitularLeft = new JPanel();
			jPanelDadesTitularLeft.setLayout(new BoxLayout(getJPanelDadesTitularLeft(), BoxLayout.Y_AXIS));
			jPanelDadesTitularLeft.add(getJPanelDadesTitularLeftNom(), null);
			jPanelDadesTitularLeft.add(getJPanelDadesTitularLeftCognoms(), null);
			jPanelDadesTitularLeft.add(getJPanelDadesTitularLeftNif(), null);
			jPanelDadesTitularLeft.add(getJPanelDadesTitularLeftEmail(), null);
		}
		return jPanelDadesTitularLeft;
	}

	protected JPanel getJPanelDadesTitularRight() {
		if (jPanelDadesTitularRight == null) {
			jPanelDadesTitularRight = new JPanel();
			jPanelDadesTitularRight.setLayout(new BoxLayout(getJPanelDadesTitularRight(), BoxLayout.Y_AXIS));
			jPanelDadesTitularRight.add(getJPanelDadesTitularNom(), null);
			jPanelDadesTitularRight.add(getJPanelDadesTitularCognoms(), null);
			jPanelDadesTitularRight.add(getJPanelDadesTitularNif(), null);
			jPanelDadesTitularRight.add(getJPanelDadesTitularEmail(), null);
		}
		return jPanelDadesTitularRight;
	}

	protected JPanel getJPanelDocPrincipalLeftNom() {
		if (jPanelDocPrincipalLeftNom == null) {
			jLabelDocPrincipalNom = new JLabel();
			jLabelDocPrincipalNom.setText("Nom");
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = -1;
			gridBagConstraints.gridy = -1;
			jPanelDocPrincipalLeftNom = new JPanel();
			jPanelDocPrincipalLeftNom.setLayout(new FlowLayout());
			jPanelDocPrincipalLeftNom.add(jLabelDocPrincipalNom, null);
		}
		return jPanelDocPrincipalLeftNom;
	}

	protected JPanel getJPanelDocPrincipalLeftFitxer() {
		if (jPanelDocPrincipalLeftFitxer == null) {
			jLabelDocPrincipalFitxer = new JLabel();
			jLabelDocPrincipalFitxer.setText("Fitxer");
			jPanelDocPrincipalLeftFitxer = new JPanel();
			jPanelDocPrincipalLeftFitxer.setLayout(new FlowLayout());
			jPanelDocPrincipalLeftFitxer.add(jLabelDocPrincipalFitxer, null);
		}
		return jPanelDocPrincipalLeftFitxer;
	}

	protected JPanel getJPanelDocPrincipalLeftMotiu() {
		if (jPanelDocPrincipalLeftMotiu == null) {
			jLabelDocPrincipalMotiu = new JLabel();
			jLabelDocPrincipalMotiu.setText("Descripci\u00f3");
			jPanelDocPrincipalLeftMotiu = new JPanel();
			jPanelDocPrincipalLeftMotiu.setLayout(new FlowLayout());
			jPanelDocPrincipalLeftMotiu.add(jLabelDocPrincipalMotiu, null);
		}
		return jPanelDocPrincipalLeftMotiu;
	}

	protected JPanel getJPanelDadesTitularLeftNom() {
		if (jPanelDadesTitularLeftNom == null) {
			jLabelDadesTitularNom = new JLabel();
			jLabelDadesTitularNom.setText("Nom");
			jPanelDadesTitularLeftNom = new JPanel(new FlowLayout(FlowLayout.RIGHT));
			jPanelDadesTitularLeftNom.setSize(new Dimension(150, 25));
			jPanelDadesTitularLeftNom.add(jLabelDadesTitularNom, null);
		}
		return jPanelDadesTitularLeftNom;
	}

	protected JPanel getJPanelDadesTitularLeftCognoms() {
		if (jPanelDadesTitularLeftCognoms == null) {
			jLabelDadesTitularCognoms = new JLabel();
			jLabelDadesTitularCognoms.setText("Cognoms");
			jPanelDadesTitularLeftCognoms = new JPanel(new FlowLayout(FlowLayout.RIGHT));
			jPanelDadesTitularLeftCognoms.setSize(new Dimension(150, 25));
			jPanelDadesTitularLeftCognoms.add(jLabelDadesTitularCognoms, null);
		}
		return jPanelDadesTitularLeftCognoms;
	}

	protected JPanel getJPanelDadesTitularLeftNif() {
		if (jPanelDadesTitularLeftNif == null) {
			jLabelDadesTitularNif = new JLabel();
			jLabelDadesTitularNif.setText("NIF");
			jPanelDadesTitularLeftNif = new JPanel(new FlowLayout(FlowLayout.RIGHT));
			jPanelDadesTitularLeftNif.setSize(new Dimension(150, 25));
			jPanelDadesTitularLeftNif.add(jLabelDadesTitularNif, null);
		}
		return jPanelDadesTitularLeftNif;
	}

	protected JPanel getJPanelDadesTitularLeftEmail() {
		if (jPanelDadesTitularLeftEmail == null) {
			jLabelDadesTitularEmail = new JLabel();
			jLabelDadesTitularEmail.setText("Email");
			jPanelDadesTitularLeftEmail = new JPanel(new FlowLayout(FlowLayout.RIGHT));
			jPanelDadesTitularLeftEmail.setSize(new Dimension(150, 25));
			jPanelDadesTitularLeftEmail.add(jLabelDadesTitularEmail, null);
		}
		return jPanelDadesTitularLeftEmail;
	}

	protected JPanel getJPanelDocMotiu() {
		if (jPanelDocMotiu == null) {
			jPanelDocMotiu = new JPanel();
			jPanelDocMotiu.setLayout(new FlowLayout());
			jPanelDocMotiu.add(getJTextAreaDocumentPrincipalMotiu(), null);
		}
		return jPanelDocMotiu;
	}

	protected JTextArea getJTextAreaDocumentPrincipalMotiu() {
		if (jTextAreaDocumentPrincipalMotiu == null) {
			jTextAreaDocumentPrincipalMotiu = new JTextArea();
			jTextAreaDocumentPrincipalMotiu.setPreferredSize(new Dimension(340, 50));
			jTextAreaDocumentPrincipalMotiu.setBorder(new LineBorder(Color.gray));
			jTextAreaDocumentPrincipalMotiu.setEnabled(false);
		}
		return jTextAreaDocumentPrincipalMotiu;
	}

	public synchronized Throwable getError() {
		return error;
	}

	public synchronized void setError(Throwable error) {
		this.error = error;
	}

	private class ActionPerformedThread extends Thread {

		ActionEvent e = null;
		CompulsaWorkflowSetInfoView container = null;

		public ActionPerformedThread(ActionEvent e, CompulsaWorkflowSetInfoView container) {
			this.container = container;
			this.e = e;
		}

		public void run() {

			if ("endavant".equals(e.getActionCommand()) || IbkeyActionController.UPLOAD_AND_INIT_TASK_BEGIN.equals(e.getActionCommand())) {

				// recuperem les dades
				gatherData();

				// validem el formulari
				if (!validateSubmitData()) {
					return;
				}

				getJProgressBar().setVisible(true);
				getJPanelCenter().setEnabled(false);
				getJPanelBottom1().setEnabled(false);

				getJButtonEndavant().setEnabled(false);
				getJButtonEnrere().setEnabled(false);

				// inici de la logica de negoci, controlant si es prova d'estres
				// o no.
				int times = 1;
				if (getData().getMode().indexOf(IbkeyData.STRESS_MODE) != -1) {
					// per defecte 100, es pot modificar modificant la propietat
					// de sistema stress.limit
					times = (System.getProperty("stress.times") != null) ? Integer.parseInt(System.getProperty("stress.limit")) : 100;
				}

				Thread business = null;
				Thread presentation = null;

				for (int p = 0; p < times; p++) {

					String a = new String();

					// iniciem l'enviament i inici de proces JBPM
					business = new CompulsaWorkflowSetInfoView.UploadAndInitWorkflowBusinessThread(IbkeyActionController.UPLOAD_AND_INIT_TASK_BEGIN, getController(), getData(), container);
					business.start();

					// iniciem el thread que controla la barra de progrés
					presentation = new ProgressUpdateThread(getJProgressBar(), getController());
					presentation.start();

					if (getData().getMode().indexOf(IbkeyData.STRESS_MODE) != -1) {
						synchronized (a) {
							try {
								a.wait(5000);
							} catch (InterruptedException ie) {
							}
						}
					}
				}

				// esperem a la finalitzacio dels threads per a avançar de
				// pantalla
				try {
					business.join();
				} catch (InterruptedException e1) {
					if (presentation.isAlive())
						try {
							presentation.join();
						} catch (InterruptedException e2) {
							Logger.getLogger(IbkeyView.class).error(e2.getMessage(), e2);
						}
				}

				// si hi ha hagut algun error en la execucio dels threads:
				if (getError() != null) {
					getData().setException(getError());
					JOptionPane.showMessageDialog(null, getError().getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
					Logger.getLogger(this.getClass()).error(getError().getMessage(),getError());
				}

				actionPerformed(new ActionEvent(this, -1, IbkeyActionController.UPLOAD_AND_INIT_TASK_END));

			} else if (IbkeyActionController.UPLOAD_AND_INIT_TASK_END.equals(e.getActionCommand())) {

				getJProgressBar().setVisible(false);
				getJPanelCenter().setEnabled(true);
				getJPanelBottom1().setEnabled(true);

				Container parent = getParent();
				try {
					parent.remove(container);
					getController().execute(IbkeyActionController.UPLOAD_AND_INIT_TASK_END, getData());
				} catch (IbkeyControllerException e1) {
					parent.add(container);
					JOptionPane.showMessageDialog(null, e1.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
					Logger.getLogger(IbkeyView.class).error(e1.getMessage(), e1);
				}
			}
		}
	}

}
