package es.caib.ibkey.cliente.PropertiesInitWorkflow;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import es.caib.ibkey.cliente.common.IbkeyActionController;
import es.caib.ibkey.cliente.common.IbkeyControllerException;
import es.caib.ibkey.cliente.uploadFileAndInitWorkflow.UploadFileAndInitWorkflowController;


public class PropertiesInitWorkflowController extends UploadFileAndInitWorkflowController implements IbkeyActionController {


	protected void configureAdditionalProcessVariables() throws IbkeyControllerException{
		super.configureAdditionalProcessVariables();
		
		PropertiesInitWorkflowData myData=(PropertiesInitWorkflowData)this.data;
		
		String propsFilePath=myData.getPropertiesFile();
		File propsFile=new File(propsFilePath);
		
		FileInputStream propsFileIS;
		
		try{
			propsFileIS=new FileInputStream(propsFile);
		}catch(FileNotFoundException e){
			throw new IbkeyControllerException("No s'ha trovat el fitxer de propietats: "+propsFilePath);
		}
		
		Properties properties=new Properties();
		try {
			properties.load(propsFileIS);
		} catch (IOException e) {
			throw new IbkeyControllerException(e.getMessage(),e);

		}
		
		try{
			propsFileIS.close();
		}catch(IOException ioe){};
				
		try{
			Iterator propsIt=properties.keySet().iterator();
			while(propsIt.hasNext()){
				String propName=(String)propsIt.next();
				String propValue=(String)properties.get(propName);
				
				engine.setIndexedProcessVariable(processId,propName,propValue);
			}
		}catch(Throwable th){
        	throw new IbkeyControllerException("Error al establir variables de procés: ",th);
        }
	}
	
}
