package es.caib.ibkey.cliente.SAPInitWorkflow;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.login.LoginException;
import javax.swing.JOptionPane;

import org.apache.log4j.Logger;

import es.caib.bpm.attachment.ProcessAttachmentManager;
import es.caib.bpm.beans.exception.DocumentBeanException;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.vo.ProcessInstance;
import es.caib.ibkey.bpm.common.ContentTypeRegistry;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.cliente.common.ClientLogin;
import es.caib.ibkey.cliente.common.IbkeyActionController;
import es.caib.ibkey.cliente.common.IbkeyControllerException;
import es.caib.ibkey.cliente.common.IbkeyData;
import es.caib.ibkey.cliente.common.IbkeyView;
import es.caib.ibkey.cliente.uploadFileAndInitWorkflow.UploadFileAndInitWorkflowController;
import es.caib.ibkey.cliente.uploadFileAndInitWorkflow.UploadFileAndInitWorkflowData;
import es.caib.ibkey.ejb.ejb.IndexedProcessService_V2;
import es.caib.ibkey.ejb.ejb.IndexedProcessService_V2Home;

public class SAPWorkflowController extends UploadFileAndInitWorkflowController {
	public static final String SAP_WORKFLOW_ARGUMENT = "-sapWF"; 

	
	protected void configureAdditionalProcessVariables() throws IbkeyControllerException {
		super.configureAdditionalProcessVariables();
		
		//processem arguments de SAP
		if(data.getExtraArguments().contains(SAP_WORKFLOW_ARGUMENT)){
			try{
				processSAPWorkflowArguments((String)data.getExtraArguments().get(data.getExtraArguments().indexOf(SAP_WORKFLOW_ARGUMENT)+1));
				if(data==null){
					JOptionPane.showMessageDialog(null,"Error en la propiedad: sap_clase", "Error" , JOptionPane.ERROR_MESSAGE);
					Logger.getLogger(IbkeyView.class).error("Error en la propiedad: sap_clase",new NullPointerException());
				}
			}catch (Throwable e1) {
				JOptionPane.showMessageDialog(null,e1.getMessage(), "Error" , JOptionPane.ERROR_MESSAGE);
				Logger.getLogger(IbkeyView.class).error(e1.getMessage(),e1);
				throw new IbkeyControllerException(e1);
			}
			
		}
		
       	//establim le variables de SAP al workflow JBPM
        try{
        	
        	Map params=((SAPWorkflowData)data).getSapAdditionalInfo();
        	Iterator it=params.keySet().iterator();
			while(it.hasNext()){
				String key=(String)it.next();
				engine.setIndexedProcessVariable(processId,key,params.get(key));
			}
        	
        	
        }catch(Throwable th){
        	throw new IbkeyControllerException("No s'ha pogut recuperar l'identificador de l'expedient a SAP",th);
        }
	}
	
	/**
	 * Procesa el fichero de propiedades que contiene la configuración de los workflows de SAP
	 * @param data
	 * @param filePath
	 * @return
	 * @throws Exception
	 */
	private void processSAPWorkflowArguments(String filePath) throws Exception{
		Properties prop = new Properties();
		prop.load(new FileInputStream(filePath));
		if(prop.containsKey("sap_clase")){				
							
			
			data.setSelectedActionIndex(prop.get("accion"));
			data.setFilePath((String)prop.get("documento"));
			data.setName((String)prop.get("descripcion"));
			
			Iterator it=prop.keySet().iterator();
			while(it.hasNext()){
				String key=(String)it.next();
				if(key.toLowerCase().contains("sap_")){
					String subkey=key.toLowerCase().substring(4).toUpperCase();
					((SAPWorkflowData)data).getSapAdditionalInfo().put(subkey, prop.get(key));
				}
			}
		}		
	}
}
