package es.caib.ibkey.cliente.common;

import java.util.LinkedList;
import java.util.Map;

import es.caib.bpm.vo.ProcessDefinition;

/**
 * Classe que implementa el model de dades bàsic
 * @author u91940
 *
 */

public class IbkeyData {

	public final static String INVISIBLE_MODE="invisible";

	public static final String STRESS_MODE = "stress";

	public static final String EXTERNAL_APPLICATION_MODE = "externalApplication";
	
	/** Codi d'usuari caib **/
	protected String user;
	
	/** Password **/
	protected String password;
	
	/** Mapeo de id y nombre de acciones disponibles **/
	protected Map accionesDisponibles;
	
	/** Mapeo de acciones con controladores de las acciones disponibles **/
	protected Map controladoresAcciones;
	
	protected Object selectedActionIndex;
	
	protected ProcessDefinition selectedProcessDefinition;	
	
	protected String mode="";

	protected Throwable exception=null;
	
	/** Argumentos extra para el plugin **/
	protected LinkedList extraArguments=new LinkedList();
	
	public IbkeyData(){
		
	}
	
	public IbkeyData(IbkeyData data){
		if(data!=null){
			setUser(data.getUser());
			setPassword(data.getPassword());
			setAccionesDisponibles(data.getAccionesDisponibles());
			setControladoresAcciones(data.getControladoresAcciones());
			setSelectedProcessDefinition(data.getSelectedProcessDefinition());
			setSelectedActionIndex(data.getSelectedActionIndex());
			setMode(data.getMode());
			setExtraArguments(data.getExtraArguments());
		}
	}
	
	/** Retorna el password
	 * @return password
	 **/
	public synchronized String getPassword() {
		return password;
	}

	/** Estableix el password **/
	public synchronized void setPassword(String password) {
		this.password = password;
	}

	/** Retorna el codi d'usuari
	 * @return user
	 **/
	public synchronized String getUser() {
		return user;
	}
	
	/** Estableix el codi d'usuari **/
	public synchronized void setUser(String user) {
		this.user = user;
	}

	/**
	 * Devuelve el mapeo de acciones disponibles
	 * @return accionesDisponibles
	 */
	public synchronized Map getAccionesDisponibles() {
		return accionesDisponibles;
	}

	/**
	 * Establece el mapeo de acciones disponibles
	 * @param accionesDisponibles
	 */
	public synchronized void setAccionesDisponibles(Map accionesDisponibles) {
		this.accionesDisponibles = accionesDisponibles;
	}

	/**
	 * Devuelve el mapeo de controladores de las acciones
	 * @return controladoresAcciones
	 */
	public synchronized Map getControladoresAcciones() {
		return controladoresAcciones;
	}

	/**
	 * Establece el mapeo de controladores de acciones
	 * @param controladoresAcciones
	 */
	public synchronized void setControladoresAcciones(Map controladoresAcciones) {
		this.controladoresAcciones = controladoresAcciones;
	}
	
	/**
	 * Recupera el ProcessDefinition del workflow seleccionado
	 * @return
	 */
	public synchronized ProcessDefinition getSelectedProcessDefinition() {
		return selectedProcessDefinition;
	}

	/**
	 * Establece el ProcessDefinition del workflow seleccionado
	 * @param selectedProcessDefinition
	 */
	public synchronized void setSelectedProcessDefinition(ProcessDefinition selectedProcessDefinition) {
		this.selectedProcessDefinition = selectedProcessDefinition;
	}

	/**
	 * @return the selectedAction
	 */
	public synchronized Object getSelectedActionIndex() {
		return selectedActionIndex;
	}

	/**
	 * @param selectedAction the selectedAction to set
	 */
	public synchronized void setSelectedActionIndex(Object selectedActionIndex) {
		this.selectedActionIndex = selectedActionIndex;
	}

	/**
	 * @return the mode
	 */
	public String getMode() {
		return mode;
	}

	/**
	 * @param mode the mode to set
	 */
	public void setMode(String mode) {
		this.mode = mode;
	}

	/**
	 * @return the exception
	 */
	public synchronized Throwable getException() {
		return exception;
	}

	/**
	 * @param exception the exception to set
	 */
	public synchronized void setException(Throwable exception) {
		this.exception = exception;
	}

	/**
	 * @return the extraArguments
	 */
	public synchronized LinkedList getExtraArguments() {
		return extraArguments;
	}

	/**
	 * @param extraArguments the extraArguments to set
	 */
	public synchronized void setExtraArguments(LinkedList extraArguments) {
		this.extraArguments = extraArguments;
	}
	
	
	
}
