package es.caib.ibkey.cliente.common;

import java.awt.Dimension;

/**
 * Classe de la que han d'implementar totes les vistes o plugins de l'aplicació.
 * @author u91940
 *
 */

public interface  IbkeyView {
	

	/**
	 * Quan es crida a l'acció RESIZE del controlador, aquest vé a buscar el tamany solicitat a aquestes funcions.
	 * @return
	 */
	public int getHeight();
	public int getWidth();
	/**
	 * Retorna el controlador associat a la vista
	 * @return el controlador
	 */
	public  IbkeyActionController getController();
	
	/**
	 * Estableix el controlador associat a la vista
	 * @param controller el controlador 
	 */
	public  void setController(IbkeyActionController controller);
	
	
	/**
	 * Retorna el model de dades
	 * @return el model de dades
	 */
	public  IbkeyData getData();
	
	/**
	 * Estableix el model de dades 
	 * @param data Les dades
	 */
	public  void setData(IbkeyData data);
	
	/**
	 * Omple el model de dades amb les dades de la vista
	 * @return El model de dades
	 */
	public IbkeyData gatherData();
	
	/**
	 * Omple la vista amb les dades del model
	 *
	 */
	public void scatterData();
	
	/**
	 * Crida al controlador per a executar una acció.
	 * @param action
	 */
	public void execute(String action) throws IbkeyControllerException ;

	/**
	 * Retorna la vista que conté a aquesta
	 * @return
	 */
	public  IbkeyView getParentView();

	/**
	 * Estableix la vista que conté a aquesta.
	 * Hauria de eliminar-la de l'antiga i afegirl-la a la nova.
	 * @param parent
	 */
	public  void setParentView(IbkeyView parent);
	
	/**
	 * Mètode que retorna les dimensions, per a poder redimensionar el frontal
	 * @return
	 */
	public Dimension getSize();
}
