package es.caib.ibkey.cliente.uploadFileAndInitWorkflow;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.login.LoginException;

import org.apache.log4j.Logger;

import es.caib.bpm.beans.exception.DocumentBeanException;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.exception.BPMException;
import es.caib.ibkey.bpm.common.ContentTypeRegistry;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.cliente.common.ClientLogin;
import es.caib.ibkey.cliente.common.IbkeyActionController;
import es.caib.ibkey.cliente.common.IbkeyControllerException;
import es.caib.ibkey.cliente.common.IbkeyData;
import es.caib.ibkey.ejb.ejb.IndexedProcessService_V2;
import es.caib.ibkey.ejb.ejb.IndexedProcessService_V2Home;


public class UploadFileAndInitWorkflowController implements IbkeyActionController {



	protected float progress=0.0f;

	protected long processId=-1;
	protected IndexedProcessService_V2 engine=null;
	protected Context IBkeyContext = null;
	protected IndexedProcessService_V2Home home=null;
	protected UploadFileAndInitWorkflowData data=null;
	protected ContentTypeRegistry mimeReg=null;
	
	public IbkeyData execute(String action, IbkeyData p_data) throws IbkeyControllerException {
		this.data=(UploadFileAndInitWorkflowData)p_data;
		
		if(UPLOAD_AND_INIT_TASK_BEGIN.equals(action)){
			setProgress(0.0f);
			
			
			//inicio de la lógica de negocio propia del controlador
			ClientLogin login=new ClientLogin(data.getUser(),data.getPassword());
			
			
			try {
				login.login();
				
			} catch (LoginException e) {
				Logger.getLogger(IbkeyActionController.class).error(e.getMessage(),e);			
				throw new IbkeyControllerException("Usuari o contrassenya incorrectes.",e);
			}
			
			try{	


	    	   //lookup the home object and create the bean object from the home object
			   IBkeyContext=new InitialContext(System.getProperties(	));
	    	   Object lookupObj = IBkeyContext.lookup(System.getProperty("es.caib.ibkey.ibkeyServer.indexProcessService_V2"));	
	    	   home = (IndexedProcessService_V2Home) PortableRemoteObject.narrow(lookupObj, IndexedProcessService_V2Home.class);
	    	   engine=home.create();

				
	    	   setProgress(0.1f);
				
	    	   //iniciamos el workflow, enviando los ficheros principal y anexos.
	    	   Map urls=enviarFicheroIniciarWorkflow(data);
	    	   ((UploadFileAndInitWorkflowData)data).setUrlsResultado(urls);
			
	    	   //si hay tareas pendientes, abre el navegador predefinido con la pantalla de tareas pendientes
	    	   abrirNavegadorConTareasPendientes();
				
			}catch (IbkeyControllerException ib){
				setProgress(1f);
				throw ib;
			} catch (Throwable e) {
				setProgress(1f);
				throw new IbkeyControllerException(e.getMessage(),e);
			}
				
			
		}
		
		return data;
	}

	/**
	 * Si un proceso tiene tareas pendientes, abrimos el navegador (windows, linux y mac) con la página de la tarea pendiente.
	 * @throws IbkeyControllerException
	 */
	protected void abrirNavegadorConTareasPendientes() throws IbkeyControllerException {
		try{

		   
		   //llistat de tasques pendents que tinc o puc agafar.
		   List pendingTasks=engine.getPendingTasks(processId);
		   
		   if(!pendingTasks.isEmpty()){
			   for(Iterator it=pendingTasks.iterator();it.hasNext();){
				   Long taskId=(Long)it.next();
				   //Obrim el visor d'URLS per defecte (si no és un navegador, no s'obrirà al navegador)
				   
					if(System.getProperty("os.name").toLowerCase().indexOf("windows")!=-1) //si es windows
						Runtime.getRuntime().exec(new String []{"cmd", "/C","start",System.getProperty("es.caib.ibkey.workflow.web")+taskId});
					else if(System.getProperty("os.name").toLowerCase().indexOf("linux")!=-1) //si es linux
						Runtime.getRuntime().exec(new String []{"gnome-open",System.getProperty("es.caib.ibkey.workflow.web")+taskId});
					else if(System.getProperty("os.name").toLowerCase().indexOf("mac os x")!=-1) //si es mac
						Runtime.getRuntime().exec(new String []{"open",System.getProperty("es.caib.ibkey.workflow.web")+taskId});		   
			   }
		   }
		} catch (Throwable e) {
			throw new IbkeyControllerException(e.getMessage(),e);
		}finally{
			try {
				if(engine!=null)engine.remove();
			} catch (Exception e) {
				
			}
		}
	}
	
	protected Map  enviarFicheroIniciarWorkflow(UploadFileAndInitWorkflowData data) throws IbkeyControllerException{
		
		//localitzem l'EJB amb els paràmetres definits al fitxer jndi.properties
       Context IBkeyContext=null;
       Map workflowReturnValues=null;
       
       
       try {
   	   
			setProgress(0.2f);
			
			processId=engine.newIndexedProcess(data.getSelectedProcessDefinition()).longValue();

	       //recuperem l'stageManager
	       //StageManager manager=(StageManager)process.getVariables().get(StageManager.CTX_VAR_NAME);
	       
	       //establim un nom per al document
	       //manager.setProcessName(data.getName());
	       engine.setIndexedProcessName(processId,data.getName());

	       //establim una descripció al document
	       //manager.setDescription(data.getDescription());
	       engine.setIndexedProcessDescription(processId,data.getDescription());	      
	       
	       	//primer pujem els attachments
			Iterator it=data.getAttachmentFilePaths().iterator();
			int i=0;
			for(i=0;i<data.getAttachmentFilePaths().size();i++){
				String filePath=(String)it.next();
				uploadWorkflowDocument(filePath,false,processId,getProgress(),60.0f);
			}
			
			//després pujem el document principal i marquem la tasca inicial com a completada
	       	uploadWorkflowDocument(data.getFilePath(),true,processId,getProgress(),80.0f);
	    	//actualitzem la barra de progrés
	       	setProgress(0.9f);
	       	
	       	configureAdditionalProcessVariables();
	       	
	       	//actualitzem les variables del procés
			//engine.update(process);
			
			//iniciem el flux
			workflowReturnValues=engine.startIndexedProcessById(processId);
	    	//actualitzem la barra de progrés
	       	setProgress(1.0f);

		} catch (Throwable e) {
			Logger.getLogger(IbkeyActionController.class).error(
					(e.getMessage()==null)?e.getCause().getMessage():e.getMessage()
							,e);
			throw new IbkeyControllerException(e.getMessage(),e);
		}

	       	
	       	return workflowReturnValues;

			
	}
	
	protected void configureAdditionalProcessVariables() throws IbkeyControllerException {
		
		
	}

	/**
	 * Obté el tipus mime del document, 
	 * puja un document, 
	 * l'associa a la tasca amb el tag "document" si és el document principal, sinó IdProcés+nomFitxer
	 * i actualitza el StageInfo de la tasca inicial si és document principal o el StageManager si és un attachment
	 * 
	 * @param filePath
	 * @param isPrincipalDocument
	 * @param attMgr
	 * @param stageManager
	 * @param process
	 * @param p_limit Límit del progrés per a l'enviament de documents
	 * @param p_initial Valor inicial de la barra de progrés
	 * @throws IOException
	 * @throws NamingException
	 * @throws CreateException
	 * @throws DocumentBeanException
	 * @throws InterruptedException
	 * @throws BPMException
	 */
	protected void uploadWorkflowDocument(String filePath,boolean isPrincipalDocument,long processId,float p_initial, float p_limit) 
	throws IOException, NamingException, CreateException, DocumentBeanException, InterruptedException, BPMException {
		String fileExtension=filePath.substring(filePath.lastIndexOf("."));
		String mime=getContentTypeRegistry().getContentTypeByExtension(fileExtension.toLowerCase());
		
		if(mime==null)mime="plain/text";
		
		//el tag del document
		String tag=processId+filePath.substring(filePath.lastIndexOf(File.separator)+1);
		
		//creem la representació del document
		Document doc=engine.createDocument(processId,mime,tag);
		
		//iniciem la fase d'upload
		doc.openUploadTransfer();
        
		
		
		//el tamany del fitxer a enviar
		File file=new File(filePath);
		long fileSize=file.length();
		
		BufferedInputStream in=null;
		try{
			in = new BufferedInputStream (new FileInputStream(file));
	        
			byte [] b = new byte [10240];
	        int read = in.read(b);
	        int blockCounter=0;
	        
	        while (read > 0)
	        {
	        	blockCounter++;
	        	
	        	doc.nextUploadPackage(b, read);
	            read = in.read(b);
	            setProgress(p_initial/100+(p_limit-p_initial)*((float)(blockCounter*10240)/Math.max(fileSize,(long)(blockCounter*10240)))/100);
	            
	        }
		}catch(IOException e){
			throw e;
		}catch(DocumentBeanException e){
			throw e;
		}finally{
	        //fi de la fase d'upload
	        if(doc!=null)doc.endUploadTransfer();
	        if(in!=null)in.close();
		}

       	if(isPrincipalDocument){
           	//associem el document al tag
       		//als workflows, el document principal sempre ha de tenir el tag "document"
            engine.addProcessAttachment(processId,"document", doc);

            //actualitzem la informació de l'Stage inicial
       		engine.setNextPendingStageContentType(processId,mime);
       		engine.setNextPendingStageStatus(processId,StageInfo.STATUS_DONE);
       		
       	}else{
           	//associem el document al tag
       		engine.addProcessAttachment(processId,tag, doc);

            //actualitzem la llista d'attachments de l'StageManager
            engine.addIndexedProcessAttachment(processId,tag);
       	}

		
	}
	public synchronized int getProgress() {		
		//si está bloqueado el proceso, es que está en progreso
		//int val=(getLock()!=null)?(int)(progress*100):-1;
		int val=(int)(progress*100);
		//System.out.println(val);
		return val;
	}
	public synchronized void setProgress(float prog) {		
		progress=prog;
	}
	
	public synchronized ContentTypeRegistry getContentTypeRegistry(){
		if(mimeReg==null){
			try {
				mimeReg=new ContentTypeRegistry();
			} catch (IOException e) {
				Logger.getLogger(IbkeyActionController.class).error(e.getMessage(),e);
				return null;
			}
		}
		return mimeReg;
	}
}
