package es.caib.ibkey.cliente.uploadFileAndInitWorkflow;

import java.util.Map;
import java.util.Vector;

import es.caib.ibkey.cliente.common.IbkeyData;

public class UploadFileAndInitWorkflowData extends IbkeyData {
	
	protected String filePath;
	
	protected String description;
	
	protected Vector attachmentFilePaths;
	
	protected Map urlsResultado;

	protected String name;



	public UploadFileAndInitWorkflowData(IbkeyData data){
		super(data);
		
		
		//self-clone
		if(data instanceof UploadFileAndInitWorkflowData){
			this.filePath=((UploadFileAndInitWorkflowData)data).getFilePath();
			this.description=((UploadFileAndInitWorkflowData)data).getDescription();
			this.attachmentFilePaths=((UploadFileAndInitWorkflowData)data).getAttachmentFilePaths();
			this.urlsResultado=((UploadFileAndInitWorkflowData)data).getUrlsResultado();
			this.name=((UploadFileAndInitWorkflowData)data).getName();
		}else{
			attachmentFilePaths = new Vector();
		}
	}

	public synchronized String getFilePath() {
		return filePath;
	}

	public synchronized void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	/**
	 * @return the urlsResultado
	 */
	public synchronized Map getUrlsResultado() {
		return urlsResultado;
	}

	/**
	 * @param urlsResultado the urlsResultado to set
	 */
	public synchronized void setUrlsResultado(Map urlsResultado) {
		this.urlsResultado = urlsResultado;
	}

	/**
	 * @return the attachmentFilePaths
	 */
	public synchronized Vector getAttachmentFilePaths() {
		return attachmentFilePaths;
	}

	/**
	 * @param attachmentFilePaths the attachmentFilePaths to set
	 */
	public synchronized void setAttachmentFilePaths(Vector attachmentFilePaths) {
		this.attachmentFilePaths = attachmentFilePaths;
	}

	/**
	 * @return the description
	 */
	public synchronized String getDescription() {
		return description;
	}

	/**
	 * @param description the description to set
	 */
	public synchronized void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the name
	 */
	public synchronized String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public synchronized void setName(String name) {
		this.name = name;
	}
	


}
