package es.caib.ibkey.cliente.uploadFileAndInitWorkflow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

import org.apache.log4j.Logger;

import es.caib.ibkey.bpm.document.stage.URLDescription;
import es.caib.ibkey.cliente.common.IbkeyActionController;
import es.caib.ibkey.cliente.common.IbkeyControllerException;
import es.caib.ibkey.cliente.common.IbkeyData;
import es.caib.ibkey.cliente.common.IbkeyView;


public class UploadFileAndInitWorkflowView extends JPanel implements ActionListener,IbkeyView {

	Throwable error=null;  //  @jve:decl-index=0:
	
	private abstract class MyMouseAdapter extends MouseAdapter{
		Object [] params;
		
		MyMouseAdapter(Object [] _params){
			this.params=_params;
			
		}
	}
	
	private static final long serialVersionUID = 1L;
	private JLabel jLabelText = null;
	private JScrollPane jScrollPaneCenter = null;
	private JPanel jPanelCenter = null;
	private JPanel jPanelDocumentPrincipal = null;
	JTextField jTextFieldDocumentPrincipalPath = null;
	private JButton jButtonOpenDocumentPrincipalFile = null;
	private JPanel jPanelDocumentsAddicionals = null;
	private Vector jTextFieldDocumentAddicionalPathVector = new Vector();  //  @jve:decl-index=0:
	private Vector jButtonOpenDocumentAddicionalFileVector = new Vector();  //  @jve:decl-index=0:
	private Vector jPanelAttachmentVector = new Vector();  //  @jve:decl-index=0:
	private JPanel jPanelOpciones = null;
	private JButton jButtonAddAttach = null;
	private JPanel jPanelBottom = null;
	private JButton jButtonEnrere = null;
	private JButton jButtonEndavant = null;
	private JProgressBar jProgressBar = null;
	
	private JFileChooser chooser;
	private IbkeyActionController controller;  //  @jve:decl-index=0:
	private IbkeyData data;  //  @jve:decl-index=0:
	private JPanel jPanelAttachmentList = null;
	private JPanel jPanelBottom1 = null;
	private JPanel jPanelBottom2 = null;
	private JPanel jPanelDocName = null;
	private JPanel jPanelDocPath = null;
	private JTextField jTextFieldDocumentPrincipalName = null;
	private JPanel jPanelDocPrincipalLeft = null;
	private JPanel jPanelDocPrincipalRight = null;
	private JPanel jPanelDocPrincipalLeftNom = null;
	private JPanel jPanelDocPrincipalLeftFitxer = null;
	private JLabel jLabelDocPrincipalNom = null;
	private JLabel jLabelDocPrincipalFitxer = null;
	private JPanel jPanelDocPrincipalLeftMotiu = null;
	private JLabel jLabelDocPrincipalMotiu = null;
	private JPanel jPanelDocMotiu = null;
	private JTextField jTextFieldDocumentPrincipalMotiu = null;
	
	/**
	 * This is the default constructor
	 */
	public UploadFileAndInitWorkflowView() {
		super();
		initialize();
		
	}
	
	/**public PujarDocumentsPanel(IbkeyActionController controller, IbkeyData data) {
		super();
		this.controller=controller;
		this.data=new UploadFileAndInitWorkflowData(data);
		initialize();
	}**/

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	protected void initialize() {
		jLabelText = new JLabel();
		jLabelText.setText("Sel.leccioni els documents necessaris per a iniciar el procediment:");
		jLabelText.setHorizontalTextPosition(SwingConstants.CENTER);
		jLabelText.setHorizontalAlignment(SwingConstants.CENTER);
		this.setSize(445, 319);
		this.setLayout(new BorderLayout());
		this.add(jLabelText, BorderLayout.NORTH);
		this.add(getJScrollPaneCenter(), BorderLayout.CENTER);
		this.add(getJPanelBottom(), BorderLayout.SOUTH);
	}

	/**
	 * This method initializes jScrollPaneCenter	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	protected JScrollPane getJScrollPaneCenter() {
		if (jScrollPaneCenter == null) {
			jScrollPaneCenter = new JScrollPane();
			jScrollPaneCenter.setBorder(null);
			jScrollPaneCenter.setViewportView(getJPanelCenter());
		}
		return jScrollPaneCenter;
	}

	/**
	 * This method initializes jPanelCenter	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected JPanel getJPanelCenter() {
		if (jPanelCenter == null) {
			jPanelCenter = new JPanel();
			jPanelCenter.setLayout(new BorderLayout());
			jPanelCenter.add(getJPanelDocumentPrincipal(), BorderLayout.NORTH);
			jPanelCenter.add(getJPanelDocumentsAddicionals(), BorderLayout.CENTER);
		}
		return jPanelCenter;
	}

	/**
	 * This method initializes jPanelDocumentPrincipal	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected JPanel getJPanelDocumentPrincipal() {
		if (jPanelDocumentPrincipal == null) {
			jPanelDocumentPrincipal = new JPanel();
			jPanelDocumentPrincipal.setLayout(new BoxLayout(getJPanelDocumentPrincipal(), BoxLayout.X_AXIS));
			jPanelDocumentPrincipal.setBorder(BorderFactory.createTitledBorder(null, "Document principal", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Dialog", Font.BOLD, 12), new Color(51, 51, 51)));
			jPanelDocumentPrincipal.add(getJPanelDocPrincipalLeft(), null);
			jPanelDocumentPrincipal.add(getJPanelDocPrincipalRight(), null);
		}
		return jPanelDocumentPrincipal;
	}

	/**
	 * This method initializes jTextFieldDocumentPrincipalPath	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	protected JTextField getJTextFieldDocumentPrincipalPath() {
		if (jTextFieldDocumentPrincipalPath == null) {
			jTextFieldDocumentPrincipalPath = new JTextField();
			jTextFieldDocumentPrincipalPath.setPreferredSize(new Dimension(300, 25));
		}
		return jTextFieldDocumentPrincipalPath;
	}

	/**
	 * This method initializes jButtonOpenDocumentPrincipalFile	
	 * 	
	 * @return javax.swing.JButton	
	 */
	protected JButton getJButtonOpenDocumentPrincipalFile() {
		if (jButtonOpenDocumentPrincipalFile == null) {
			jButtonOpenDocumentPrincipalFile = new JButton();
			jButtonOpenDocumentPrincipalFile.setPreferredSize(new Dimension(34, 25));
			jButtonOpenDocumentPrincipalFile.setIcon(new ImageIcon(getClass().getResource("/es/caib/ibkey/cliente/wizard/openfile.gif")));
			jButtonOpenDocumentPrincipalFile.setMnemonic(KeyEvent.VK_UNDEFINED);
			
			jButtonOpenDocumentPrincipalFile.addMouseListener(new java.awt.event.MouseAdapter() {
				public void mouseClicked(java.awt.event.MouseEvent e) {
			        int returnVal = getChooser().showOpenDialog(null);

			        if (returnVal == JFileChooser.APPROVE_OPTION) {
			            File file = getChooser().getSelectedFile();
			            jTextFieldDocumentPrincipalPath.setText(file.getAbsolutePath());
			            
			        }
				}
			});
		}
		return jButtonOpenDocumentPrincipalFile;
	}

	/**
	 * This method initializes jPanelDocumentsAddicionals	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected JPanel getJPanelDocumentsAddicionals() {
		if (jPanelDocumentsAddicionals == null) {
			jPanelDocumentsAddicionals = new JPanel();
			jPanelDocumentsAddicionals.setLayout(new BoxLayout(getJPanelDocumentsAddicionals(), BoxLayout.Y_AXIS));
			jPanelDocumentsAddicionals.setBorder(BorderFactory.createTitledBorder(null, "Documents addicionals", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Dialog", Font.BOLD, 12), new Color(51, 51, 51)));
			jPanelDocumentsAddicionals.setPreferredSize(new Dimension(310, 90));
			jPanelDocumentsAddicionals.add(getJPanelOpciones(), null);
			jPanelDocumentsAddicionals.add(getJPanelAttachmentList(), null);
			
			
		}
		return jPanelDocumentsAddicionals;
	}

	/**
	 * This method initializes jTextFieldDocumentAddicionalPath	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	protected JTextField getJTextFieldDocumentAddicionalPath(int index) {
		if (jTextFieldDocumentAddicionalPathVector.size() <= index) {
			JTextField jTextFieldDocumentAddicionalPath = new JTextField();
			jTextFieldDocumentAddicionalPath.setPreferredSize(new Dimension(300, 25));

			jTextFieldDocumentAddicionalPathVector.add(jTextFieldDocumentAddicionalPath);
		}
		return (JTextField)jTextFieldDocumentAddicionalPathVector.get(index);
	}

	/**
	 * This method initializes jButtonOpenDocumentAddicionalFile	
	 * 	
	 * @return javax.swing.JButton	
	 */
	protected JButton getJButtonOpenDocumentAddicionalFile(int index) {
		if (jButtonOpenDocumentAddicionalFileVector.size()<=index) {
			JButton jButtonOpenDocumentAddicionalFile = new JButton();
			jButtonOpenDocumentAddicionalFile.setPreferredSize(new Dimension(34, 25));
			jButtonOpenDocumentAddicionalFile.setIcon(new ImageIcon(getClass().getResource("/es/caib/ibkey/cliente/wizard/openfile.gif")));
			jButtonOpenDocumentAddicionalFile.setMnemonic(KeyEvent.VK_UNDEFINED);
			jButtonOpenDocumentAddicionalFile.addMouseListener(new MyMouseAdapter(new Object []{new Integer(index)}) {
				public void mouseClicked(java.awt.event.MouseEvent e) {
			        int returnVal = getChooser().showOpenDialog(null);
			        int index=((Integer)params[0]).intValue();
			
			        if (returnVal == JFileChooser.APPROVE_OPTION) {
			            File file = getChooser().getSelectedFile();
			            getJTextFieldDocumentAddicionalPath(index).setText(file.getAbsolutePath());
			        }
				}
			});
			
			jButtonOpenDocumentAddicionalFileVector.add(jButtonOpenDocumentAddicionalFile);
		}
		
		return (JButton)jButtonOpenDocumentAddicionalFileVector.get(index);
	}

	/**
	 * This method initializes jPanelAttachment	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected JPanel getJPanelAttachment(int index) {
		if (jPanelAttachmentVector.size()<=index) {
			JPanel jPanelAttachment = new JPanel();
			jPanelAttachment.setLayout(new FlowLayout());
			jPanelAttachment.add(getJTextFieldDocumentAddicionalPath(index), null);
			jPanelAttachment.add(getJButtonOpenDocumentAddicionalFile(index), null);
			jPanelAttachmentVector.add(jPanelAttachment);
		}
		return (JPanel)jPanelAttachmentVector.get(index);
	}

	/**
	 * This method initializes jPanelOpciones	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected  JPanel getJPanelOpciones() {
		if (jPanelOpciones == null) {
			jPanelOpciones = new JPanel();
			jPanelOpciones.setLayout(new FlowLayout());
			jPanelOpciones.setPreferredSize(new Dimension(300, 50));
			jPanelOpciones.add(getJButtonAddAttach(), null);
		}
		return jPanelOpciones;
	}

	/**
	 * This method initializes jButtonAddAttach	
	 * 	
	 * @return javax.swing.JButton	
	 */
	protected  JButton getJButtonAddAttach() {
		if (jButtonAddAttach == null) {
			jButtonAddAttach = new JButton();
			jButtonAddAttach.setPreferredSize(new Dimension(200, 25));
			jButtonAddAttach.setActionCommand("AFEGIR_ATTACHMENT");
			jButtonAddAttach.setText("Afegir un altre document");
			jButtonAddAttach.addActionListener(this);
		}
		return jButtonAddAttach;
	}

	/**
	 * This method initializes jPanelBottom	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected  JPanel getJPanelBottom() {
		if (jPanelBottom == null) {
			jPanelBottom = new JPanel();
			jPanelBottom.setLayout(new BorderLayout());
			jPanelBottom.setPreferredSize(new Dimension(467, 60));
			jPanelBottom.add(getJPanelBottom2(), BorderLayout.CENTER);
			jPanelBottom.add(getJPanelBottom1(), BorderLayout.SOUTH);
		}
		return jPanelBottom;
	}

	/**
	 * This method initializes jButtonEnrere	
	 * 	
	 * @return javax.swing.JButton	
	 */
	protected  JButton getJButtonEnrere() {
		if (jButtonEnrere == null) {
			jButtonEnrere = new JButton();
			jButtonEnrere.setText("< Tornar");
			jButtonEnrere.setActionCommand("enrere");
			jButtonEnrere.addActionListener(this);
		}
		return jButtonEnrere;
	}

	/**
	 * This method initializes jButtonEndavant	
	 * 	
	 * @return javax.swing.JButton	
	 */
	protected  JButton getJButtonEndavant() {
		if (jButtonEndavant == null) {
			jButtonEndavant = new JButton();
			jButtonEndavant.setText("Iniciar Procediment >");
			jButtonEndavant.setActionCommand("endavant");
			jButtonEndavant.addActionListener(this);
		}
		return jButtonEndavant;
	}
	
	protected  JFileChooser getChooser() {
		 if(chooser==null){
			 FileFilter ff=new FileFilter(){
				 public boolean accept(File f) {
					 return true;
				}

				 public String getDescription() {
					
					return "Tots els fitxers"; 
				}
			 };
			 
			 chooser= new JFileChooser();
			 chooser.setFileFilter(ff);
		 }
		return chooser;
	}
	


	public void actionPerformed(java.awt.event.ActionEvent e) {
		Thread actionThread=new ActionPerformedThread(e,this);
		actionThread.start();
		
	}

	protected boolean validateSubmitData() {
		String filePath=((UploadFileAndInitWorkflowData)data).getFilePath();
		if(filePath==null || filePath.equals("")){
			JOptionPane.showMessageDialog(null,"\u00C9s necessari sel.leccionar un document principal per a iniciar el procediment", "Error" , JOptionPane.ERROR_MESSAGE);
			return false;
		}
		String fileDesc=((UploadFileAndInitWorkflowData)data).getName();
		if(fileDesc==null || fileDesc.equals("")){
			JOptionPane.showMessageDialog(null,"\u00C9s necessari introduir una descripci\u00F3 per al document principal per a poder iniciar el procediment", "Error" , JOptionPane.ERROR_MESSAGE);
			return false;
		}
		return true;
	}

	public IbkeyData gatherData() {
		((UploadFileAndInitWorkflowData)data).setFilePath(getJTextFieldDocumentPrincipalPath().getText());
		((UploadFileAndInitWorkflowData)data).setName(getJTextFieldDocumentPrincipalName().getText());
		((UploadFileAndInitWorkflowData)data).setDescription(getJTextFieldDocumentPrincipalMotiu().getText());

		Vector attVector=new Vector();
		
		
		for(int i=0;i<jTextFieldDocumentAddicionalPathVector.size();i++){
			String attPath=getJTextFieldDocumentAddicionalPath(i).getText();
			if(!"".equals(attPath))
				attVector.add(attPath);
		}
		
		((UploadFileAndInitWorkflowData)data).setAttachmentFilePaths(attVector);
		
		return data;
	}

	/**
	 * This method initializes jPanelAttachmentList	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected JPanel getJPanelAttachmentList() {
		if (jPanelAttachmentList == null) {
			jPanelAttachmentList = new JPanel();
			jPanelAttachmentList.setLayout(new BoxLayout(getJPanelAttachmentList(), BoxLayout.Y_AXIS));
		}
		return jPanelAttachmentList;
	}

	public void execute(String action) throws IbkeyControllerException {
		//se n'encarrega el mètode actionPerformed
	}


	public IbkeyActionController getController() {
		
		return controller;
	}

	public IbkeyData getData() {
		return data;
	}

	public IbkeyView getParentView() {
		return null;
	}

	public void scatterData() {
		getJTextFieldDocumentPrincipalPath().setText(((UploadFileAndInitWorkflowData)data).getFilePath());
		getJTextFieldDocumentPrincipalName().setText(((UploadFileAndInitWorkflowData)data).getName());
		getJTextFieldDocumentPrincipalMotiu().setText(((UploadFileAndInitWorkflowData)data).getDescription());
		
		for(int i=0;i<((UploadFileAndInitWorkflowData)data).getAttachmentFilePaths().size();i++){
			getJPanelAttachment(i).add(getJTextFieldDocumentAddicionalPath(i), null);	
			getJTextFieldDocumentAddicionalPath(i).setText((String)((UploadFileAndInitWorkflowData)data).getAttachmentFilePaths().get(i));
			getJPanelAttachmentList().add(getJPanelAttachment(i));
		}
		this.validate();
	}

	public void setController(IbkeyActionController controller) {
		this.controller=controller;
	}

	public void setData(IbkeyData data) {
		this.data=data;		
		if(data.getMode().indexOf(IbkeyData.INVISIBLE_MODE)!=-1){
			jLabelText.setVisible(false);
			getJScrollPaneCenter().setVisible(false);
			getJPanelBottom2().setVisible(false);
		}
		scatterData();
		getJTextFieldDocumentPrincipalName().requestFocusInWindow();
	}

	public void setParentView(IbkeyView parent) {
		//res a fers
	}

	/**
	 * This method initializes jProgressBar	
	 * 	
	 * @return javax.swing.JProgressBar	
	 */
	protected  JProgressBar getJProgressBar() {
		if (jProgressBar == null) {
			jProgressBar = new JProgressBar();
			jProgressBar.setPreferredSize(new Dimension(200, 14));
			jProgressBar.setValue(-1);
			jProgressBar.setVisible(false);
			jProgressBar.setIndeterminate(false);
		}
		return jProgressBar;
	}

	/**
	 * This method initializes jPanelBottom1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected  JPanel getJPanelBottom1() {
		if (jPanelBottom1 == null) {
			jPanelBottom1 = new JPanel();
			jPanelBottom1.setLayout(new BorderLayout());
			jPanelBottom1.setVisible(true);
			jPanelBottom1.setPreferredSize(new Dimension(0, 20));
			jPanelBottom1.add(getJProgressBar(), BorderLayout.CENTER);
		}
		return jPanelBottom1;
	}

	/**
	 * This method initializes jPanelBottom2	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelBottom2() {
		if (jPanelBottom2 == null) {
			jPanelBottom2 = new JPanel();
			jPanelBottom2.setLayout(new FlowLayout());
			jPanelBottom2.setPreferredSize(new Dimension(252, 40));
			jPanelBottom2.add(getJButtonEnrere(), null);
			jPanelBottom2.add(getJButtonEndavant(), null);
		}
		return jPanelBottom2;
	}

	/**
	 * Executa la lógica principal de l'enviament
	 * @author u91940
	 *
	 */
	class UploadAndInitWorkflowBusinessThread extends Thread{
		ActionListener actionListener=null;
		IbkeyActionController actionController=null;
		IbkeyData data=null;
		String action=null;

		
		
		UploadAndInitWorkflowBusinessThread(String action,IbkeyActionController actionController,IbkeyData data,ActionListener actionListener){
			this.actionController=actionController;
			this.data=data;
			this.action=action;
			this.actionListener=actionListener;
		}
		
		public void run() {

				try {
					actionController.execute(action, data);
					System.out.println("Coordenadas del documento:");
					
					Map urls=((UploadFileAndInitWorkflowData)data).getUrlsResultado();
					Iterator it=urls.keySet().iterator();
					while(it.hasNext()){
						String key=(String)it.next();
						URLDescription desc=((URLDescription)urls.get(key));
						System.out.println(desc.getDescription()+" : "+desc.getURL());
					}

				
				}catch (Throwable e1) {
					
					setError(e1);
					Logger.getLogger(IbkeyView.class).error(e1.getMessage(),e1);
				}

				

		}
	}


	/**
	 * Crida al controlador
	 * @author u91940
	 *
	 */
	class ControllerExecution extends Thread{		
		IbkeyActionController controller=null;
		String command=null;
		
		ControllerExecution(IbkeyActionController controller,String command){
			this.controller=controller;
			this.command=command;
		}
		
		public void run() {
			try{
				controller.execute(command,getData());
			}catch (Throwable e1) {
				JOptionPane.showMessageDialog(null,e1.getMessage(), "Error" , JOptionPane.ERROR_MESSAGE);
				Logger.getLogger(IbkeyView.class).error(e1.getMessage(),e1);
			}
		}		

	}

	
	/**
	 * Crida a la vista
	 * @author u91940
	 *
	 */
	class ViewEndExecution extends Thread{		
		ActionListener actionListener=null;
		
		ViewEndExecution(ActionListener actionListener){
			this.actionListener=actionListener;
		}
		
		public void run() {
			actionListener.actionPerformed(new ActionEvent(this,-1,IbkeyActionController.UPLOAD_AND_INIT_TASK_END));		
		}		

	}
	
	class ProgressUpdateThread extends Thread{
		IbkeyActionController actionController=null;
		JProgressBar bar=null;
		
		ProgressUpdateThread(JProgressBar bar,IbkeyActionController actionController){
			this.actionController=actionController;
			this.bar=bar;
		}
		
		public void run() {
			do{
				int progress=actionController.getProgress();
					if(progress>0){
						bar.setIndeterminate(false);
						bar.setValue(progress);
					}else{
						bar.setIndeterminate(true);
					}
				try {
					Object a=new String();
					synchronized(a){
						a.wait(100);
					
					}
				} catch (InterruptedException e) {
				}
			}while((actionController.getProgress()!=-1 || actionController.getProgress()==0) && actionController.getProgress()!=100);
		}	

	}

	/**
	 * This method initializes jPanelDocName	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected JPanel getJPanelDocName() {
		if (jPanelDocName == null) {
			jPanelDocName = new JPanel();
			jPanelDocName.setLayout(new FlowLayout());
			jPanelDocName.add(getJTextFieldDocumentPrincipalName(), null);
		}
		return jPanelDocName;
	}

	/**
	 * This method initializes jPanelDocPath	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected JPanel getJPanelDocPath() {
		if (jPanelDocPath == null) {
			jPanelDocPath = new JPanel();
			jPanelDocPath.setLayout(new FlowLayout());
			jPanelDocPath.add(getJTextFieldDocumentPrincipalPath(), null);
			jPanelDocPath.add(getJButtonOpenDocumentPrincipalFile(), null);
		}
		return jPanelDocPath;
	}

	/**
	 * This method initializes jTextFieldDocumentPrincipalName	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	protected JTextField getJTextFieldDocumentPrincipalName() {
		if (jTextFieldDocumentPrincipalName == null) {
			jTextFieldDocumentPrincipalName = new JTextField();
			jTextFieldDocumentPrincipalName.setPreferredSize(new Dimension(340, 25));
		}
		return jTextFieldDocumentPrincipalName;
	}

	/**
	 * This method initializes jPanelDocPrincipalLeft	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected JPanel getJPanelDocPrincipalLeft() {
		if (jPanelDocPrincipalLeft == null) {
			jPanelDocPrincipalLeft = new JPanel();
			jPanelDocPrincipalLeft.setLayout(new BoxLayout(getJPanelDocPrincipalLeft(), BoxLayout.Y_AXIS));
			jPanelDocPrincipalLeft.add(getJPanelDocPrincipalLeftNom(), null);
			jPanelDocPrincipalLeft.add(getJPanelDocPrincipalLeftMotiu(), null);
			jPanelDocPrincipalLeft.add(getJPanelDocPrincipalLeftFitxer(), null);
		}
		return jPanelDocPrincipalLeft;
	}

	/**
	 * This method initializes jPanelDocPrincipalRight	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected JPanel getJPanelDocPrincipalRight() {
		if (jPanelDocPrincipalRight == null) {
			jPanelDocPrincipalRight = new JPanel();
			jPanelDocPrincipalRight.setLayout(new BoxLayout(getJPanelDocPrincipalRight(), BoxLayout.Y_AXIS));
			jPanelDocPrincipalRight.add(getJPanelDocName(), null);
			jPanelDocPrincipalRight.add(getJPanelDocMotiu(), null);
			jPanelDocPrincipalRight.add(getJPanelDocPath(), null);
		}
		return jPanelDocPrincipalRight;
	}

	/**
	 * This method initializes jPanelDocPrincipalLeftNom	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected JPanel getJPanelDocPrincipalLeftNom() {
		if (jPanelDocPrincipalLeftNom == null) {
			jLabelDocPrincipalNom = new JLabel();
			jLabelDocPrincipalNom.setText("Nom");
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = -1;
			gridBagConstraints.gridy = -1;
			jPanelDocPrincipalLeftNom = new JPanel();
			jPanelDocPrincipalLeftNom.setLayout(new FlowLayout());
			jPanelDocPrincipalLeftNom.add(jLabelDocPrincipalNom, null);
		}
		return jPanelDocPrincipalLeftNom;
	}

	/**
	 * This method initializes jPanelDocPrincipalLeftFitxer	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected JPanel getJPanelDocPrincipalLeftFitxer() {
		if (jPanelDocPrincipalLeftFitxer == null) {
			jLabelDocPrincipalFitxer = new JLabel();
			jLabelDocPrincipalFitxer.setText("Fitxer");
			jPanelDocPrincipalLeftFitxer = new JPanel();
			jPanelDocPrincipalLeftFitxer.setLayout(new FlowLayout());
			jPanelDocPrincipalLeftFitxer.add(jLabelDocPrincipalFitxer, null);
		}
		return jPanelDocPrincipalLeftFitxer;
	}

	/**
	 * This method initializes jPanelDocPrincipalLeftMotiu	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected JPanel getJPanelDocPrincipalLeftMotiu() {
		if (jPanelDocPrincipalLeftMotiu == null) {
			jLabelDocPrincipalMotiu = new JLabel();
			jLabelDocPrincipalMotiu.setText("Descripci\u00f3");
			jPanelDocPrincipalLeftMotiu = new JPanel();
			jPanelDocPrincipalLeftMotiu.setLayout(new FlowLayout());
			jPanelDocPrincipalLeftMotiu.add(jLabelDocPrincipalMotiu, null);
		}
		return jPanelDocPrincipalLeftMotiu;
	}

	/**
	 * This method initializes jPanelDocMotiu	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	protected JPanel getJPanelDocMotiu() {
		if (jPanelDocMotiu == null) {
			jPanelDocMotiu = new JPanel();
			jPanelDocMotiu.setLayout(new FlowLayout());
			jPanelDocMotiu.add(getJTextFieldDocumentPrincipalMotiu(), null);
		}
		return jPanelDocMotiu;
	}

	/**
	 * This method initializes jTextFieldDocumentPrincipalMotiu	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	protected JTextField getJTextFieldDocumentPrincipalMotiu() {
		if (jTextFieldDocumentPrincipalMotiu == null) {
			jTextFieldDocumentPrincipalMotiu = new JTextField();
			jTextFieldDocumentPrincipalMotiu.setPreferredSize(new Dimension(340, 25));
		}
		return jTextFieldDocumentPrincipalMotiu;
	}

	/**
	 * @return the error
	 */
	public synchronized Throwable getError() {
		return error;
	}

	/**
	 * @param error the error to set
	 */
	public synchronized void setError(Throwable error) {
		this.error = error;
	}

	private class ActionPerformedThread extends Thread{
		ActionEvent e=null;
		UploadFileAndInitWorkflowView container=null;
		
		public ActionPerformedThread(ActionEvent e,UploadFileAndInitWorkflowView container) {
			this.container=container;
			this.e=e;
		}
		
		
		public void run() {

			if("AFEGIR_ATTACHMENT".equals(e.getActionCommand())){
				getJPanelAttachmentList().add(getJPanelAttachment(getjPanelAttachmentVector().size()),null);
				validate();
			}else if("endavant".equals(e.getActionCommand()) || IbkeyActionController.UPLOAD_AND_INIT_TASK_BEGIN.equals(e.getActionCommand())){
				//recuperem les dades
				gatherData();
				//validem el formulari
				if(!validateSubmitData()) return;
				
				getJProgressBar().setVisible(true);
				getJPanelCenter().setEnabled(false);
				getJPanelBottom1().setEnabled(false);
				
				getJButtonEndavant().setEnabled(false);
				getJButtonEnrere().setEnabled(false);

				
				//inici de la lógica de negoci, controlant si es prova d'estrés o no.
				int times=1;
				if(getData().getMode().indexOf(IbkeyData.STRESS_MODE)!=-1){
					//per defecte 100, es pot modificar modificant la propietat de sistema stress.limit
					times=(System.getProperty("stress.times")!=null)?Integer.parseInt(System.getProperty("stress.limit")):1;
				}
				
				
				Thread business=null;
				Thread presentation=null;
				
				for(int p=0;p<times;p++){
					String a=new String();
					//iniciem l'enviament i inici de proces JBPM
					business=new UploadFileAndInitWorkflowView.UploadAndInitWorkflowBusinessThread(IbkeyActionController.UPLOAD_AND_INIT_TASK_BEGIN,getController(),getData(),container);
					business.start();
					
					//iniciem el thread que controla la barra de progrés
					presentation=new ProgressUpdateThread(getJProgressBar(),getController());
					presentation.start();
					
					if(getData().getMode().indexOf(IbkeyData.STRESS_MODE)!=-1){
						synchronized(a){
							try {
								a.wait(5000);
							} catch (InterruptedException ie) {
							}
						}
					}
				}
				
				//esperem a la finalitzacio dels threads per a avançar de pantalla
				try {
					business.join(); 
				} catch (InterruptedException e1) {
					if(presentation.isAlive())
						try {
							presentation.join();
						} catch (InterruptedException e2) {
							Logger.getLogger(IbkeyView.class).error(e2.getMessage(),e2);
						}
				}
				
				//si hi ha hagut algun error en la execucio dels threads:
				if(getError()!=null){
					//passem la excepció
					getData().setException(getError());
					
					//mostrem la excepció per pantalla
					JOptionPane.showMessageDialog(null,getError().getMessage(), "Error" , JOptionPane.ERROR_MESSAGE);
					getError().printStackTrace();
				}
				
				actionPerformed(new ActionEvent(this,-1,IbkeyActionController.UPLOAD_AND_INIT_TASK_END));
							
			}else if("enrere".equals(e.getActionCommand())){
				Container parent=getParent();
				try {
					parent.remove(container);
					//reset de la acció. Aixi tornara a escollir acció
					getData().setSelectedActionIndex(null);
					getController().execute(IbkeyActionController.LOGIN_COMMAND, getData());
				} catch (IbkeyControllerException e1) {
					parent.add(container);
					JOptionPane.showMessageDialog(null,e1.getMessage(), "Error" , JOptionPane.ERROR_MESSAGE);
					Logger.getLogger(IbkeyView.class).error(e1.getMessage(),e1);
				}
			}else if(IbkeyActionController.UPLOAD_AND_INIT_TASK_END.equals(e.getActionCommand())){
				
				getJProgressBar().setVisible(false);
				getJPanelCenter().setEnabled(true);
				getJPanelBottom1().setEnabled(true);
				
				Container parent=getParent();
				try {
					parent.remove(container);				
					getController().execute(IbkeyActionController.UPLOAD_AND_INIT_TASK_END, getData());
				} catch (IbkeyControllerException e1) {
					parent.add(container);
					JOptionPane.showMessageDialog(null,e1.getMessage(), "Error" , JOptionPane.ERROR_MESSAGE);
					Logger.getLogger(IbkeyView.class).error(e1.getMessage(),e1);
					
				}
				
				
			}

		}
	}

	/**
	 * @return the jPanelAttachmentVector
	 */
	protected synchronized Vector getjPanelAttachmentVector() {
		return jPanelAttachmentVector;
	}

	/**
	 * @param jPanelAttachmentVector the jPanelAttachmentVector to set
	 */
	protected synchronized void setjPanelAttachmentVector(Vector jPanelAttachmentVector) {
		this.jPanelAttachmentVector = jPanelAttachmentVector;
	}
	
	
	
	
}  //  @jve:decl-index=0:visual-constraint="10,10"
