package es.caib.ibkey.cliente.wizard;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import org.apache.log4j.Logger;

import es.caib.bpm.vo.ProcessDefinition;
import es.caib.ibkey.cliente.common.IbkeyActionController;
import es.caib.ibkey.cliente.common.IbkeyControllerException;
import es.caib.ibkey.cliente.common.IbkeyData;
import es.caib.ibkey.cliente.common.IbkeyView;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;

public class LlistatProcedimentsPanel extends JPanel implements ActionListener {

	private static final long serialVersionUID = 1L;
	private static final String SEGUENT = "seguent";
	private static final String ATRAS = "atras";
	private JLabel jLabelText = null;
	private JPanel jPanelCenter = null;
	private JComboBox jComboBoxProcediments = null;
	private JPanel jPanelSouth = null;
	private JButton jButtonActualizar = null;
	private JButton jButtonAtras = null;

	private IbkeyActionController controller=null;
	private IbkeyData data=null;
	private JPanel jPanelCenter_Top = null;
	private JPanel jPanelCenter_top_left = null;
	private JPanel jPanelCenter_top_right = null; 
	/**
	 * This is the default constructor
	 */
	public LlistatProcedimentsPanel(IbkeyActionController controller, IbkeyData data) {
		super();
		this.controller=controller;
		this.data=data;
		initialize();
		initializeData();
	}

	private void initializeData() {
		//rellenamos el combo i actualizamos el cache de controladores asociados en caso que no haya habido error anteriormente

		
		 if(data.getAccionesDisponibles()!=null){
			Set set=new TreeSet(data.getAccionesDisponibles().keySet());
			Iterator kit=set.iterator();
			while(kit.hasNext()){
				String key=(String)kit.next();
				getJComboBoxProcediments().addItem(key);
			}
		}
		
		
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		jLabelText = new JLabel();
		jLabelText.setText("Sel.leccioni el procediment que desitji iniciar:");
		jLabelText.setHorizontalTextPosition(SwingConstants.CENTER);
		jLabelText.setHorizontalAlignment(SwingConstants.CENTER);
		this.setSize(397, 200);
		this.setLayout(new BorderLayout());
		this.add(jLabelText, BorderLayout.NORTH);
		this.add(getJPanelCenter(), BorderLayout.CENTER);
		this.add(getJPanelSouth(), BorderLayout.SOUTH);
	}

	/**
	 * This method initializes jPanelCenter	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelCenter() {
		if (jPanelCenter == null) {
			jPanelCenter = new JPanel();
			jPanelCenter.setLayout(new BorderLayout());
			jPanelCenter.add(getJPanelCenter_Top(), BorderLayout.NORTH);
		}
		return jPanelCenter;
	}

	/**
	 * This method initializes jComboBoxProcediments	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBoxProcediments() {
		if (jComboBoxProcediments == null) {
			jComboBoxProcediments = new JComboBox();
			jComboBoxProcediments.setPreferredSize(new Dimension(200, 25));
		}
		return jComboBoxProcediments;
	}

	/**
	 * This method initializes jPanelSouth	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelSouth() {
		if (jPanelSouth == null) {
			jPanelSouth = new JPanel();
			jPanelSouth.setLayout(new FlowLayout());
			jPanelSouth.add(getJButtonAtras(), null);
			jPanelSouth.add(getJButtonActualizar(), null);
		}
		return jPanelSouth;
	}

	/**
	 * This method initializes jButtonActualizar	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonActualizar() {
		if (jButtonActualizar == null) {
			jButtonActualizar = new JButton();
			jButtonActualizar.setPreferredSize(new Dimension(150, 25));
			jButtonActualizar.setSelected(true);
			jButtonActualizar.setText("Seg\u00FCent >");
			jButtonActualizar.setActionCommand(SEGUENT);
			jButtonActualizar.addActionListener(this);
		}
		return jButtonActualizar;
	}

	/**
	 * This method initializes jButtonAtras	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonAtras() {
		if (jButtonAtras == null) {
			jButtonAtras = new JButton();
			jButtonAtras.setPreferredSize(new Dimension(150, 25));
			jButtonAtras.setText("< Canviar usuari");
			jButtonAtras.setActionCommand(ATRAS);
			jButtonAtras.addActionListener(this);
		}
		return jButtonAtras;
	}

	
	public void actionPerformed(ActionEvent e) {
		gatherData();
		if(ATRAS.equals(e.getActionCommand())){
			Container parent=getParent();
			try {
				data.setSelectedActionIndex(null);
				parent.remove(this);
				controller.execute(IbkeyActionController.INITIALIZE, data);
				
			} catch (IbkeyControllerException e1) {
				parent.add(this);
				Logger.getLogger(IbkeyView.class).error(e1.getMessage(),e1);
				showMessageError(e1.getMessage(),"Error");
				
			}
		}else if(SEGUENT.equals(e.getActionCommand())){
			Container parent=getParent();
			try {
				parent.remove(this);
				controller.execute(IbkeyActionController.ACTION_LIST, data);
			} catch (IbkeyControllerException e1) {
				parent.add(this);
				Logger.getLogger(IbkeyView.class).error(e1.getMessage(),e1);
				showMessageError(e1.getMessage(),"Error");
			}
		}
		
	}

	private void gatherData() {
		if(data.getControladoresAcciones().size()!=0){
			data.setSelectedActionIndex(getJComboBoxProcediments().getSelectedItem());
			ProcessDefinition selectedProcessDefinition=(ProcessDefinition)((Vector)data.getControladoresAcciones().get(getJComboBoxProcediments().getSelectedItem())).get(3);
			data.setSelectedProcessDefinition(selectedProcessDefinition);
		}

	}


	private void showMessageError(String message,String title) 
	{
		JOptionPane.showMessageDialog(null, message, title , JOptionPane.ERROR_MESSAGE);
	}

	/**
	 * This method initializes jPanelCenter_Top	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelCenter_Top() {
		if (jPanelCenter_Top == null) {
			jPanelCenter_Top = new JPanel();
			jPanelCenter_Top.setLayout(new BorderLayout());
			jPanelCenter_Top.add(getJComboBoxProcediments(), BorderLayout.CENTER);
			jPanelCenter_Top.add(getJPanelCenter_top_left(), BorderLayout.WEST);
			jPanelCenter_Top.add(getJPanelCenter_top_right(), BorderLayout.EAST);
		}
		return jPanelCenter_Top;
	}

	/**
	 * This method initializes jPanelCenter_top_left	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelCenter_top_left() {
		if (jPanelCenter_top_left == null) {
			jPanelCenter_top_left = new JPanel();
			jPanelCenter_top_left.setLayout(new GridBagLayout());
			jPanelCenter_top_left.setPreferredSize(new Dimension(70, 0));
		}
		return jPanelCenter_top_left;
	}

	/**
	 * This method initializes jPanelCenter_top_right	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelCenter_top_right() {
		if (jPanelCenter_top_right == null) {
			jPanelCenter_top_right = new JPanel();
			jPanelCenter_top_right.setLayout(new GridBagLayout());
			jPanelCenter_top_right.setPreferredSize(new Dimension(70, 0));
		}
		return jPanelCenter_top_right;
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
