package es.caib.ibkey.cliente.wizard;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.rmi.AccessException;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import es.caib.ibkey.cliente.common.IbkeyActionController;
import es.caib.ibkey.cliente.common.IbkeyControllerException;
import es.caib.ibkey.cliente.common.IbkeyData;

public class LoginPanel extends JPanel implements ActionListener{

	private IbkeyActionController controller=null;
	private IbkeyData data=null; 
	
	private static final long serialVersionUID = 1L;
	private JLabel jLabelText = null;
	private JPanel jPanelCenter = null;
	private JPanel jPanelUsuari = null;
	private JPanel jPanelPassword = null;
	private JLabel jLabelUsuari = null;
	private JTextField jTextFieldUsuari = null;
	private JLabel jLabelPassword = null;
	private JPanel jPanelSouth = null;
	private JButton jButtonLogin = null;
	private JPasswordField jPasswordFieldContrassenya = null;
	/**
	 * This is the default constructor
	 */
	public LoginPanel(IbkeyActionController actionController, IbkeyData data) {
		super();
		this.controller=actionController;
		this.data=data;
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		jLabelText = new JLabel();
		jLabelText.setText("Siusplau identifiqui's:");
		jLabelText.setHorizontalTextPosition(SwingConstants.CENTER);
		jLabelText.setHorizontalAlignment(SwingConstants.CENTER);
		this.setSize(306, 113);
		this.setLayout(new BorderLayout());
		this.add(jLabelText, BorderLayout.NORTH);
		this.add(getJPanelCenter(), BorderLayout.CENTER);
		this.add(getJPanelSouth(), BorderLayout.SOUTH);
	}

	/**
	 * This method initializes jPanelCenter	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelCenter() {
		if (jPanelCenter == null) {
			jPanelCenter = new JPanel();
			jPanelCenter.setLayout(new BoxLayout(getJPanelCenter(), BoxLayout.Y_AXIS));
			jPanelCenter.add(getJPanelUsuari(), null);
			jPanelCenter.add(getJPanelPassword(), null);
		}
		return jPanelCenter;
	}

	/**
	 * This method initializes jPanelUsuari	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelUsuari() {
		if (jPanelUsuari == null) {
			jLabelUsuari = new JLabel();
			jLabelUsuari.setText("Codi usuari:");
			jLabelUsuari.setPreferredSize(new Dimension(100, 16));
			jPanelUsuari = new JPanel();
			jPanelUsuari.setLayout(new FlowLayout());
			jPanelUsuari.add(jLabelUsuari, null);
			jPanelUsuari.add(getJTextFieldUsuari(), null);
		}
		return jPanelUsuari;
	}

	/**
	 * This method initializes jPanelPassword	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelPassword() {
		if (jPanelPassword == null) {
			jLabelPassword = new JLabel();
			jLabelPassword.setText("Contrasenya");
			jLabelPassword.setPreferredSize(new Dimension(100, 16));
			jPanelPassword = new JPanel();
			jPanelPassword.setLayout(new FlowLayout());
			jPanelPassword.add(jLabelPassword, null);
			jPanelPassword.add(getJPasswordFieldContrassenya(), null);
		}
		return jPanelPassword;
	}

	/**
	 * This method initializes jTextFieldUsuari	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldUsuari() {
		if (jTextFieldUsuari == null) {
			jTextFieldUsuari = new JTextField();
			jTextFieldUsuari.setPreferredSize(new Dimension(120, 20));
			
			jTextFieldUsuari.addKeyListener(new KeyListener(){
				public void keyPressed(KeyEvent e) {
					// TODO Auto-generated method stub
					if(e.getKeyCode() == KeyEvent.VK_ENTER){
						jPasswordFieldContrassenya.requestFocusInWindow();
					}
					
				}

				public void keyReleased(KeyEvent e) {
					// TODO Auto-generated method stub
					
				}

				public void keyTyped(KeyEvent e) {
					// TODO Auto-generated method stub
					
				}
			});
		}
		return jTextFieldUsuari;
	}

	/**
	 * This method initializes jPanelSouth	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelSouth() {
		if (jPanelSouth == null) {
			jPanelSouth = new JPanel();
			jPanelSouth.setLayout(new FlowLayout());
			jPanelSouth.add(getJButtonLogin(), null);
		}
		return jPanelSouth;
	}

	/**
	 * This method initializes jButtonLogin	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonLogin() {
		if (jButtonLogin == null) {
			jButtonLogin = new JButton();
			jButtonLogin.setPreferredSize(new Dimension(150, 25));
			jButtonLogin.setActionCommand(IbkeyActionController.LOGIN_COMMAND);
			jButtonLogin.setText("Identifica'm");
			jButtonLogin.addActionListener(this);
		}
		return jButtonLogin;
	}

	public void focus(){
		getJTextFieldUsuari().requestFocusInWindow();
	}
	
	public void actionPerformed(ActionEvent e) {
		this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		executeAction(e.getActionCommand());
		this.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	}
	
	public void executeAction(String action) {
		gatherData(data);

		Container parent=getParent();
		try {
			parent.remove(this);			  
			controller.execute(action, data);
		} catch (IbkeyControllerException e1) {
			
			parent.add(this);
			if(e1.getCause() instanceof AccessException)
				showMessageError("Usuari o contrassenya incorrectes.","Error");
			else
				showMessageError("Error: "+e1.getMessage(),"Error");
		}

		//una vegada fet el login tenim a data la llista d'accions disponibles.
		//mostrem la pantalla d'accions disponibles
		
	}
	
	
	private void gatherData(IbkeyData data2) {

		data2.setUser(getJTextFieldUsuari().getText());
		data2.setPassword(getJPasswordFieldContrassenya().getText());

	}

	private void showMessageError(String message,String title) 
	{
		JOptionPane.showMessageDialog(null, message, title , JOptionPane.ERROR_MESSAGE);
	}

	/**
	 * This method initializes jPasswordFieldContrassenya	
	 * 	
	 * @return javax.swing.JPasswordField	
	 */
	private JPasswordField getJPasswordFieldContrassenya() {
		if (jPasswordFieldContrassenya == null) {
			jPasswordFieldContrassenya = new JPasswordField();
			jPasswordFieldContrassenya.setPreferredSize(new Dimension(120, 20));
			
			
			jPasswordFieldContrassenya.addKeyListener(new KeyListener(){
				public void keyPressed(KeyEvent e) {
					// TODO Auto-generated method stub
					if(e.getKeyCode() == KeyEvent.VK_ENTER){
						
						actionPerformed(new ActionEvent(this,0,IbkeyActionController.LOGIN_COMMAND));
						//executeAction(IbkeyActionController.LOGIN_COMMAND);
					}
					
				}

				public void keyReleased(KeyEvent e) {
					// TODO Auto-generated method stub
					
				}

				public void keyTyped(KeyEvent e) {
					// TODO Auto-generated method stub
					
				}
			});
		
			

		}
		return jPasswordFieldContrassenya;
	}
	
}  //  @jve:decl-index=0:visual-constraint="10,10"
