package es.caib.ibkey.cliente.wizard;

import java.awt.GridBagLayout;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JLabel;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.CardLayout;
import java.awt.BorderLayout;
import javax.swing.SwingConstants;
import javax.swing.JTextPane;
import java.awt.FlowLayout;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import java.awt.Insets;
import java.awt.GridLayout;
import javax.swing.JButton;

import es.caib.ibkey.cliente.common.IbkeyActionController;
import es.caib.ibkey.cliente.common.IbkeyControllerException;
import es.caib.ibkey.cliente.common.IbkeyData;
import es.caib.ibkey.cliente.common.IbkeyView;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

public class StartNewProcessOrClosePanel extends JPanel implements IbkeyView, ActionListener{

	protected IbkeyData data;  //  @jve:decl-index=0:
	
	private IbkeyActionController controller;  //  @jve:decl-index=0:
	
	private static final long serialVersionUID = 1L;

	private static final String NOU_PROCES = "NP";  //  @jve:decl-index=0:

	private static final String SORTIR = "S";
	
	private JPanel jPanelCenter = null;
	private JLabel jLabelDescripcioEstat = null;
	private JLabel jLabelTextPregunta = null;
	private JLabel jLabelImageOk = null;
	private JPanel jPanelBottom = null;
	private JButton jButtonIniciarProces = null;
	private JButton jButtonSortir = null;
	private JPanel jPanelButtons = null;

	/**
	 * This is the default constructor
	 * @param throwable 
	 */
	public StartNewProcessOrClosePanel() {
		super();
	
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(400, 200);
		this.setLayout(new BorderLayout());
		this.setPreferredSize(new Dimension(400, 200));
		this.add(getJPanelCenter(), BorderLayout.CENTER);
		this.add(getJPanelBottom(), BorderLayout.SOUTH);
		this.add(jLabelDescripcioEstat, BorderLayout.NORTH);
	}

	/**
	 * This method initializes jPanelCenter	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelCenter() {
		if (jPanelCenter == null) {
			jLabelImageOk = new JLabel();
			jLabelImageOk.setText("");
			jLabelImageOk.setHorizontalAlignment(SwingConstants.CENTER);
			jLabelImageOk.setHorizontalTextPosition(SwingConstants.CENTER);
			jLabelTextPregunta = new JLabel();
			jLabelTextPregunta.setText("Desitja sortir de la aplicaci\u00F3 o vol iniciar un nou procediment?");
			jLabelTextPregunta.setPreferredSize(new Dimension(400, 20));
			jLabelTextPregunta.setHorizontalAlignment(SwingConstants.CENTER);
			jLabelDescripcioEstat = new JLabel();
			jLabelDescripcioEstat.setFont(new Font("Dialog", Font.BOLD, 14));
			jLabelDescripcioEstat.setDisplayedMnemonic(KeyEvent.VK_UNDEFINED);
			jLabelDescripcioEstat.setHorizontalAlignment(SwingConstants.CENTER);
			jPanelCenter = new JPanel();
			jPanelCenter.setLayout(new BorderLayout());
			jPanelCenter.add(jLabelImageOk, BorderLayout.CENTER);
		}
		return jPanelCenter;
	}

	/**
	 * This method initializes jPanelBottom	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelBottom() {
		if (jPanelBottom == null) {
			jPanelBottom = new JPanel();
			jPanelBottom.setLayout(new FlowLayout());
			jPanelBottom.setPreferredSize(new Dimension(400, 70));
			jPanelBottom.add(jLabelTextPregunta, null);
			jPanelBottom.add(getJPanelButtons(), null);
		}
		return jPanelBottom;
	}

	/**
	 * This method initializes jButtonIniciarProces	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonIniciarProces() {
		if (jButtonIniciarProces == null) {
			jButtonIniciarProces = new JButton();
			jButtonIniciarProces.setText("Iniciar un nou procediment");
			jButtonIniciarProces.setActionCommand(NOU_PROCES);
			jButtonIniciarProces.addActionListener(this);
		}
		return jButtonIniciarProces;
	}

	/**
	 * This method initializes jButtonSortir	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonSortir() {
		if (jButtonSortir == null) {
			jButtonSortir = new JButton();
			jButtonSortir.setToolTipText("Sortir");
			jButtonSortir.setText("Sortir");
			jButtonSortir.setPreferredSize(new Dimension(100, 30));
			jButtonSortir.setActionCommand(SORTIR);
			jButtonSortir.addActionListener(this);
		}
		return jButtonSortir;
	}

	/**
	 * This method initializes jPanelButtons	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelButtons() {
		if (jPanelButtons == null) {
			jPanelButtons = new JPanel();
			jPanelButtons.setLayout(new FlowLayout());
			jPanelButtons.add(getJButtonIniciarProces(), null);
			jPanelButtons.add(getJButtonSortir(), null);
		}
		return jPanelButtons;
	}

	/**
	 * Controla accions de vista
	 */
	public void execute(String action) throws IbkeyControllerException {
	
	}

	/**
	 * No fa res perquè no tenim dades a recollir
	 */
	public IbkeyData gatherData() {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * retorna el controlador establert
	 */
	public IbkeyActionController getController() {
		return this.controller;
	}

	/**
	 * No fa res perquè no es necessita
	 */
	public IbkeyData getData() {
		return data;
	}

	/**
	 * No fa res perquè no es necessita
	 */
	public IbkeyView getParentView() {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * no fa res perquè no hi ha dades a distribuir
	 */
	public void scatterData() {
		// TODO Auto-generated method stub
		
	}

	/**
	 * Estableix el controlador
	 */
	public void setController(IbkeyActionController controller) {
		this.controller=controller;
		
	}

	/**
	 * No fa res perquè no hi ha dades
	 */
	public synchronized void setData(IbkeyData data) {
		this.data=data;
		initialize();
		
		if(data.getException()==null){
			jLabelDescripcioEstat.setText("Procediment iniciat correctament.");
			jLabelImageOk.setIcon(new ImageIcon(getClass().getResource("ok.gif")));
		}else{
			jLabelDescripcioEstat.setText("Procediment no iniciat.");
			jLabelImageOk.setIcon(new ImageIcon(getClass().getResource("ko.gif")));
		}
		
		//si ve d'aplicació externa o invisible no permetem iniciar de nou, ja que depen d'unes dades concretes externes.
		if(data.getMode().indexOf(IbkeyData.EXTERNAL_APPLICATION_MODE)!=-1 
				|| data.getMode().indexOf(IbkeyData.INVISIBLE_MODE)!=-1) 
			getJButtonIniciarProces().setEnabled(false);

	}

	/**
	 * No fa res perquè no es necessita
	 */
	public void setParentView(IbkeyView parent) {
		
	}

	public void actionPerformed(ActionEvent e) {
			if(SORTIR.equals(e.getActionCommand())){
				try{
					controller.execute(IbkeyActionController.CLOSE, null);
				}catch(IbkeyControllerException ibe){
					JOptionPane.showMessageDialog(null,ibe.getMessage(), "Error" , JOptionPane.ERROR_MESSAGE);
				}
			}else if(NOU_PROCES.equals(e.getActionCommand())){
				
				Container parent=getParent();
				try{
					//reset de finestra
					parent.remove(this);
					//reset de dades sense accions ni res, només usuari/pwd
					IbkeyData tempdata=new IbkeyData();
					tempdata.setUser(data.getUser());
					tempdata.setPassword(data.getPassword());
					data=tempdata;
					
					controller.execute(IbkeyActionController.LOGIN_COMMAND,data);
				}catch(IbkeyControllerException ibe){
					parent.add(this);
					JOptionPane.showMessageDialog(null,ibe.getMessage(), "Error" , JOptionPane.ERROR_MESSAGE);
				}

			}
	}

}
