package es.caib.ibkey.cliente.wizard;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.KeyEvent;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Dimension;

public class WellcomePanel extends JPanel {

	private static final long serialVersionUID = 1L;
	private JLabel jLabelLogo = null;
	private JLabel jLabel = null;
	private JPanel jPanel = null;
	private JLabel jLabel1 = null;
	private JPanel jPanelCenter = null;
	private JLabel jLabelLogoIbkey = null;
	private JLabel jLabelEmpty = null;
	/**
	 * This is the default constructor
	 */
	public WellcomePanel() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(300, 167);
		this.setLayout(new BorderLayout());
		this.setVisible(true);
		
		jLabel = new JLabel();
		jLabel.setText(System.getProperty("es.caib.ibkey.wellcome"));
		jLabel.setHorizontalTextPosition(SwingConstants.CENTER);
		jLabel.setHorizontalAlignment(SwingConstants.CENTER);
		jLabelLogo = new JLabel();
		jLabelLogo.setText("");
		jLabelLogo.setHorizontalAlignment(SwingConstants.CENTER);
		jLabelLogo.setHorizontalTextPosition(SwingConstants.CENTER);
		jLabelLogo.setDisplayedMnemonic(KeyEvent.VK_UNDEFINED);
		jLabelLogo.setIcon(new ImageIcon(getClass().getResource("logo.gif")));
		this.add(getJPanelCenter(), BorderLayout.CENTER);
		
		this.add(getJPanel(), BorderLayout.SOUTH);
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			jLabel1 = new JLabel();
			jLabel1.setText(" ");
			jPanel = new JPanel();
			jPanel.setLayout(new FlowLayout());
			jPanel.add(jLabel, null);
			jPanel.add(jLabel1, null);
		}
		return jPanel;
	}

	/**
	 * This method initializes jPanelCenter	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanelCenter() {
		if (jPanelCenter == null) {
			jLabelEmpty = new JLabel();
			jLabelEmpty.setText("");
			jLabelEmpty.setPreferredSize(new Dimension(0, 10));
			jLabelLogoIbkey = new JLabel();
			jLabelLogoIbkey.setText("");
			jLabelLogoIbkey.setIcon(new ImageIcon(getClass().getResource("ibkey_logo_horizontal.gif")));
			jPanelCenter = new JPanel();
			jPanelCenter.setLayout(new BorderLayout());
			jPanelCenter.add(jLabelLogo, BorderLayout.WEST);
			jPanelCenter.add(jLabelLogoIbkey, BorderLayout.EAST);
			jPanelCenter.add(jLabelEmpty, BorderLayout.SOUTH);
		}
		return jPanelCenter;
	}

	/**
	 * @return the jLabel
	 */
	public synchronized JLabel getjLabel() {
		return jLabel;
	}




}  //  @jve:decl-index=0:visual-constraint="10,10"
