/**
 * 
 */
package es.caib.ibkey.cliente.wizard;




import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

import es.caib.ibkey.cliente.PropertiesInitWorkflow.PropertiesInitWorkflowData;
import es.caib.ibkey.cliente.SAPInitWorkflow.SAPWorkflowData;
import es.caib.ibkey.cliente.common.IbkeyControllerException;
import es.caib.ibkey.cliente.common.IbkeyData;
import es.caib.ibkey.cliente.uploadFileAndInitWorkflow.UploadFileAndInitWorkflowData;


/**
 * @author pere
 *
 */
public class WizardClient {

	public static final String SAP_WORKFLOW_ARGUMENT = "-sapWF";  //  @jve:decl-index=0:
	private static final String DOC_PRINCIPAL_ARGUMENT = "-document";
	private static final String DOC_PRINCIPAL_ANNEXES_ARGUMENT = "-annex";
	private static final String HELP_ARGUMENT = "-?";  //  @jve:decl-index=0:
	private static final String INVISIBLE_ARGUMENT = "-invisible";
	private static final String DOC_PRINCIPAL_NAME_ARGUMENT = "-descripcio";  //  @jve:decl-index=0:
	private static final String SELECTED_WORKFLOW_ARGUMENT = "-accio";  //  @jve:decl-index=0:
	private static final String DOC_PRINCIPAL_DESCRIPTION_ARGUMENT = "-motiu";  
	private static final String STRESS_ARGUMENT = "-stress";  //  @jve:decl-index=0:
	private static final String PROPERTIES_WORKFLOW_ARGUMENT = "-properties";  //  @jve:decl-index=0:
	private static final String EXTERNAL_APPLICATION_ARGUMENT = "-app";
	/**
	 * @param args
	 */
	public static void main(String[] args) {
	     // Set up a simple configuration that logs on the console.
	     BasicConfigurator.configure();

		WizardNavigationController navController=new WizardNavigationController();
		try {
			IbkeyData data=null;
			if(args != null && args.length > 0){
				data=procesArguments(data,args);
				
			}
			
			navController.execute(WizardNavigationController.CREATE_WINDOW, data);
		} catch (IbkeyControllerException e) {
			Logger.getLogger(WizardClient.class).error(e.getMessage(),e);
			System.exit(1);
		} catch(Exception e) {
			Logger.getLogger(WizardClient.class).error(e.getMessage(),e);
			System.exit(1);
		}

	}

	/**
	 * Procesa los argumentos de entrada
	 * @param data
	 * @param args
	 * @return
	 * @throws Exception
	 */
	private static IbkeyData procesArguments(IbkeyData data,String[] args) throws Exception {
		//out=in
		IbkeyData out=data;
	

		
		for(int i=0;i<args.length;i++){
			System.out.println(args[i]);
			
			if(SAP_WORKFLOW_ARGUMENT.equals(args[i])){
				i++;
				out=processSAPWorkflowArguments(out, args[i]);
				out.getExtraArguments().add(args[i-1]);
				out.getExtraArguments().add(args[i]);
			}else if(SELECTED_WORKFLOW_ARGUMENT.equals(args[i])){
				i++;
				if(!( out instanceof UploadFileAndInitWorkflowData)){
					out=new UploadFileAndInitWorkflowData(out);
				}
				out.setSelectedActionIndex(args[i]);
			}else if(DOC_PRINCIPAL_NAME_ARGUMENT.equals(args[i])){
				i++;
				if(!( out instanceof UploadFileAndInitWorkflowData)){
					out=new UploadFileAndInitWorkflowData(out);
				}
				((UploadFileAndInitWorkflowData)out).setName(args[i]);
			}else if(DOC_PRINCIPAL_ARGUMENT.equals(args[i])){
				i++;
				if(!( out instanceof UploadFileAndInitWorkflowData)){
					out=new UploadFileAndInitWorkflowData(out);
				}
				((UploadFileAndInitWorkflowData)out).setFilePath(args[i]);
			}else if(DOC_PRINCIPAL_ANNEXES_ARGUMENT.equals(args[i])){
				i++;
				if(!( out instanceof UploadFileAndInitWorkflowData)){
					out=new UploadFileAndInitWorkflowData(out);
				}
				((UploadFileAndInitWorkflowData)out).getAttachmentFilePaths().add(args[i]);
			
			}else if(INVISIBLE_ARGUMENT.equals(args[i])){
				if(out==null){
					out=new IbkeyData();
				}
				out.setMode(out.getMode()+","+IbkeyData.INVISIBLE_MODE);
				
			}else if(STRESS_ARGUMENT.equals(args[i])){
//				out.setMode(out.getMode()+","+IbkeyData.STRESS_MODE);
			}else if(DOC_PRINCIPAL_DESCRIPTION_ARGUMENT.equals(args[i])){
				i++;
				if(!( out instanceof UploadFileAndInitWorkflowData)){
					out=new UploadFileAndInitWorkflowData(out);
				}
				((UploadFileAndInitWorkflowData)out).setDescription(args[i]);
			}else if(PROPERTIES_WORKFLOW_ARGUMENT.equals(args[i])){
				i++;
				if(!( out instanceof PropertiesInitWorkflowData)){
					out=new PropertiesInitWorkflowData(out);
				}

				((PropertiesInitWorkflowData)out).setPropertiesFile(args[i]);
			}else if(EXTERNAL_APPLICATION_ARGUMENT.equals(args[i])){	
				if(out==null){
					out=new IbkeyData();
				}
				out.setMode(out.getMode()+","+IbkeyData.EXTERNAL_APPLICATION_MODE);
				
				
			}else if(HELP_ARGUMENT.equals(args[i])){
				System.out.println("Ús:");
				System.out.println("assistent-de-firma-electronica  [opcions]\n");
				System.out.println("Opcions:");
				System.out.println("[[-document] [document principal]] ");
				System.out.println("[[-annex] [annex al document principal]] (tantes vegades com annexes es vulguin enviar) ");
				System.out.println("[[-sapWF] [fitxer configuració flux de SAP] ");
				System.out.println("[[-invisible] [Execució invisible] ");
				System.out.println("[[-accio] [Flux a iniciar] ");
				System.out.println("[[-descripcio] [nom del document principal] ");
				System.out.println("[[-motiu] [descripcio del document principal] ");
				System.out.println("[[-app] [crida per a procediments habilitats només per a aplicacions] ");
			}else{
				//si se quisiera que otras opciones lleguen al controlador del plugin, habrá que buscar en el atributo extraArguments del objeto data
				
				//si no hay data lo creamos
				if(out==null){
					out=new IbkeyData();
				}
				
				out.getExtraArguments().add(args[i]);						
						
			}
		}
		
		return out;
	}	
	
	/**
	 * Procesa el fichero de propiedades que contiene la configuración de los workflows de SAP
	 * @param data
	 * @param filePath
	 * @return
	 * @throws Exception
	 */
	private static UploadFileAndInitWorkflowData processSAPWorkflowArguments(IbkeyData data,String filePath) throws Exception{
		//TODO Esto debería ir dentro del método configureAdditionalProcessVariables del SAPWorkflowController.
		

		Properties prop = new Properties();
		prop.load(new FileInputStream(filePath));
		UploadFileAndInitWorkflowData wdata=null;
		if(prop.containsKey("sap_clase")){				
			 wdata= new UploadFileAndInitWorkflowData(data);					
			
			//si algun dia la accion no va en el fichero de propiedades, comprobamos que sea nulo
			if(prop.get("accion")!=null)
				wdata.setSelectedActionIndex(prop.get("accion"));
			if(prop.get("documento")!=null)
				wdata.setFilePath((String)prop.get("documento"));
			if(prop.get("descripcion")!=null)
				wdata.setDescription((String)prop.get("descripcion"));
			if(prop.get("nombre")!=null)
				wdata.setDescription((String)prop.get("nombre"));
		}
		
		return wdata;
	}
}
