package es.caib.ibkey.cliente.wizard;


import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.log4j.Logger;

import es.caib.bpm.exception.BPMException;
import es.caib.ibkey.cliente.common.ClientLogin;
import es.caib.ibkey.cliente.common.IbkeyActionController;
import es.caib.ibkey.cliente.common.IbkeyControllerException;
import es.caib.ibkey.cliente.common.IbkeyData;
import es.caib.ibkey.common.IndexedProcessDefinition;
import es.caib.ibkey.ejb.ejb.IndexedProcessService_V2;
import es.caib.ibkey.ejb.ejb.IndexedProcessService_V2Home;

/**
 * Implementa el controlador del domini
 * @author u91940
 *
 */
public class WizardControllerEmbeded implements IbkeyActionController{
	
	public IbkeyData execute(String action, IbkeyData data) throws  IbkeyControllerException {
		if(INITIALIZE.equals(action)){
			//establim el config.properties a les propietats de sistema
			Properties props=new Properties();
			InputStream fios=null;
			try {
				fios=new FileInputStream("config.properties");
				props.load(fios);
			} catch (IOException e) {
				Logger.getLogger(WizardClient.class).error(e.getMessage(),e);
				throw new IbkeyControllerException("No s'ha pogut carregar la configuraci\u00F3 de l'entorn.");
			}finally{
				try {
					fios.close();
				} catch (IOException e) {
				}
			}
			
			for(Iterator it=props.keySet().iterator();it.hasNext();){
				String prop=(String) it.next();
				System.setProperty(prop,props.getProperty(prop));
			}
		}
		
		if(LOGIN_COMMAND.equals(action)){
			ClientLogin login=new ClientLogin(data.getUser(),data.getPassword());
			try {
				login.login();
				obtenirLlistatAccionsDisponibles(data);
			}catch(IbkeyControllerException ib){
				throw ib;
			}catch (Throwable e) {
				Logger.getLogger(IbkeyActionController.class).error(
						(e.getCause()==null)?e.getMessage()
								:e.getMessage()+"["+e.getCause().getMessage()+"]"
						,e);

				throw new IbkeyControllerException(e.getMessage(),e);
			}
		}
		
		return data;
	}

	public int getProgress() {
		return 0;
	}

	
	/**
	 * Fer el login al EJB i obtenir el llistat d'accions disponibles, i el mapeig a la classe controladora
	 * @throws IOException 
	 * @throws NamingException 
	 * @throws CreateException 
	 * @throws BPMException 
	 * @throws IbkeyControllerException 
	 *
	 */
	private void obtenirLlistatAccionsDisponibles(IbkeyData data) throws IOException, NamingException, CreateException, BPMException, IbkeyControllerException {
       	//reseteamos
		data.setAccionesDisponibles(new Hashtable());
       	data.setControladoresAcciones(new Hashtable());
       	
		
		Context context = new InitialContext(System.getProperties());
		
		
		IndexedProcessService_V2 engine=null;
		try{
			Object lookupObj = context.lookup(System.getProperty("es.caib.ibkey.ibkeyServer.indexProcessService"));

			IndexedProcessService_V2Home home = (IndexedProcessService_V2Home) PortableRemoteObject.narrow(lookupObj, IndexedProcessService_V2Home.class);
			//create the bean object from the home object
			engine=home.create();
		}catch(Throwable e){
			Logger.getLogger(WizardClient.class).error(e.getMessage(),e);
			throw new IbkeyControllerException("Servei aturat",e);
		}
		
		List taskList;
		
		
		//en mode invisible només obté els workflows marcats com a privats.
		//en mode visible obté els públics
		if(data.getMode().indexOf(IbkeyData.INVISIBLE_MODE)!=-1 || data.getMode().indexOf(IbkeyData.EXTERNAL_APPLICATION_MODE)!=-1){
			taskList=engine.findPrivateInitiatorProcessConfig(System.getProperty("es.caib.ibkey.applcationId"));
		}else{
			taskList=engine.findPublicInitiatorProcessConfig(System.getProperty("es.caib.ibkey.applcationId"));
		}

		//objetos para gestionar el listado de controladores para cada workflow
		Map accionesDisponibles=new Hashtable();
		
		Map controladoresClases=new Hashtable();
		
		//asignamos a cada workflow sus correspondientes controladores
		Iterator taskIt=taskList.iterator();
		while(taskIt.hasNext()){
			Vector classNames=new Vector();
			IndexedProcessDefinition obj=(IndexedProcessDefinition)taskIt.next();
			
			accionesDisponibles.put(obj.getProcessDefinition().getName(),obj.getProcessDefinition().getName()+" "+obj.getProcessDefinition().getVersion());
			
			//de momento los controladores de cada workflow son fijos
			classNames.add(obj.getPluginDataClassName()); //data
			classNames.add(obj.getPluginViewClassName()); //view
			classNames.add(obj.getPluginControllerClassName()); //controller
			classNames.add(obj.getProcessDefinition());
			controladoresClases.put(obj.getProcessDefinition().getName(),classNames);
		}
		
					
		data.setAccionesDisponibles(accionesDisponibles);
		data.setControladoresAcciones(controladoresClases);
				
	}

	
}
