package es.caib.ibkey.cliente.wizard;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.swing.JFrame;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import es.caib.ibkey.cliente.common.IbkeyActionController;
import es.caib.ibkey.cliente.common.IbkeyView;

public class WizardMainWindow extends JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public static final Dimension INITIAL_DIMENSION = new Dimension(442, 240);  //  @jve:decl-index=0:
	private JPanel jPanel = null;


	
	
	/**
	 * This method initializes 
	 * 
	 */
	public WizardMainWindow(IbkeyActionController controller) {
		super();	
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
        this.setSize(INITIAL_DIMENSION);
        String version=getVersion();
        this.setTitle(System.getProperty("es.caib.ibkey.applicationTitle")+" ("+version+")");
        this.setContentPane(getJPanel());
	}



	private String getVersion() {
		InputStream inStream=this.getClass().getClassLoader().getResourceAsStream("version.properties");
		Properties props=new Properties();
		try {
			props.load(inStream);
		} catch (IOException e) {
			
			Logger.getLogger(IbkeyView.class).error(e.getMessage(),e);
			return "xxx";
		}
		
		return props.getProperty("version");
	}

	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJPanel() {
		if (jPanel == null) {
			jPanel = new JPanel();
			jPanel.setLayout(new BorderLayout());
		}
		return jPanel;
	}

	

}  //  @jve:decl-index=0:visual-constraint="2,116"
