package es.caib.ibkey.cliente.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Map;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import es.caib.bpm.vo.ProcessDefinition;
import es.caib.ibkey.cliente.common.IbkeyActionController;
import es.caib.ibkey.cliente.common.IbkeyControllerException;
import es.caib.ibkey.cliente.common.IbkeyData;
import es.caib.ibkey.cliente.common.IbkeyView;
import es.caib.ibkey.cliente.uploadFileAndInitWorkflow.UploadFileAndInitWorkflowView;

public class WizardNavigationController implements IbkeyActionController {
	private IbkeyData data = null;
	private JFrame frame = null;
	private WellcomePanel wellcomePanel;
	private JPanel loginPanel;

	private IbkeyActionController domainController = new WizardControllerEmbeded();;
	private LlistatProcedimentsPanel workflowListPanel = null;
	private JPanel pluginPanel = null;
	private IbkeyActionController pluginController = null;

	private boolean invisibleExecution = false;
	private boolean externalExecution=false; 
	
	public WizardNavigationController() {

	}

	public IbkeyData execute(String action, IbkeyData data) throws IbkeyControllerException {
		if (CREATE_WINDOW.equals(action)) {
			domainController.execute(INITIALIZE, data);
			
			frame = new WizardMainWindow(this);
			
			centerFrame(frame);
			
			// Set to exit on close
			frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			URL iconURL = this.getClass().getClassLoader().getResource("ibkey_icon_32.png");
			frame.setIconImage(Toolkit.getDefaultToolkit().getImage(iconURL));

			frame.setVisible(true);

			frame.add(getWellcomePanel(), BorderLayout.NORTH);

			execute(INITIALIZE, data);

		} else if (INITIALIZE.equals(action)) {
			//control de datos inicializados
			if(data == null){
				data=new IbkeyData();
				newLoginPanel(this, data);
			}else{
				newLoginPanel(this, data);
			}
			
			//control de ejecución visible o invisible
			if(data.getMode().indexOf(IbkeyData.INVISIBLE_MODE)!=-1) invisibleExecution = true;
			
			//control de ejecución desde aplicación externa
			if(data.getMode().indexOf(IbkeyData.EXTERNAL_APPLICATION_MODE)!=-1) externalExecution = true;

			// mostrem la finestra. El login sempre es visible
			frame.add(getLoginPanel(), BorderLayout.CENTER);
			frame.validate();
			
			//focus
			((LoginPanel)getLoginPanel()).focus();
			
			
			
		} else if (LOGIN_COMMAND.equals(action)) {
			
			// executem el login a la capa de domini
			try {
				domainController.execute(IbkeyActionController.LOGIN_COMMAND, data);
			} catch (IbkeyControllerException ib){ 
				Logger.getLogger(IbkeyView.class).error(ib.getMessage(),ib);
				// passem l'excepció a la vista
				throw ib;
			} catch (Throwable th) {
				// passem l'excepció a la vista
				Logger.getLogger(IbkeyView.class).error(th.getMessage(),th);
				throw new IbkeyControllerException(th.getMessage(), th);
			}

			


			
			
			
			//resize al tamany inicial
			frame.setSize(WizardMainWindow.INITIAL_DIMENSION);
			
			
			if(invisibleExecution || externalExecution || data.getSelectedActionIndex()!=null){
				//configuramos los datos para avanzar a la siguiente acción
				if(data.getControladoresAcciones()!=null  || data.getControladoresAcciones().size()!=0){
					if(data.getSelectedActionIndex()==null) throw new IbkeyControllerException("No s'ha definit cap acci\u00F3 a iniciar");
					
					if(data.getAccionesDisponibles().containsKey(data.getSelectedActionIndex())){
						ProcessDefinition selectedProcessDefinition=(ProcessDefinition)((Vector)data.getControladoresAcciones().get(data.getSelectedActionIndex())).get(3);
						data.setSelectedProcessDefinition(selectedProcessDefinition);
					}else{
						// Lanzar error de accion no disponible
						throw new IbkeyControllerException("La acci\u00F3 definida no est\u00E0 disponible.");
					}
				}else{
					// Lanzar error de accion no disponible
					throw new IbkeyControllerException("La acci\u00F3 definida no est\u00E0 disponible.");
				}					
				
			}else{
			
				// creem el panell
				newWorkflowListPanel(this, data);
				frame.add(getWorkflowListPanel(), BorderLayout.CENTER);
			}
			
			if(invisibleExecution || externalExecution || data.getSelectedActionIndex()!=null){
				//invisible , aplicació externa o acció entrada com a paràmetre
				
				//si es invisible, l'amaguem
				if(invisibleExecution)
					frame.setVisible(false);
				
				//passem a la seguent finestra
				this.execute(ACTION_LIST, data);
					
			}
				
			
			
			frame.validate();

		} else if (ACTION_LIST.equals(action)) {
					
				
				IbkeyData pluginDataModel = null;
				IbkeyView pluginView = null;

				Map configuracionPlugins = data.getControladoresAcciones();
				Object accion = data.getSelectedActionIndex();
				
				if(configuracionPlugins==null || ((Vector) configuracionPlugins.get(accion)).size()==0)
						throw new IbkeyControllerException("No té cap acció disponible.");
				
				try {
					// inicializamos el modelo de datos del plugin a partir del
					// modelo de datos actual
					pluginDataModel = (IbkeyData) this.getClass().getClassLoader().loadClass((String) ((Vector) configuracionPlugins.get(accion)).get(0)).getConstructor(new Class[] { IbkeyData.class }).newInstance(new Object[] { data });
					
					
					// inicializamos la vista del plugin
					pluginView = (IbkeyView) this.getClass().getClassLoader().loadClass((String) ((Vector) configuracionPlugins.get(accion)).get(1)).newInstance();

					// inicializamos el controlador de acciones del plugin
					pluginController = (IbkeyActionController) this.getClass().getClassLoader().loadClass((String) ((Vector) configuracionPlugins.get(accion)).get(2)).newInstance();

					// para el plugin: establecemos el controlador i el modelo
					// de datos interno, falta establecer la vista padre, pero
					// se debe hacer desde la vista padre.
					frame.add((Component) pluginView);
					pluginView.setController(this);
					pluginView.setData(pluginDataModel);
					pluginView.setParentView(null);



					
					setPluginPanel((JPanel) pluginView);
					
					

				} catch (ClassNotFoundException e) {
					Logger.getLogger(IbkeyActionController.class).error(e.getMessage(), e);
					// TODO fer el descarregador dinàmic de classes model,
					// vista, controlador
					throw new IbkeyControllerException("Necessita actualitzar el seu software.", e);
				} catch (Exception e) {
					Logger.getLogger(IbkeyActionController.class).error(e.getMessage(), e);
					throw new IbkeyControllerException("Error inesperat: " + e.getMessage(), e);

				}

				// establim com a model de dades de la aplicació el del plugin
				data = pluginDataModel;

				if(invisibleExecution)
					frame.setSize(new Dimension(442, 140));
				else{
					frame.setSize(new Dimension(pluginPanel.getWidth() + 50, pluginPanel.getHeight() + 200));
					//frame.setPreferredSize(pluginView.getPreferredSize());
				}
				if(invisibleExecution){
					wellcomePanel.getjLabel().setText("Iniciant el procediment. Siusplau esperau uns segons...");
					frame.setVisible(true);
				}
				
				// afegim la vista del plugi seleccionat
				
				frame.validate();
				centerFrame(frame);

				
				//inicio lanzamos la tarea en modo invisible / estres
				if(invisibleExecution && (pluginView instanceof UploadFileAndInitWorkflowView)){	
						((UploadFileAndInitWorkflowView) pluginView).actionPerformed(new ActionEvent(this,-1, IbkeyActionController.UPLOAD_AND_INIT_TASK_BEGIN));
				}
				//fin de lanzar la tarea en modo invisible /estrés
				

		} else if (action.equals(RESIZE)) {
			frame.setSize(new Dimension(pluginPanel.getWidth() + 50, pluginPanel.getHeight() + 200));
			frame.validate();
		
			
		} else if (action.equals(UPLOAD_AND_INIT_TASK_END)) {
			//eliminem la pantalla del plugin
			frame.remove(getPluginPanel());
			setPluginPanel(null);
			
			//inici - demanem si vol iniciar un nou procés, sinó tanquem
			
			if(data.getMode().indexOf(IbkeyData.STRESS_MODE)==-1) {
				//si no es mode invisible ni prova d'estrés
				//demanem si iniciar un nou procediment o finalitzar
				StartNewProcessOrClosePanel newPanel=getStartNewProcessOrClosePanel(data.getException());
				newPanel.setController(this);
				newPanel.setData(data);
				//resize al tamany inicial
				frame.setSize(new Dimension(442, 330));
				frame.add(newPanel);
				frame.setPreferredSize(newPanel.getSize());
				frame.validate();
				centerFrame(frame);
				frame.setVisible(true);
				
			}

			//si es prova d'estrés, hem de tancar l'aplicació
			if(data.getMode().indexOf(IbkeyData.STRESS_MODE)!=-1){
				execute(CLOSE,null);
			}

		} else if (action.equals(CLOSE)) {
			
			System.exit(0);

		} else {
			// si no ens correspon la tasca, mirem si li toca al controlador del
			// plugin
			if (pluginController != null) {
				pluginController.execute(action, data);
			}
		}
		
		return null;

	}

	private Component getIbkeyLogoPanel() {
		return new IbkeyLogoPanel();
	}

	private StartNewProcessOrClosePanel getStartNewProcessOrClosePanel(Throwable throwable) {
		return new StartNewProcessOrClosePanel();
	}

	private void centerFrame(JFrame _frame) {
		//centramos la ventana
		Dimension screenSize=Toolkit.getDefaultToolkit().getScreenSize();
		int posX=screenSize.width/2-_frame.getSize().width/2;
		int posY=screenSize.height/2-_frame.getSize().height/2;
		_frame.setLocation(posX, posY);
		
	}

	public int getProgress() {

		if(pluginController!=null)
			return pluginController.getProgress();
		else
			return 0;
	}

	private JPanel getWellcomePanel() {
		wellcomePanel = new WellcomePanel();
		return wellcomePanel;
	}

	private JPanel newLoginPanel(IbkeyActionController controller, IbkeyData data) {
		loginPanel = new LoginPanel(controller, data);
		return loginPanel;
	}

	private JPanel newWorkflowListPanel(IbkeyActionController controller, IbkeyData data) {
		workflowListPanel = new LlistatProcedimentsPanel(controller, data);
		return workflowListPanel;
	}

	public LlistatProcedimentsPanel getWorkflowListPanel() {
		return workflowListPanel;
	}

	public JPanel getPluginPanel() {
		return pluginPanel;
	}

	public JPanel getLoginPanel() {
		return loginPanel;
	}

	/**
	 * @param wellcomePanel
	 *            the wellcomePanel to set
	 */
	public void setWellcomePanel(WellcomePanel wellcomePanel) {
		this.wellcomePanel = wellcomePanel;
	}

	/**
	 * @param loginPanel
	 *            the loginPanel to set
	 */
	public void setLoginPanel(JPanel loginPanel) {
		this.loginPanel = loginPanel;
	}

	/**
	 * @param workflowListPanel
	 *            the workflowListPanel to set
	 */
	public void setWorkflowListPanel(LlistatProcedimentsPanel workflowListPanel) {
		this.workflowListPanel = workflowListPanel;
	}

	/**
	 * @param pluginPanel
	 *            the pluginPanel to set
	 */
	public void setPluginPanel(JPanel pluginPanel) {
		this.pluginPanel = pluginPanel;
	}

	public void setData(IbkeyData data){
		this.data=data;
	}

}
