package uk.co.mmscomputing.application.imageviewer;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;

import javax.imageio.IIOImage;
import javax.imageio.IIOParamController;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import uk.co.mmscomputing.image.operators.ImageTypeConvertOp;
import uk.co.mmscomputing.image.operators.ImageTypeConvertOpPanel;
import uk.co.mmscomputing.util.JarImageIcon;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;

public class ImageTab extends JPanel implements PropertyChangeListener {

	static public final String fileOpenID = "uk.co.mmscomputing.file.open.dir";
	static public final String fileSaveID = "uk.co.mmscomputing.file.save.dir";
	static public final String ficheroEscaneado = "ficheroEscaneado";

	protected Properties properties;
	protected JTabbedPane images;
	protected JFileChooser openfc;
	protected JFileChooser savefc;
	protected JCheckBox advanced;
	protected String prefijo;
	protected int numero = 0;
	protected JTextField campo;

	public ImageTab(Properties properties, JTextField campo) {
		this.properties = properties;
		this.campo = campo;
		this.numero = 0;

		setLayout(new BorderLayout());

		JPanel p = new JPanel();
		p.setLayout(new BorderLayout());
		JPanel q = new JPanel();
		q.setLayout(new BoxLayout(q, BoxLayout.PAGE_AXIS));
		setButtonPanel(q);
		p.add(q, BorderLayout.NORTH);
		add(p, BorderLayout.EAST);

		images = new JTabbedPane();
		//add(images, BorderLayout.CENTER);

		String userdir = System.getProperty("user.home");
		setOpenDir(properties.getProperty(fileOpenID, userdir));
		setSaveDir(properties.getProperty(fileSaveID, userdir));

		String nombrePDF = properties.getProperty(ficheroEscaneado);
		prefijo = nombrePDF.substring(0, nombrePDF.lastIndexOf('.'));
	}

	public void setOpenDir(String path) {
		new File(path).mkdirs();
		openfc = new JFileChooser(path);
	}

	public void setSaveDir(String path) {
		new File(path).mkdirs();
		savefc = new JFileChooser(path);
	}

	protected void setButtonPanel(JPanel gui) {
		JPanel buttonPanel = new JPanel();
		buttonPanel.setLayout(new GridLayout(0, 1));

		// Botn que dispara la generacin del PDF final
		buttonPanel.add(new JButton(getSaveAction()));

		// Botones no usados actualmente
		// buttonPanel.add(new JButton(getNewAction()));
		// buttonPanel.add(new JButton(getOpenAction()));
		// buttonPanel.add(new JButton(getPrintAction()));
		// buttonPanel.add(new JButton(getConvertAction()));
		// buttonPanel.add(new JButton(getRotateAction()));

		// Checkbox para habilitar el GUI nativo del escner
		advanced = new JCheckBox();
		advanced.setSelected(true);
		advanced.setText("Opcions avanades");
		buttonPanel.add(advanced);

		gui.add(buttonPanel);
	}

	public Action getNewAction() {
		return new AbstractAction("new", new JarImageIcon(getClass(), "32x32/new.png")) {
			public void actionPerformed(ActionEvent ev) {
				images.removeAll();
			}
		};
	}

	public Action getOpenAction() {
		return new AbstractAction("open", new JarImageIcon(getClass(), "32x32/open.png")) {
			public void actionPerformed(ActionEvent ev) {
				int res = openfc.showOpenDialog(null);
				properties.setProperty(fileOpenID, openfc.getCurrentDirectory().toString());
				if (res == JFileChooser.APPROVE_OPTION) {
					try {
						open(openfc.getSelectedFile().getPath());
					} catch (Exception e) {
						JOptionPane.showMessageDialog(null, "Image Open Error : " + e.getMessage(), "Exception", JOptionPane.ERROR_MESSAGE);
					}
				}
			}
		};
	}

	public Action getSaveAction() {
		return new AbstractAction("Guardar", new JarImageIcon(getClass(), "32x32/save.png")) {
			public void actionPerformed(ActionEvent ev) {
				new Thread() {
					public void run() {
						try {
							jpegsToPdf();
							campo.setText(properties.getProperty("ficheroEscaneado"));
							// Cierra (de hecho, oculta) las ventanas secundarias
							Frame[] frame = Frame.getFrames();
							for (int i = 1; i < frame.length; i++) {
								frame[i].setVisible(false);
							}
						} catch (Exception e) {
							JOptionPane.showMessageDialog(null, "Heu d'escanejar primer per poder guardar", "Exception", JOptionPane.ERROR_MESSAGE);
						}
					}
				}.start();
			}
		};
	}

	public Action getPrintAction() {
		return new AbstractAction("", new JarImageIcon(getClass(), "32x32/print.png")) {
			public void actionPerformed(ActionEvent ev) {
				new Thread() {
					public void run() {
						Printer p = new Printer();
						for (int i = 0; i < images.getTabCount(); i++) {
							JScrollPane sp = (JScrollPane) images.getComponentAt(i);
							ImagePanel ip = (ImagePanel) sp.getViewport().getView();
							p.append(ip);
						}
						p.print();
					}
				}.start();
			}
		};
	}

	public Action getConvertAction() {
		return new AbstractAction("<html><center><b>Colour</b><br><b>Reduction</b></center></html>") {
			public void actionPerformed(ActionEvent ev) {
				convertImage();
			}
		};
	}

	public Action getRotateAction() {
		return new AbstractAction("", new JarImageIcon(getClass(), "32x32/rotate.png")) {
			public void actionPerformed(ActionEvent ev) {
				JScrollPane sp = (JScrollPane) images.getSelectedComponent();
				if (sp != null) {
					ImagePanel ip = (ImagePanel) sp.getViewport().getView();
					ip.rotate();
				}
			}
		};
	}

	protected void cleanTabs() {
		// Trabajamos con 1 solo tab todo el tiempo para no saturar la memoria
		if (images.getTabCount() == 1) {
			JScrollPane sp = (JScrollPane) images.getComponentAt(0);
			ImagePanel ip = (ImagePanel) sp.getViewport().getView();
			BufferedImage i = ip.getImage();
			i.flush();
			ip.setImage(null);
			ip.removeAll();
			sp.removeAll();
			images.remove(0);
		}
	}

	protected void addImage(String fn, BufferedImage img) {
		Object md = img.getProperty("iiometadata");
		if ((md != Image.UndefinedProperty) && (md != null) && (md instanceof IIOMetadata)) {
			// new MetadataReader().read((IIOMetadata)md);
		}

		System.out.println("Image.Width = " + img.getWidth());
		System.out.println("Image.Height = " + img.getHeight());

		ImagePanel ip = new ImagePanel();
		ip.addPropertyChangeListener(this);
		JScrollPane sp = new JScrollPane(ip);
		sp.getVerticalScrollBar().setUnitIncrement(100);
		sp.getHorizontalScrollBar().setUnitIncrement(100);
		ip.setImage(img);
		cleanTabs();
		images.addTab(fn, null /* new TabCloseIcon() */, sp);
		images.setSelectedIndex(0);
		try {
			saveJpeg();
		} catch (IOException e) {
			JOptionPane.showMessageDialog(null, "Image Save Error : " + e.getMessage(), "Exception", JOptionPane.ERROR_MESSAGE);
		}
	}

	public void open(String filename) throws IOException {
		long time = System.currentTimeMillis();

		String ext = filename.substring(filename.lastIndexOf('.') + 1);
		Iterator readers = ImageIO.getImageReadersByFormatName(ext);
		if (!readers.hasNext()) {
			throw new IOException(getClass().getName() + ".open:\n\tNo reader for format '" + ext + "' available.");
		}

		ImageReader reader = (ImageReader) readers.next();
		while (!reader.getClass().getName().startsWith("uk.co.mmscomputing") && readers.hasNext()) {// prefer
			// our
			// own
			// reader
			reader = (ImageReader) readers.next();
		}
		File f = new File(filename);
		ImageInputStream iis = ImageIO.createImageInputStream(f);
		try {
			reader.setInput(iis, true);
			try {
				for (int i = 0; true; i++) {
					IIOMetadata md = reader.getImageMetadata(i);
					// if(md!=null){new MetadataReader().read(md);}
					addImage(f.getName() + " " + i, reader.read(i));
				}
			} catch (IndexOutOfBoundsException ioobe) {
			}
		} catch (Error e) {
			System.out.println("9\b" + getClass().getName() + ".open:\n\t" + e);
			e.printStackTrace();
			throw e;
		} finally {
			iis.close();
		}
		time = System.currentTimeMillis() - time;
		System.out.println("Opened : " + filename);
		System.out.println("Time used to load images : " + time);
	}

	private IIOImage getIIOImage(ImageWriter writer, ImageWriteParam iwp, BufferedImage image) {
		ImageTypeSpecifier it = ImageTypeSpecifier.createFromRenderedImage(image);

		/*
		 * try{ uk.co.mmscomputing.imageio.bmp.BMPMetadata
		 * md=(uk.co.mmscomputing
		 * .imageio.bmp.BMPMetadata)image.getProperty("iiometadata");
		 * if(md!=null){ md.setXPixelsPerMeter(11812); // force 300 dpi for bmp
		 * images md.setYPixelsPerMeter(11812); // works only with mmsc.bmp
		 * package } }catch(Exception e){}
		 */

		IIOMetadata md;
		Object obj = image.getProperty("iiometadata"); // if image is a
		// TwainBufferedImage
		// get metadata
		if ((obj != null) && (obj instanceof IIOMetadata)) {
			md = (IIOMetadata) obj;
		} else {
			md = writer.getDefaultImageMetadata(it, iwp);
		}
		// if(md!=null){new MetadataReader().read(md);}

		return new IIOImage(image, null, md);
	}

	/**
	 * Combina uno o ms JPEGs en un solo PDF
	 * 
	 * @param prefix
	 *            Path base, excluyendo sufijos de numeracin y extensiones
	 */
	public void jpegsToPdf() {
		try {

			// Inicializamos y creamos el PDF
			com.lowagie.text.Rectangle a4 = PageSize.A4;
			float horizontalCorrectionMargin = 75; // Para que los A4 escaneados
			// no se salgan de la hoja
			// por la derecha
			float horizontalMargins = a4.getBorderWidthLeft() + a4.getBorderWidthRight() + horizontalCorrectionMargin;
			float verticalMargins = a4.getBorderWidthTop() + a4.getBorderWidthBottom();
			float horizontalImageSize = a4.getWidth() - horizontalMargins;
			float verticalImageSize = a4.getHeight() - verticalMargins;
			Document document = new Document(a4);
			File ficheroPDF = new File(prefijo + ".pdf");
			OutputStream salida = new FileOutputStream(ficheroPDF);
			PdfWriter.getInstance(document, salida);
			document.open();

			// Aadimos los JPEGs con el prefijo deseado al PDF
			class JpegFilter implements FileFilter {
				final String prefix;

				public JpegFilter(String prefix) {
					this.prefix = prefix;
				}

				public boolean accept(File pathname) {
					String path = pathname.getPath();
					return path.startsWith(prefix) && path.endsWith(".jpg");
				}
			}
			File[] files = new File(prefijo).getParentFile().listFiles(new JpegFilter(prefijo));
			Arrays.sort(files);
			for (File jpegFile : files) {
				String ficheroJPG = jpegFile.getPath();
				System.out.println("Aadiendo JPG " + ficheroJPG + " al PDF.");
				com.lowagie.text.Image jpg = com.lowagie.text.Image.getInstance(ficheroJPG);
				if (jpg.getWidth() > horizontalImageSize || jpg.getHeight() > verticalImageSize) {
					jpg.scaleToFit(horizontalImageSize, verticalImageSize);
				}
				document.add(jpg);
			}

			// Finalizamos el PDF
			System.out.println("Cerrando PDF " + ficheroPDF);
			document.close();
			
			// Limpiamos los JPEGs que ya no hacen falta, para no llenar el disco
			for (File jpegFile : files) {
				jpegFile.delete();
			}

		} catch (DocumentException doe) {
			JOptionPane.showMessageDialog(null, "Image Convert Error : " + doe.getMessage(), "DocumentException", JOptionPane.ERROR_MESSAGE);
		} catch (MalformedURLException mue) {
			JOptionPane.showMessageDialog(null, "Image Convert Error : " + mue.getMessage(), "MalformedURLException", JOptionPane.ERROR_MESSAGE);
		} catch (IOException ioe) {
			JOptionPane.showMessageDialog(null, "Image Convert Error : " + ioe.getMessage(), "IOException", JOptionPane.ERROR_MESSAGE);
		}
	}

	/**
	 * Nuevo mtodo para salvar mltiples imgenes en mltiples ficheros JPEG
	 * que sern combinados en un nico PDF en el siguiente paso, en principio
	 * el mtodo convert().
	 * 
	 * @throws IOException
	 *             Si falla escribiendo
	 */
	public void saveJpeg() throws IOException {

		// Ahora trabajamos solo con 1 tab para no saturar la memoria
		if (images.getTabCount() != 1) {
			throw new IOException(getClass().getName() + ".saveJpeg: Necesito exactamente 1 tab de imagen");
		}

		// Este mtodo necesita un escritor de JPEGs
		String ext = "jpg";
		Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(ext);
		if (!writers.hasNext()) {
			throw new IOException(getClass().getName() + ".saveJpeg: No encuentro escritor para el formato '" + ext + "'!");
		}
		ImageWriter writer = (ImageWriter) writers.next();
		while (!writer.getClass().getName().startsWith("uk.co.mmscomputing") && writers.hasNext()) {
			writer = (ImageWriter) writers.next();
		}
		ImageWriteParam iwp = writer.getDefaultWriteParam();
		IIOParamController controller = iwp.getController();
		if (controller != null) {
			controller.activate(iwp);
		}

		// Para cada imagen, se graba un fichero JPG con igual prefijo y un
		// sufijo numerado
		File file = new File(prefijo + "-" + (numero++) + ".jpg");
		if (file.exists()) {
			file.delete();
		}
		ImageOutputStream ios = ImageIO.createImageOutputStream(file);
		writer.setOutput(ios);
		// Cogemos el primer componente (nmero cero) a pin fijo, sabemos que
		// hay uno y solo uno
		JScrollPane sp = (JScrollPane) images.getComponentAt(0);
		ImagePanel ip = (ImagePanel) sp.getViewport().getView();
		writer.write(null, getIIOImage(writer, iwp, ip.getImage()), iwp);
	}

	/**
	 * Viejo mtodo de salvar que en funcin del prefijo hace una cosa u otra en
	 * presencia de varios tabs. Con JPEG y otros formatos de una sola imagen
	 * solo graba una imagen y si hay ms da un error. Con TIFF y otros formatos
	 * multi-imagen las graba todas en el mismo fichero.
	 */
	public void save(String filename) throws IOException {
		if (images.getTabCount() <= 0) {
			throw new IOException(getClass().getName() + ".save:\n\tNo images available!");
		}
		String ext = filename.substring(filename.lastIndexOf('.') + 1);
		Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(ext);
		if (!writers.hasNext()) {
			throw new IOException(getClass().getName() + ".save:\n\tNo writer for format '" + ext + "' available.");
		}
		ImageWriter writer = (ImageWriter) writers.next();
		while (!writer.getClass().getName().startsWith("uk.co.mmscomputing") && writers.hasNext()) {
			writer = (ImageWriter) writers.next();
		}
		ImageWriteParam iwp = writer.getDefaultWriteParam();
		IIOParamController controller = iwp.getController();
		if (controller != null) {
			controller.activate(iwp);
		}
		File file = new File(filename);
		if (file.exists()) {
			file.delete();
		}
		ImageOutputStream ios = ImageIO.createImageOutputStream(file);
		writer.setOutput(ios);
		if (writer.canWriteSequence()) { // i.e tiff,sff(fax)
			writer.prepareWriteSequence(null);
			for (int i = 0; i < images.getTabCount(); i++) {
				JScrollPane sp = (JScrollPane) images.getComponentAt(i);
				ImagePanel ip = (ImagePanel) sp.getViewport().getView();
				BufferedImage image = ip.getImage();
				writer.writeToSequence(getIIOImage(writer, iwp, image), iwp);
			}
			writer.endWriteSequence();
		} else {
			JScrollPane sp = (JScrollPane) images.getComponentAt(0);
			ImagePanel ip = (ImagePanel) sp.getViewport().getView();
			writer.write(null, getIIOImage(writer, iwp, ip.getImage()), iwp);
			for (int i = 1; i < images.getTabCount(); i++) {
				if (writer.canInsertImage(i)) {
					sp = (JScrollPane) images.getComponentAt(i);
					ip = (ImagePanel) sp.getViewport().getView();
					writer.write(null, getIIOImage(writer, iwp, ip.getImage()), iwp);
				} else {
					throw new IOException("Image Writer cannot append image [" + i + "] (" + filename + ")");
				}
			}
		}
		System.out.println("Saved : " + filename);
	}

	public void convertImage() {
		new Thread() {
			public void run() {
				try {
					ImageTypeConvertOpPanel itcop = new ImageTypeConvertOpPanel();
					ImageTypeConvertOp itco = itcop.activate();
					if (itco != null) {
						for (int i = 0; i < images.getTabCount(); i++) {
							JScrollPane sp = (JScrollPane) images.getComponentAt(i);
							ImagePanel ip = (ImagePanel) sp.getViewport().getView();

							BufferedImage image = itco.filter(ip.getImage());

							ip.setImage(image);
							ip.revalidate();
							ip.repaint();

							String type = "Unknown Type";

							switch (image.getType()) {
							case BufferedImage.TYPE_BYTE_BINARY:
								type = "Byte Binary";
								break;
							case BufferedImage.TYPE_BYTE_INDEXED:
								type = "Byte Indexed";
								break;
							}
							ColorModel cm = image.getColorModel();
							System.out.println("9\bConverted Images to:\n\ntype: " + type + "\nbpp: " + cm.getPixelSize());
						}
					}
				} catch (Exception e) {
					System.out.println("9\b" + getClass().getName() + ".convertImage:\n\t" + e);
					e.printStackTrace();
				}
			}
		}.start();
	}

	/*
	 * public void convertToBWImage(){ for(int i=0; i<images.getTabCount();
	 * i++){ JScrollPane sp=(JScrollPane)images.getComponentAt(i); ImagePanel
	 * ip=(ImagePanel)sp.getViewport().getView(); BufferedImage
	 * original=ip.getImage(); BufferedImage image=new
	 * BufferedImage(original.getWidth
	 * (),original.getHeight(),BufferedImage.TYPE_BYTE_BINARY); Graphics2D
	 * g=image.createGraphics(); AffineTransform t=new AffineTransform();
	 * g.drawRenderedImage(original,t); ip.setImage(image);
	 * ip.revalidate();ip.repaint(); } }
	 */
	public void propertyChange(final PropertyChangeEvent evt) {
		/*
		 * String prop=evt.getPropertyName(); if(prop.equals("open")){
		 * JTabbedPane tp=(JTabbedPane)getParent(); tp.setSelectedIndex(1); new
		 * Thread(){ public void run(){ try{ open((String)evt.getNewValue());
		 * }catch(Exception e){ JOptionPane.showMessageDialog(null,
		 * "Image Open Error : "+e.getMessage(), "Exception",
		 * JOptionPane.ERROR_MESSAGE); } } }.start(); }else
		 * if(prop.equals("save")){ new Thread(){ public void run(){ try{
		 * open((String)evt.getNewValue()); int res=savefc.showSaveDialog(null);
		 * if(res==JFileChooser.APPROVE_OPTION){
		 * save(savefc.getSelectedFile().getPath()); } }catch(IOException ioe){
		 * System.out.println("9\b"+ioe.getMessage()); } } }.start(); }
		 */
	}

	static private class Printer extends Thread {
		PrinterJob pj;
		PageFormat pf;
		Book bk;

		public Printer() {
			pj = PrinterJob.getPrinterJob();

			pf = pj.defaultPage();
			Paper p = pf.getPaper();
			p.setImageableArea(0.0, 0.0, p.getWidth(), p.getHeight());
			pf.setPaper(p);
			pf = pj.validatePage(pf);

			bk = new Book();
		}

		public void append(ImagePanel image) {
			bk.append(image, pf);
		}

		public void print() {
			pj.setPageable(bk);
			if (pj.printDialog()) {
				try {
					pj.print();
				} catch (Exception e) {
					e.printStackTrace();
					System.out.println("9\b" + getClass().getName() + ".print:\n\t" + e.getMessage());
				}
			}
		}
	}
}
