package uk.co.mmscomputing.device.twain;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerIOException;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;
import uk.co.mmscomputing.util.JarImageIcon;

public class TwainPanel extends JComponent implements TwainConstants, ScannerListener {

	PropertyResourceBundle properties = null;
	Scanner scanner = null;
	JButton acqbutton = null;
	JButton selbutton = null;
	JCheckBox guicheckbox = null;
	JComboBox dpicombo = null;
	Hashtable<String, Double> resolutions = null;
	final JDialog modal;

	public TwainPanel(Scanner scanner, PropertyResourceBundle properties) {
		this(scanner);
		setProperties(properties);
	}

	public TwainPanel(Scanner scanner) {

		// Bot d'escanejat
		this.scanner = scanner;
		scanner.addListener(this);
		setLayout(new GridLayout(0, 1));
		acqbutton = new JButton("Escanejar", new JarImageIcon(getClass(), "32x32/scanner.png"));
		acqbutton.addActionListener((ActionListener) EventHandler.create(ActionListener.class, this, "acquire"));
		add(acqbutton);

		// Checkbox d'habilitar GUI
		JPanel p = new JPanel();
		p.setBorder(BorderFactory.createEtchedBorder());
		guicheckbox = new JCheckBox("Habilitar GUI");
		guicheckbox.setSelected(false);
		p.add(guicheckbox);
		// add(p);

		// Combobox de resolucions
		resolutions = new Hashtable<String, Double>();
		resolutions.put("Alta resoluci", 600.0);
		resolutions.put("Resoluci mitja", 300.0);
		resolutions.put("Baixa resoluci", 100.0);
		dpicombo = new JComboBox();
		for (String r : (Set<String>) resolutions.keySet()) {
			dpicombo.addItem(r);
		}
		add(dpicombo);

		selbutton = new JButton("Escner", new JarImageIcon(getClass(), "32x32/list.png"));
		selbutton.addActionListener((ActionListener) EventHandler.create(ActionListener.class, this, "select"));
		// add(selbutton);
		
		// Dileg modal
		modal = getModal();

		if (jtwain.getSource().isBusy()) { // applets might not be in state 3
			acqbutton.setEnabled(false);
			selbutton.setEnabled(false);
			guicheckbox.setEnabled(false);
		}
	}

	public void setProperties(PropertyResourceBundle properties) {
		this.properties = properties;
		if (properties != null) {
			try {
				acqbutton.setText(properties.getString("escanejar"));
			} catch (MissingResourceException ex) {
			}
			try {
				selbutton.setText(properties.getString("escaner"));
			} catch (MissingResourceException ex) {
			}
			try {
				guicheckbox.setText(properties.getString("habilitarGUI"));
			} catch (MissingResourceException ex) {
			}
		}
	}

	// create modal dialog
	private JDialog getModal() {
		JDialog modal = new JDialog(new Frame(), "Escanejant", true);
		Label text = new Label("Esperau si us plau...");
		text.setAlignment(Label.CENTER);
		modal.add(text);
		int width = 250;
		int height = 150;
		modal.setSize(width, height);
		Dimension dim = getToolkit().getScreenSize();
		modal.setLocation((dim.width - width) / 2, (dim.height - height) / 2);
		return modal;
	}

	// acquire BufferedImage from selected/default twain source
	public void acquire() {
		// Show modal dialog and begin scan
		new Thread() {
			public void run() {
				modal.setVisible(true);
			}
		}.start();
		scanner.acquire();
	}

	// select twain data source
	public void select() {
		scanner.select();
	}

	public void update(ScannerIOMetadata.Type type, final ScannerIOMetadata md) {
		if (md instanceof TwainIOMetadata) {
			TwainIOMetadata metadata = (TwainIOMetadata) md;
			TwainSource source = metadata.getSource();

			if (type.equals(ScannerIOMetadata.STATECHANGE)) {
				if (metadata.isState(STATE_SRCMNGOPEN)) { // state = 3
					if (source.isBusy()) {
						acqbutton.setEnabled(false);
						selbutton.setEnabled(false);
						guicheckbox.setEnabled(false);
					} else {
						acqbutton.setEnabled(true);
						selbutton.setEnabled(true);
						guicheckbox.setEnabled(true);
					}
				}
			} else if (type.equals(ScannerIOMetadata.NEGOTIATE)) {
				if (source.isUIControllable()) { // if it is possible to hide source's GUI
					source.setShowUI(guicheckbox.isSelected()); // then use checkbox value
				} else {
					if (!guicheckbox.isSelected()) {
						System.out.println("9\bCannot hide twain source's GUI.");
					}
					guicheckbox.setSelected(true); // else set to true whatever the user selected
				}
				try {
					source.setResolution(resolutions.get(dpicombo.getSelectedItem()));
				} catch (ScannerIOException e) {
					System.out.println("Cannot set resolution in DPI, using default values");
				}
			} else if (type.equals(ScannerIOMetadata.ACQUIRED) ||
					type.equals(ScannerIOMetadata.EXCEPTION)) {
				modal.setVisible(false);
			}
		}
	}
}
