package uk.co.mmscomputing.device.twain;

import java.awt.image.*;
import javax.swing.*;

import java.io.*;
import java.util.PropertyResourceBundle;


import uk.co.mmscomputing.device.scanner.*;

public class TwainScanner extends Scanner implements TwainConstants{

  public TwainScanner(){
    metadata=new TwainIOMetadata();
    jtwain.setScanner(this);
  }

// call native routine; TwainScanner -> jtwain.class -> jtwain.dll

  public void select(){		      	       // select twain source
    try{
      jtwain.select(this);
    }catch(Exception e){
      metadata.setException(e);
      fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
    }
  }
 
  public void select(String name){		   // select twain source
    try{
      jtwain.select(this,name);
    }catch(Exception e){
      metadata.setException(e);
      fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
    }
  }
 
  public void acquire(){                 // initiate scan
    try{
      jtwain.acquire(this);
    }catch(Exception e){
      metadata.setException(e);
      fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
    }
  }

// callback function jtwain.dll -> jtwain.class -> TwainScanner.class

  void setImage(BufferedImage image){    // received an image
    try{
      metadata.setImage(image);
      fireListenerUpdate(ScannerIOMetadata.ACQUIRED);
    }catch(Exception e){
      metadata.setException(e);
      fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
    }
  }

  void setImage(File file){              // received an image using file transfer
    try{
      metadata.setFile(file);
      fireListenerUpdate(ScannerIOMetadata.FILE);
    }catch(Exception e){
      metadata.setException(e);
      fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
    }
  }

  void setImageBuffer(TwainTransfer.MemoryTransfer.Info info,byte[] buf){
    // we don't do anything here yet
    System.out.println(info.toString());
  }


  protected void negotiateCapabilities(TwainSource source){     
    // Called in jtwain when source is in state 4: negotiate capabilities
    ((TwainIOMetadata)metadata).setSource(source);
    fireListenerUpdate(ScannerIOMetadata.NEGOTIATE);
    if(metadata.getCancel()){                     // application wants us to abort scan
      try{
        source.close();
      }catch(Exception e){
        metadata.setException(e);
        fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
      }
    }
  }

  void setState(TwainSource source){
    metadata.setState(source.getState());
    ((TwainIOMetadata)metadata).setSource(source);
    fireListenerUpdate(ScannerIOMetadata.STATECHANGE);
  }

  void signalInfo(String msg,int val){
    metadata.setInfo(msg+" [0x"+Integer.toHexString(val)+"]");
    fireListenerUpdate(ScannerIOMetadata.INFO);
  }

  void signalException(String msg){
    Exception e=new TwainIOException(getClass().getName()+".setException:\n    "+msg);
    metadata.setException(e);
    fireListenerUpdate(ScannerIOMetadata.EXCEPTION);
  }

  public JComponent getScanGUI(){return new TwainPanel(this);}
  public JComponent getScanGUI(PropertyResourceBundle properties){return new TwainPanel(this, properties);}
  public boolean isAPIInstalled(){return jtwain.isInstalled();}

//  protected void finalize()throws Throwable{
//    System.err.println(getClass().getName()+".finalize:");
//  }

  static public Scanner getDevice(){
    return new TwainScanner();
  }
}
