package uk.co.mmscomputing.device.twain.applet; 

import java.awt.Button;
import java.awt.GridLayout;
import java.applet.Applet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerDevice;
import uk.co.mmscomputing.device.scanner.ScannerListener;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;

public class TwainAppletExample extends Applet implements ActionListener, ScannerListener{

  String  filename;

  Scanner scanner;
  Button  acquireButton,selectButton;

  public void init(){
    setLayout(new GridLayout(0,2));
    selectButton = new Button("select");
    add(selectButton);
    selectButton.addActionListener(this);

    acquireButton = new Button("acquire");
    add(acquireButton);
    acquireButton.addActionListener(this);

    filename=System.getProperty("user.home")+"/test.jpg";
    showStatus(filename);

    scanner=Scanner.getDevice();
    scanner.addListener(this);

//    scanner.select("TWAIN_32 Sample Source");
  }

  public void actionPerformed(ActionEvent evt){
    if(evt.getSource()==acquireButton){
      scanner.acquire();
    }else if(evt.getSource()==selectButton){
      scanner.select();
    }
  }

  public void update(ScannerIOMetadata.Type type, ScannerIOMetadata metadata){

    if(type.equals(ScannerIOMetadata.ACQUIRED)){
      BufferedImage image=metadata.getImage();
      System.out.println("Have an image now!");
      try{
        ImageIO.write(image, "jpg", new File(filename));
        showStatus(filename);
      }catch(Exception e){
        e.printStackTrace();
      }
    }else if(type.equals(ScannerIOMetadata.NEGOTIATE)){
      ScannerDevice device=metadata.getDevice();
/*
      try{
        device.setShowUserInterface(true);
        device.setShowProgressBar(true);
        device.setRegionOfInterest(0,0,210.0,300.0);
        device.setResolution(100);
      }catch(Exception e){
        e.printStackTrace();
      }
*/
    }else if(type.equals(ScannerIOMetadata.STATECHANGE)){
      System.err.println(metadata.getStateStr());
    }else if(type.equals(ScannerIOMetadata.EXCEPTION)){
      metadata.getException().printStackTrace();
    }
  }
}