package uk.co.mmscomputing.util;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

abstract public class UtilMainApp extends JApplet {

	private Properties properties = new Properties();
	private File propertiesFile;
	protected JTextField campo;

	public UtilMainApp() {
		super();
		System.out.println("UtilMainApp.campo = " + this.campo);
	}

	public UtilMainApp(String title, String[] argv, JTextField campo) {
		this.campo = campo;
		JFrame.setDefaultLookAndFeelDecorated(false);

		JFrame frame = new JFrame(title);
		frame.setDefaultCloseOperation(WindowConstants.HIDE_ON_CLOSE);

		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent ev) {
				stop();
				//System.exit(0);
			}
		});
		frame.getContentPane().add(this);

		GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
		setFrameSize(frame, ge.getMaximumWindowBounds());
		init();
		frame.setLocationRelativeTo(null);
		// frame.pack();
		frame.setVisible(true);
		start();
	}

	protected void setFrameSize(JFrame frame, Rectangle bounds) {
		frame.setSize(bounds.width * 4 / 5, bounds.height * 4 / 5);
	}

	abstract protected JPanel getCenterPanel(Properties properties) throws Exception;

	public void createGUI() {
		try {

			Runtime rt = Runtime.getRuntime();
			System.out.println("Runtime Total Memory: " + (rt.totalMemory() / (1024 * 1024)) + " MB");
			System.out.println("Runtime Max   Memory: " + (rt.maxMemory() / (1024 * 1024)) + " MB");

			String s = System.getProperty("java.home");
			System.out.println("java directory: " + s);

			String userdir = System.getProperty("user.home");
			System.out.println("user directory: " + userdir);

			File parent = new File(userdir, "mmsc");
			String classname = getClass().getName();
			String filename = classname.substring(0, classname.lastIndexOf('.')) + ".properties.txt";
			try {
				parent.mkdirs();
				propertiesFile = new File(parent.getAbsolutePath(), filename);
			} catch (Exception e) {
				System.out.println("9\bCould not create directory:\n\t" + parent.getAbsolutePath() + "\n\t" + e);
				propertiesFile = new File(filename);
			}

			System.out.println("properties file: " + propertiesFile.getAbsolutePath());

			if (propertiesFile.exists()) {
				properties.load(new FileInputStream(propertiesFile));
			}

			JTabbedPane tp = new JTabbedPane();
			tp.addTab("eCompulsa", getCenterPanel(properties));

			Container cp = this.getContentPane();
			cp.setLayout(new BorderLayout());
			cp.add(tp, BorderLayout.CENTER);

		} catch (Exception e) {
			System.out.println("9\b" + getClass().getName() + ".createGUI:\n\tCould not create GUI\n\t" + e.getMessage());
			e.printStackTrace();
		}
	}

	public void init() {
		try {
			if (SwingUtilities.isEventDispatchThread()) {
				createGUI();
			} else {
				javax.swing.SwingUtilities.invokeAndWait(new Runnable() {
					public void run() {
						createGUI();
					}
				});
			}
		} catch (Exception e) {
			System.out.println("9\b" + getClass().getName() + ".init:\n\tCould not create GUI\n\t" + e.getMessage());
			e.printStackTrace();
		}
	}

	public void stop() {
		try {
			properties.store(new FileOutputStream(propertiesFile), propertiesFile.getAbsolutePath());
		} catch (Exception e) {
			System.out.println("9\b" + getClass().getName() + ".stop:\n\tCould not save properties\n\t" + e.getMessage());
			e.printStackTrace();
		}
		super.stop();
	}
}
