package es.caib.ibkey.bpm.alfresco.handler;

import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.Map;

import org.alfresco.www.ws.model.content._1_0.Reference;
import org.alfresco.www.ws.model.content._1_0.Store;
import org.alfresco.www.ws.service.authentication._1_0.AuthenticationFault;
import org.alfresco.www.ws.service.repository._1_0.GetStores;
import org.alfresco.www.ws.service.repository._1_0.RepositoryFault;
import org.alfresco.www.ws.service.repository._1_0.RepositoryServiceSoapBindingStub;
import org.jbpm.graph.exe.ExecutionContext;
import es.caib.ibkey.alfresco.client.AlfrescoRepositoryClient;
import es.caib.ibkey.alfresco.ws.AuthenticationUtils;
import es.caib.ibkey.alfresco.ws.InternalErrorException;
import es.caib.ibkey.alfresco.ws.WebServiceFactory;
import es.caib.ibkey.alfresco.ws.WebServiceFactory.WebServiceFactoryConfig;
import es.caib.ibkey.bpm.common.IBkeyConfig;
import es.caib.ibkey.bpm.common.handler.AbstractIndexedHandler;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoAlfrescoUploadFile;

public class AlfrescoUploadFileHandler extends AbstractIndexedHandler{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	

	public void handleExecute(ExecutionContext executionContext) throws Exception {
		
		AlfrescoRepositoryClient alfresco=new AlfrescoRepositoryClient();
		StageInfoAlfrescoUploadFile stage=(StageInfoAlfrescoUploadFile)getStageActual();
		Map variables=executionContext.getContextInstance().getVariables();
		
		//autentiquem agafant propietats de sistema
		try {
			AuthenticationUtils.startSession(
					null
					,IBkeyConfig.getAlfrescoUser()
					,IBkeyConfig.getAlfrescoPassword()
					,Long.parseLong(IBkeyConfig.getAlfrescoWSTimeoutMilis()));
		} catch (AuthenticationFault e) {
			error(e.getMessage(),e);
			throw e;
		} catch (InternalErrorException e) {
			error(e.getMessage(),e);
			throw e;
		}

		//pujem el fitxer agafant les propietats del sistema
		try{
	    	String uuid=doBusiness(
	    			alfresco
	    			, null
	    			, stage.getDocumentName(variables)
	    			, stage.getDocumentTitle(variables)
	    			, stage.getDocumentDescription(variables)
	    			, stage.getDocumentAuthor(variables)
	    			, stage.getDocumentStoreScheme(variables)
	    			, stage.getDocumentStoreAddress(variables)
	    			, stage.getNodeParentPath(variables)
	    			, stage.getNodeName(variables)
	    			, getStageAnterior().getContentType()
	    			, stage.getEncoding(variables)
	    			, (byte[])getInputObject());
	    	stage.setAlfrescoNodeRefId(uuid);
	    }catch(Exception e){
	    	error(e.getMessage(),e);
	    	throw e;
	    }
		
	}

	protected void handleRollBack(ExecutionContext ctx) {
	
	}
	
	protected void freeResources(ExecutionContext ctx) {
		//tanquem sessió agafant propietats de sistema
    	try {
			AuthenticationUtils.endSession(null);
		} catch (InternalErrorException e) {
			error(e.getMessage(),e);
		}
	}
	/**
	 * Define la lógica de prueba de subir un fichero a alfresco
	 * @param author 
	 * @param description 
	 * @param title 
	 * @param name 
	 * @param documentStore 
	 * @param nodeParentPath 
	 * @param nodeName 
	 * @param documentMimeType 
	 * @param documentEncoding 
	 * @param _content 
	 * @param nodeName2 
	 * @throws InternalErrorException 
	 * @throws RemoteException 
	 * @throws UnsupportedEncodingException 
	 */
	private String doBusiness(
			AlfrescoRepositoryClient alfresco
			, WebServiceFactoryConfig config
			, String documentName
			, String documentTitle
			, String documentDescription
			, String documentAuthor
			, String documentStoreScheme
			, String documentStoreAddress
			, String nodeParentPath
			, String nodeName
			, String documentMimeType
			, String documentEncoding
			, byte [] content)
	throws RemoteException, InternalErrorException, UnsupportedEncodingException {
		RepositoryServiceSoapBindingStub repo=null;

			try {
				repo=WebServiceFactory.getRepositoryService(config);
			} catch (InternalErrorException e) {
				error(e.getMessage(),e);
				throw e;
			}

			Store stores[];
			try {
				stores = repo.getStores(new GetStores());
			} catch (RepositoryFault e) {
				error(e.getMessage(),e);
				throw e;
			} catch (RemoteException e) {
				error(e.getMessage(),e);
				throw e;
			}
			Store store = alfresco.selectStore(stores,documentStoreScheme,documentStoreAddress);
			Reference reference=alfresco.createContentNode(store,nodeParentPath,nodeName,documentName,documentTitle,documentDescription,documentAuthor);
			alfresco.uploadContent(store,reference,documentMimeType,documentEncoding,content);

			return reference.getUuid();
		
	}
		
	

}
