package es.caib.ibkey.bpm.alfresco.handler;

import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.bpm.vo.ProcessInstance;
import es.caib.ibkey.bpm.common.SyntaxQueryResolver;
import es.caib.ibkey.bpm.common.handler.NewIndexedProcessHandler;

	
public class NewIndexeUploadCustodyTiketToAlfrescoProcess extends NewIndexedProcessHandler {
	public String ISO9075AlfrescoPath=null;
	public String custodyURL=null;
	@Override
	protected void configureAdditionalProcessVariables(ExecutionContext ctx, ProcessInstance processInstance) throws SystemWorkflowException {
		super.configureAdditionalProcessVariables(ctx, processInstance);
		
		processInstance.getVariables().put("URL_CUSTODIA",SyntaxQueryResolver.resolve(custodyURL, ctx.getContextInstance().getVariables()));
		processInstance.getVariables().put("ALFRESCO_PATH",SyntaxQueryResolver.resolve(ISO9075AlfrescoPath, ctx.getContextInstance().getVariables()));
		
	}
}
