package es.caib.ibkey.bpm.common.handler;



import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidParameterException;

import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.attachment.AttachmentManager;
import es.caib.bpm.beans.remote.Document;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.bpm.toolkit.exception.UserWorkflowException;
import es.caib.ibkey.bpm.common.ContentTypeRegistry;
import es.caib.ibkey.bpm.common.SyntaxQueryResolver;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.bpm.document.stage.impl.StageInfoDocumentManager;


/**
 * Template per als handlers
 * 
 * @author u91940
 *
 */



public abstract class AbstractIndexedHandler extends LoggerActionHandler implements ActionHandler {


	/*variables que defineixen els codis dels paràmetres que utilitza el handler*/
	

	private  StageManager stgMgr=null;
	private  StageInfo stageActual=null;
	private  StageInfo stageAnterior=null;
	private  AttachmentManager attMgr=null;
	private transient ContentTypeRegistry mimeReg=null;

	/** Si s'estableix l'objecte de sortida, s'envia al document-manager i s'associa el document a l'stage actual **/
	private  InputStream outputObject=null;

	/** Objecte d'entrada, que pot ser gestionat per l'stageManager quan hasStageInput==true, o un altre objecte en cas contrari **/
	private  Object inputObject=null;

	/** Content-type de l'objecte d'entrada **/
	protected String inputContentType=null;

	/** Tag que adoptarà el stage actual **/
	private  String outputTag=null;
	
	/** Content-type del document associat al stage actual **/
	private  String outputContentType=null;
	
	/** OriginalName de el document associat a l'stage actual (només per a document-manager) **/
	private  String outputOriginalName=null;

	
	/** Permet configurar el stage a executar de forma no lineal **/
	private  String stageActualName=null;
	
	/** Indica si l'input ve gestionat per l'stage manager **/
	protected  Boolean hasStageInput=new Boolean(true);
	
	/** Indica si les excepcions han de seguir el circuit habitual, o s'ha de fer un signal per la sortida ERRROR**/
	private  Boolean handleRetry=new Boolean(false);

	/** Indica si s'ha de fer signal o no **/ 
	private boolean canSignal=true; 
	
	/** Especifica a quina sortida fer el signal quan ha funcionat correctament **/
	private String signalTo=null;
	
	/**indica si ya se había realizado la tarea con anterioridad. Sólo se puede saber si se ha establecido el parámetro  stageActualName**/
	protected boolean alreadyDone=false;
	

	/**
	 * Mètode plantilla de l'execució:
	 */
	public void execute(ExecutionContext ctx) throws Exception{
		super.execute(ctx);
		
		attMgr=new AttachmentManager(ctx.getContextInstance());
		

		//Obtenim l'stageManager i l'StageInfo actual
		//ctx.getContextInstance().getVariables()
		stgMgr=StageManager.getStageManager(ctx);
		if(stgMgr!=null){		
			
			if(stageActualName==null){
				//si no forcem un altre stage per a trencar la linelitat
				stageActual=stgMgr.findNextPendingStage();		
			}else{
				stageActualName=SyntaxQueryResolver.resolve(stageActualName, ctx.getContextInstance().getVariables());
				//si trenquem la linealitat
				stageActual=stgMgr.find(stageActualName);
				if(StageInfo.STATUS_DONE.equals(stageActual.getStatus())){
					alreadyDone=true;
				}
			}
			stageAnterior=stgMgr.findLastCompletedStage();
			stageActual.setPID(new Long(ctx.getProcessInstance().getId()));

		}else{			
				throw new BPMException("L'ús del Handler depen d'un workflow amb un StageManager", 1);
		}
		
		stageActualName=stageActual.getName();
		debug("StageActual: "+stageActual.getName());
		
		if(!alreadyDone){

			
			
			
			//establim el tag local, al stageInfo i a les variables del context
			if(stageActual!=null){
				if(stageActual.getTag()!=null){
		            /** Si l'stage actual espera associar el document a un tag en concret **/
					outputTag=stageActual.getTag();
				}else{
					outputTag=StageInfo.generateTag(ctx.getProcessInstance().getId());
				}
				stageActual.setTag(outputTag);
				
			}
			debug("stageActual.setTag("+stageActual.getTag()+")");
			//fi
		
			// Establim l'inputObject per a cadascun dels casos 
			if(hasStageInput.booleanValue()){
				// ve gestionat per l'StageManager 
				debug("hasStageInput: true");
				// Recibir la respuesta
				InputStream in = stageAnterior.getContentRetriever(ctx.getContextInstance()).getInputStream();  //java.io.FileOutputStream  a=new java.io.FileOutputStream("c:/util/ts_1.txt");int b; do {b=in.read();if(b!=-1)a.write(b);} while(b!=-1);a.close();
				ByteArrayOutputStream outputStream=new ByteArrayOutputStream();
				try{
					int len=-1;
					byte buff[]=new byte[512];
					do{
						len=in.read(buff);
						if(len!=-1)
							outputStream.write(buff,0,len);
					}while(len!=-1);
				}catch(Exception e){
					throw e;
				}finally{
					in.close();
				}
	
				inputObject=outputStream.toByteArray();
				inputContentType=stageAnterior.getContentType();
				debug("inputContentType: "+inputContentType);		
	
			}
			
			//establim el contentType de sortida. Té preferència el configurat al bean, i no al stage manager. Per defecte "text/plain"
			if(outputContentType==null && stageActual.getContentType()!=null){
				outputContentType=stageActual.getContentType();
			}else if(outputContentType!=null && stageActual.getContentType()==null){
				stageActual.setContentType(outputContentType);
			}else if((outputContentType!=null && stageActual.getContentType()!=null)){
				stageActual.setContentType(outputContentType);
			}else{
				outputContentType=inputContentType;
				stageActual.setContentType(outputContentType);
			}
	
			debug("stageActual.setContentType("+stageActual.getContentType()+")");
			
			
			try{
				debug("handleExecute() BEGIN ["+this.getClass().getName()+"]");
				handleExecute(ctx);
				debug("handleExecute() END ["+this.getClass().getName()+"]");
			
	
			
				/** gestionem l'outputObject **/
				if(outputObject!=null){
					debug("outputObject processing begin");
					stageActual.setTag(outputTag);
					stageActual.setContentType(outputContentType);
					
					debug("outputObject tag: "+stageActual.getTag());
					debug("outputObject contentType: "+stageActual.getContentType());
					debug("outputObject upload begin ");
					attMgr.uploadFile(outputObject,
							(outputContentType!=null)?outputContentType:"text/plain",
							(outputOriginalName!=null)?outputOriginalName:outputTag,
							outputTag);
					debug("outputObject upload end ");
					
				}
	
				stageActual.setStatus(StageInfo.STATUS_DONE);
				debug("outputObject processing end. Setting STATUS_DONE");
	
				
			}catch(Throwable th){
				debug("Exception: "+th.getMessage());
				debug("Exception: handleRollback() BEGIN ["+this.getClass().getName()+"]");
				//rollback 
				handleRollBack(ctx);
				debug("Exception: handleRollback() END ["+this.getClass().getName()+"]");
	
				//stageActual.setTag(null);
				stageActual.setStatus(StageInfo.STATUS_ERROR);
				debug("Exception: Setting STATUS_ERROR");
				
				stgMgr.update(ctx);
				
				debug("Exception: Updating StageManager");
				
				ctx.getContextInstance().setVariable("EXCEPTION",th);
				debug("Exception: Exporting exception");
				
				//control d'excepcions
				//permetem a l'usuari gestionar l'excepció en comptes d'enviar-ho per els circuits habituals 
				if(!handleRetry.booleanValue()){//handleRetry=true;
					debug("Exception: Default exception treatment");
					throw new SystemWorkflowException(th);
				}else{
					debug("Exception: Manual exception treatment");
					ctx.getProcessInstance().signal("ERROR");
					return;
				}
			}finally{
				debug("freeResources() BEGIN ["+this.getClass().getName()+"]");
				freeResources(ctx);
				debug("freeResources() END ["+this.getClass().getName()+"]");
			}
			
			//update
			stgMgr.update(ctx);
			debug("Updating StageManager");
		}else{
			debug("Indexed Node ("+stageActualName+") was executed previously.");
		}
		
		//fin de update
		if(this.canSignal()){
			if(signalTo!=null){
				debug("Manual signal treatment");
				ctx.getProcessInstance().signal(signalTo);
			}else{
				debug("Default signal treatment");
				ctx.getProcessInstance().signal();
			}
		}
	}

	protected abstract void freeResources(ExecutionContext ctx);

	public synchronized ContentTypeRegistry getMimeReg(){
		if(mimeReg==null)
			try {
				mimeReg=new ContentTypeRegistry();
			} catch (IOException e) {				
				error(e.getMessage(),e);
				return null;
			}
		return mimeReg;
	}
	
	/**
	 * Las subclases deben implementar este método para gestionar los errores
	 * @param ctx
	 * @throws Exception
	 */
	protected abstract void handleRollBack(ExecutionContext ctx) ;

	/**
	 * Las subclases deben implementar este método
	 * @param ctx
	 * @throws Exception
	 */
	protected abstract void handleExecute(ExecutionContext ctx) throws Exception;

	
	/**GETTERS I SETTERS **/
	
	
	/**
	 * @return the stgMgr
	 */
	protected synchronized StageManager getStgMgr() {
		return stgMgr;
	}

	/**
	 * @return the stageActual
	 */
	protected synchronized StageInfo getStageActual() {
		return stageActual;
	}

	/**
	 * @return the stageAnterior
	 */
	protected synchronized StageInfo getStageAnterior() {
		return stageAnterior;
	}

	/**
	 * @return the outputTag
	 */
	protected synchronized String getOutputTag() {
		return outputTag;
	}

	/**
	 * @param outputTag the outputTag to set
	 */
	protected synchronized void setOutputTag(String outputTag) {
		this.outputTag = outputTag;
		stageActual.setTag(outputTag);
	}

	/**
	 * @return the inputObject
	 */
	protected synchronized Object getInputObject() {
		return inputObject;
	}

	/**
	 * @param inputObject the inputObject to set
	 */
	protected synchronized void setInputObject(Object inputObject) {
		this.inputObject = inputObject;
	}

	/**
	 * @return the outputObject
	 */
	protected synchronized InputStream getOutputObject() {
		return outputObject;
	}

	/**
	 * @param outputObject the outputObject to set
	 */
	protected synchronized void setOutputObject(InputStream outputObject) {
		this.outputObject = outputObject;
	}

	/**
	 * @return the outputContentType
	 */
	protected synchronized String getOutputContentType() {
		return outputContentType;
	}

	/**
	 * @param outputContentType the outputContentType to set
	 */
	protected synchronized void setOutputContentType(String outputContentType) {
		this.outputContentType = outputContentType;
	}

	/**
	 * @return the outputOriginalName
	 */
	protected synchronized String getOutputOriginalName() {
		return outputOriginalName;
	}

	/**
	 * @param outputOriginalName the outputOriginalName to set
	 */
	protected synchronized void setOutputOriginalName(String outputOriginalName) {
		this.outputOriginalName = outputOriginalName;
	}

	/**
	 * @return the attMgr
	 */
	protected synchronized AttachmentManager getAttMgr() {
		return attMgr;
	}

	/**
	 * @return the stageActualName
	 */
	public synchronized String getStageActualName() {
		return stageActualName;
	}

	/**
	 * @param stageActualName the stageActualName to set
	 */
	public synchronized void setStageActualName(String stageActualName) {
		this.stageActualName = stageActualName;
	}

	public synchronized void setCanSignal(boolean can){
		this.canSignal=true;
	}
	
	public synchronized boolean canSignal(){
		return this.canSignal;
	}

	/**
	 * @return the handleRetry
	 */
	public Boolean getHandleRetry() {
		return handleRetry;
	}

	/**
	 * @param handleRetry the handleRetry to set
	 */
	public void setHandleRetry(Boolean handleRetry) {
		this.handleRetry = handleRetry;
	}

	/**
	 * @return the canSignal
	 */
	public boolean isCanSignal() {
		return canSignal;
	}

	/**
	 * @return the inputContentType
	 */
	public String getInputContentType() {
		return inputContentType;
	}

	/**
	 * @param inputContentType the inputContentType to set
	 */
	public void setInputContentType(String inputContentType) {
		this.inputContentType = inputContentType;
	}

	/**
	 * @return the signalTo
	 */
	public String getSignalTo() {
		return signalTo;
	}

	/**
	 * @param signalTo the signalTo to set
	 */
	public void setSignalTo(String signalTo) {
		this.signalTo = signalTo;
	}



}