package es.caib.ibkey.bpm.common.handler;



import java.util.Collection;
import java.util.Date;

import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;

import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.identity.seycon.IdentityManager;
import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.ibkey.bpm.common.IBkeyConfig;


/**
 * Template per als handlers
 * 
 * @author u91940
 *
 */



public class IbkeyBPMLoggerTemplate{
	
	protected String __processInstanceId="";
	private String __sendExceptionsTo=null;
	private boolean __mailSent=false;
	
	public void configure(ExecutionContext ctx) throws Exception{
		__processInstanceId=""+ctx.getProcessInstance().getId();
		__sendExceptionsTo=getAdminMailAdresses(ctx);
		__mailSent=false;
		
		String varName="P_ID";
		String ppid=null;
		do{
			
			ppid=(String)ctx.getVariable("P"+varName);
			if(ppid!=null)
				__processInstanceId=ppid+"->"+__processInstanceId;
			else
				break;
			varName="P"+varName;
		}while(ppid!=null);
	}
	
	public void debug(String message){
		Logger.getLogger(this.getClass()).debug("["+__processInstanceId+"] "+message);
	}
	
	public void warn(String message){
		Logger.getLogger(this.getClass()).warn("["+__processInstanceId+"] "+message);
	}
	
	public void error(String message,Throwable t){
		Logger.getLogger(this.getClass()).error("["+__processInstanceId+"] "+message,t);
		String stackMessage=exceptionToString(t);
		String subject="IBKEY - ERROR  ("+__processInstanceId+") "+t.getMessage();
		try {
			//miramos de no enviar más de un correo por el mismo error
			if(!__mailSent)
				sendMail(__sendExceptionsTo.split(";"),subject,stackMessage);
		} catch (Exception e) {
			Logger.getLogger(this.getClass()).error("["+__processInstanceId+"] Cannot send errors mail to administrators",t);
		}
	}
	private void sendMail(String recipients,  String subject, String text) throws Exception {
		sendMail(new String [] {recipients}, subject, text);
	}
	
	private void sendMail(String [] recipients,  String subject, String text) throws Exception {
		StringBuffer receivers=new StringBuffer(";");
		for(int i=0;i<recipients.length;i++){ receivers.append(recipients[i]); receivers.append(";"); }
		debug("sending email to '" + receivers.toString() + "' about '" + subject + "'");
	    
		Session session =(Session) new InitialContext().lookup(IBkeyConfig.getIbkeyMailServiceJNDIAddress());//java:es.caib.ibkey.mail
	    MimeMessage message = new MimeMessage(session);
	    
	    message.setFrom(new InternetAddress(IBkeyConfig.getIbkeyLoggerMailServiceSenderEmail()));
	    for(int i=0;i<recipients.length;i++)
	    {
	      InternetAddress recipient = new InternetAddress(recipients[i]);
	      message.addRecipient(Message.RecipientType.TO, recipient);
	    }
	    if (subject != null)
	    {
	      message.setSubject(subject);
	    }
	    if (text != null)
	    {
	      message.setText(text);
	    }
	    message.setSentDate(new Date());

	    Transport.send(message);	
	}

	public static String exceptionToString(Throwable ex) {
		StringBuffer trazaBuffer=new StringBuffer();
		String traza="";

		trazaBuffer.append(ex.getMessage());
		trazaBuffer.append("\n\n\n");
		
		  
		// Procedemos a montar la traza del error
		StackTraceElement[] steList;
		StackTraceElement ste;
		try
		{
		  Throwable t = (Throwable)ex;
		  steList = t.getStackTrace();         
		  if ((steList != null) && (steList.length > 0)) {           
		    for (int i=0;i<steList.length;i++) {
		      ste = steList[i];
		      if (ste != null) {
		        trazaBuffer.append(ste.toString());
		        trazaBuffer.append("\n");             
		      }
		    }           
		  }
		  else {
		     trazaBuffer.append("\nNo podemos recuperar la traza");          
		  }
		  
		  if(ex.getCause()!=null){
			  trazaBuffer.append("CAUDEB BY:\n");
			  trazaBuffer.append(exceptionToString(ex.getCause()));
		  }
		  
		}
		catch(Exception e)
		 {
		  trazaBuffer.append("\n\n");
		  trazaBuffer.append(e.toString());
		 }
		finally {
		  traza = trazaBuffer.toString();
		}
		
		return traza;
		
	};

	
	public String getAdminMailAdresses(ExecutionContext executionContext) throws SystemWorkflowException{
		try{
		    StringBuffer actors=new StringBuffer();
		    actors.append(IBkeyConfig.getIbkeyLoggerMailServiceAdditionalActors());
			IdentityManager idMgr=new IdentityManager();
		    Collection adminUsers=idMgr.obtenirUsuarisPerRolGrup("IBK_ADMINISTRADOR");
		    java.util.Iterator it=adminUsers.iterator();
		    boolean first=true;
		    while(it.hasNext()){
		    	es.caib.bpm.identity.vo.User user=(es.caib.bpm.identity.vo.User)it.next();
		    	if(!first){
		    		actors.append(";");
		    	}
	    		first=false;
		    	actors.append(user.getEmail());
		    }
		
		    return actors.toString();
	    }catch(Exception e){
			Logger.getLogger(this.getClass()).error("["+__processInstanceId+"] "+e.getMessage(),e);
	    	throw new es.caib.bpm.toolkit.exception.SystemWorkflowException(e);
	    }
	}
}