package es.caib.ibkey.bpm.common.handler;

import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import org.hibernate.Query;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ExecutionContext;

import es.caib.bpm.business.VOFactory;
import es.caib.bpm.entity.ProcessDefinitionProperty;
import es.caib.bpm.exception.BPMException;
import es.caib.bpm.toolkit.exception.SystemWorkflowException;
import es.caib.bpm.vo.ProcessDefinition;
import es.caib.bpm.vo.ProcessInstance;
import es.caib.ibkey.bpm.common.SyntaxQueryResolver;
import es.caib.ibkey.bpm.document.stage.StageInfo;
import es.caib.ibkey.bpm.document.stage.StageManager;
import es.caib.ibkey.bpm.document.stage.URLDescription;

public class NewIndexedProcessHandler extends LoggerActionHandler {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	
	protected String processDefinitionName;
	protected String processName;
	protected String processDescription;
	
	public void execute(ExecutionContext ctx) throws Exception{
		super.execute(ctx);

		
		StageManager manager = StageManager.getStageManager(ctx);
		String initiator=(String)ctx.getVariable("initiator");
		
		

		
		Map urls=initWorkflow(ctx,initiator, 
				SyntaxQueryResolver.resolve(processDefinitionName,ctx.getContextInstance().getVariables()),
				SyntaxQueryResolver.resolve(processName,ctx.getContextInstance().getVariables()),
				SyntaxQueryResolver.resolve(processDescription,ctx.getContextInstance().getVariables()),
				manager.getProcessName(),  manager.getDescription());
		
		for(Iterator it=urls.keySet().iterator();it.hasNext();){
			String key=(String)it.next();
			URLDescription urlDesc=(URLDescription)urls.get(key);
			manager.getDownloadURL().put(SyntaxQueryResolver.resolve(processName,ctx.getContextInstance().getVariables())+"_"+key, urlDesc);
		}
		//post-update
		manager.update(ctx);
		
		//signal
		ctx.getProcessInstance().signal();
		

			
			
			
	}

	protected Map initWorkflow(ExecutionContext ctx,String initiator,String processDefinitionName, String processName, String processDescription,String parentProcessName, String parentProcessDescription) throws SystemWorkflowException, BPMException{// throws SystemWorkflowException {


		Map workflowReturnValues=null;
	    ProcessDefinition def=null;

	    //inicialitzem el context
	    JbpmContext context = ctx.getJbpmContext();
	    

	    //creem el proces JBPM
		org.jbpm.graph.exe.ProcessInstance process=createJBPMProcess(context,processDefinitionName);
        ProcessInstance processVO=VOFactory.newProcessInstance(process);
		//inicialitzem l'StageManager
		StageManager manager=applyStageManager(context, processVO,processName,processDescription);
		//configura variables inicials
		configureInitialVariables(ctx, processVO, manager, initiator, parentProcessName, parentProcessDescription);
		//configura variables d'usuari. Metode a sobreescriure
		configureAdditionalProcessVariables(ctx,processVO);
		//update de les variables
		update(context, processVO);
		
		//start process
		debug("Start child process "+processVO.getId());
		process.signal();
    	context.save(process);
 //   	flushContext(context);
    	debug("Started child process "+processVO.getId());
    	
    	//refresh after execution
    	context = ctx.getJbpmContext();
    	process = context.getProcessInstance(process.getId());
        processVO=VOFactory.newProcessInstance(process);

        //retireve download URLS
        workflowReturnValues=((StageManager)processVO.getVariables().get(StageManager.CTX_VAR_NAME)).getDownloadURL();
   //     flushContext(context);
       	return workflowReturnValues;
	}
        
    private void configureInitialVariables( ExecutionContext ctx,ProcessInstance process, StageManager manager, String initiator,  String parentProcessName, String parentProcessDescription) {

		
		//posem la variable de context que identifica la data d'inici del procés
		process.getVariables().put("processStartDate",new Date());
		
		//posem la variable de context que identifica l'usuari que inicia el procés
		process.getVariables().put("initiator",initiator);

		
		//Establim una variable per a saber quin és el procés fill
		ctx.setVariable("C_ID", ""+process.getId());
		String parents="";
		String varName="PP_ID";
		String ppid=null;
		do{
			
			ppid=(String)ctx.getVariable(varName);
			if(ppid!=null)
				process.getVariables().put("P"+varName, ppid);
			else
				break;
			
			varName="P"+varName;
			
		}while(ppid!=null);
		process.getVariables().put("PP_ID", ""+ctx.getProcessInstance().getId());
		process.getVariables().put("PP_NAME", parentProcessName);
		process.getVariables().put("PP_DESC", parentProcessDescription);
		//process.getVariables().put("initiator", initiator );

		
	}

	private StageManager applyStageManager(JbpmContext context, ProcessInstance process, String processName, String processDescription) throws SystemWorkflowException {
    	byte [] sitexml=context.getProcessInstance(process.getId()).getProcessDefinition().getFileDefinition().getBytes("stageindex.xml");
		
		StageManager manager=new StageManager();
		try {
			manager.parseXML(new String(sitexml));
		} catch (Exception e) {
			error(e.getMessage(),e);
			throw new SystemWorkflowException(e);
		}
		
		debug("["+process.getId()+"] parsed stageInfos");
		((StageInfo)manager.getStageInfo(0)).setPID(new Long(process.getId()));

		if(process.getVariables()==null){
			Map variables=new Hashtable();
			process.setVariables(variables);
		}
		manager.setProcessName(processName);
		manager.setDescription(processDescription);

		//posem el stagemanager a les variables de context
		process.getVariables().put(StageManager.CTX_VAR_NAME, manager);
		
		return manager;
	}

	private org.jbpm.graph.exe.ProcessInstance createJBPMProcess(JbpmContext context, String name) throws BPMException {
    	try{
			debug("creating child process "+processDefinitionName);
	    	org.jbpm.graph.def.ProcessDefinition definition = context.getGraphSession().findLatestProcessDefinition(name);
	        
	        ProcessDefinitionProperty prop = getProcessDefinitionDisabledProperty(context, definition);
	        if (prop != null &&
	        		"true".equals(prop.getValue()))
	        	throw new BPMException("This process has been disabled", 2);
	
	        
	        org.jbpm.graph.exe.ProcessInstance pi = new org.jbpm.graph.exe.ProcessInstance(definition);
	
	        
	        debug("["+pi.getId()+"] created new process");
			return pi;
			
    	}catch(BPMException e){
    		error(e.getMessage(),e);
    		throw e;
    	}

	}

	protected JbpmContext createContext() {
        JbpmContext myContext = JbpmConfiguration.getInstance().createJbpmContext();
        myContext.setActorId("ibkey");
        return myContext;
    }

    private ProcessDefinitionProperty getProcessDefinitionDisabledProperty(JbpmContext context, org.jbpm.graph.def.ProcessDefinition def) {
		ProcessDefinitionProperty prop;
		Query q = context.getSession().createQuery("select pdp "+
		        "from es.caib.bpm.entity.ProcessDefinitionProperty pdp "+
		        "where pdp.name = 'disabled' and pdp.processDefinitionId=:id ");
		q.setParameter("id", new Long(def.getId()));
		prop = (ProcessDefinitionProperty) q.uniqueResult();
		return prop;
	}
    
    public void update (JbpmContext context,es.caib.bpm.vo.ProcessInstance process) throws BPMException {

    	try{
	            org.jbpm.graph.exe.ProcessInstance pi = context.loadProcessInstance(process.getId());
	            if ( 
	                pi.getRootToken().getNode().getId() !=
	            	pi.getProcessDefinition().getStartState().getId())
	            {
	                throw new BPMException("No es pot modificar un procés ja iniciat",-1);
	            }
	
	            ContextInstance ctx = pi.getContextInstance();
	            HashMap map = new HashMap();
	                
	            if(process.getVariables()!=null)
	            	map.putAll(process.getVariables());
	            
	            if(ctx.getVariables()!=null){
	                // Borrar y modificar variables
	                for (Iterator it = ctx.getVariables().keySet().iterator(); it
	                        .hasNext();) {
	                    String key = (String) it.next();
	                    Object value = map.get(key); //PJR canvio value=map.get(key) : això no feia un update!
	                    ctx.setVariable(key, value);
	                    map.remove(key);
	                }
	            }
	            
	            // Agregar variables
	            for (Iterator it = map.keySet().iterator(); it.hasNext();) {
	                String key = (String) it.next();
	                Object value = map.get(key);
	                ctx.setVariable(key, value);
	            }
	        	context.save(pi);
		}catch(BPMException e){
			error(e.getMessage(),e);
			throw e;
		}

    }
    
    protected void configureAdditionalProcessVariables(ExecutionContext ctx,ProcessInstance processInstance) throws SystemWorkflowException {
		
		
	}

    private void flushContext(JbpmContext myContext)  {
        if (myContext != null) {
            myContext.setActorId(null);
            try {
                myContext.close();
            } finally {
            	myContext = null;
            }
        }
    }	
}
